/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddLdapConnection
implements OnlineCommand,
OfflineCommand {
    private final String connectionName;
    private final List<String> handlesReferralsFor;
    private final String initialContextFactory;
    private final String referrals;
    private final String searchCredential;
    private final String searchDn;
    private final String securityRealm;
    private final String url;
    private final boolean replaceExisting;
    private final Map<String, String> properties;

    private AddLdapConnection(Builder builder) {
        this.connectionName = builder.connectionName;
        this.handlesReferralsFor = builder.handlesReferralsFor;
        this.initialContextFactory = builder.initialContextFactory;
        this.referrals = builder.referrals;
        this.searchCredential = builder.searchCredential;
        this.searchDn = builder.searchDn;
        this.securityRealm = builder.securityRealm;
        this.url = builder.url;
        this.replaceExisting = builder.replaceExisting;
        this.properties = builder.properties;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Operations ops = new Operations(ctx.client);
        Address ldapConnection = Address.coreService((String)"management").and("ldap-connection", this.connectionName);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(ldapConnection);
                new Administration(ctx.client).reloadIfRequired();
            }
            catch (OperationException e) {
                throw new IOException("Failed to LDAP outbound connection " + this.connectionName, e);
            }
        }
        List<String> resolvedHandlesReferralsFor = this.handlesReferralsFor != null && !this.handlesReferralsFor.isEmpty() ? this.handlesReferralsFor : null;
        Batch batch = new Batch();
        batch.add(ldapConnection, Values.empty().andOptional("name", this.connectionName).andOptional("handles-referrals-for", this.initialContextFactory).andOptional("initial-context-factory", this.initialContextFactory).andOptional("referrals", this.referrals).andOptional("search-credential", this.searchCredential).andOptional("search-dn", this.searchDn).andOptional("security-realm", this.securityRealm).andOptional("url", this.url).andListOptional(String.class, "handles-referrals-for", resolvedHandlesReferralsFor));
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                batch.add(ldapConnection.and("property", entry.getKey()), Values.empty().and("value", entry.getValue()));
            }
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddLdapConnection.class).subtree("management", Subtree.management()).parameter("atrConnectionName", this.connectionName).parameter("atrHandlesReferralsFor", this.handlesReferralsFor).parameter("atrInitialContextFactory", this.initialContextFactory).parameter("atrReferrals", this.referrals).parameter("atrSearchCredential", this.searchCredential).parameter("atrSearchDn", this.searchDn).parameter("atrSecurityRealm", this.securityRealm).parameter("atrUrl", this.url).parameter("atrReplaceExisting", this.replaceExisting).parameter("atrProperties", this.properties).build()});
    }

    public static final class Builder {
        private final String connectionName;
        private List<String> handlesReferralsFor = new ArrayList<String>();
        private String initialContextFactory;
        private String referrals;
        private String searchCredential;
        private String searchDn;
        private String securityRealm;
        private String url;
        private boolean replaceExisting;
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        public Builder(String connectionName) {
            if (connectionName == null) {
                throw new IllegalArgumentException("Connection name must be specified as non null value");
            }
            if (connectionName.isEmpty()) {
                throw new IllegalArgumentException("Connection name must not be empty value");
            }
            this.connectionName = connectionName;
        }

        public Builder initialContextFactory(String initialContextFactory) {
            this.initialContextFactory = initialContextFactory;
            return this;
        }

        public Builder referrals(String referrals) {
            this.referrals = referrals;
            return this;
        }

        public Builder searchCredential(String searchCredential) {
            this.searchCredential = searchCredential;
            return this;
        }

        public Builder searchDn(String searchDn) {
            this.searchDn = searchDn;
            return this;
        }

        public Builder securityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder addHandlesReferralsFor(String handlesReferralsFor) {
            this.handlesReferralsFor.add(handlesReferralsFor);
            return this;
        }

        public Builder setHandlesReferralsFor(List<String> handlesReferralsFor) {
            this.handlesReferralsFor = handlesReferralsFor;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public AddLdapConnection build() {
            if (this.url == null) {
                throw new IllegalArgumentException("Url attribute must be specified as non null value");
            }
            if (this.url.isEmpty()) {
                throw new IllegalArgumentException("Url attribute must not be empty value");
            }
            return new AddLdapConnection(this);
        }
    }
}

