/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.auth;

import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.extras.springsecurity6.auth.AuthUtils;
import org.thymeleaf.util.Validate;

public final class Authorization {
    private final IExpressionContext context;
    private final Authentication authentication;

    public Authorization(IExpressionContext context, Authentication authentication) {
        this.context = context;
        this.authentication = authentication;
    }

    public IExpressionContext getContext() {
        return this.context;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean expr(String expression) {
        return this.expression(expression);
    }

    public boolean expression(String expression) {
        Validate.notEmpty((String)expression, (String)"Access expression cannot be null");
        return AuthUtils.authorizeUsingAccessExpression(this.context, expression, this.authentication);
    }

    public boolean url(String url) {
        return this.url("GET", url);
    }

    public boolean url(String method, String url) {
        Validate.notEmpty((String)url, (String)"URL cannot be null");
        return AuthUtils.authorizeUsingUrlCheck(this.context, url, method, this.authentication);
    }
}

