/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ParameterizableViewController
extends AbstractController {
    private Object view;
    private HttpStatus statusCode;
    private boolean statusOnly;

    public void setViewName(String viewName) {
        this.view = viewName;
    }

    public String getViewName() {
        return this.view instanceof String ? (String)this.view : null;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view instanceof View ? (View)this.view : null;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public void setStatusOnly(boolean statusOnly) {
        this.statusOnly = statusOnly;
    }

    public boolean isStatusOnly() {
        return this.statusOnly;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = this.getViewName();
        if (this.getStatusCode() != null) {
            if (this.getStatusCode().is3xxRedirection()) {
                request.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)this.getStatusCode());
                viewName = viewName != null && !viewName.startsWith("redirect:") ? "redirect:" + viewName : viewName;
            } else {
                response.setStatus(this.getStatusCode().value());
                if (this.isStatusOnly() || this.getStatusCode().equals((Object)HttpStatus.NO_CONTENT) && this.getViewName() == null) {
                    return null;
                }
            }
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addAllObjects(RequestContextUtils.getInputFlashMap(request));
        if (this.getViewName() != null) {
            modelAndView.setViewName(viewName);
        } else {
            modelAndView.setView(this.getView());
        }
        return this.isStatusOnly() ? null : modelAndView;
    }
}

