/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.web.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriTemplate {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private static final String VALUE_REGEX = "(.*)";
    private final List<String> variableNames;
    private final Pattern matchPattern;
    private final String uriTemplate;

    public UriTemplate(String uriTemplate) {
        Parser parser = new Parser(uriTemplate);
        this.uriTemplate = uriTemplate;
        this.variableNames = parser.getVariableNames();
        this.matchPattern = parser.getMatchPattern();
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public URI expand(Map<String, ?> uriVariables) {
        Assert.notNull(uriVariables, (String)"'uriVariables' must not be null");
        Object[] values = new String[this.variableNames.size()];
        int i = 0;
        while (i < this.variableNames.size()) {
            String name = this.variableNames.get(i);
            if (!uriVariables.containsKey(name)) {
                throw new IllegalArgumentException("'uriVariables' Map has no value for '" + name + "'");
            }
            values[i] = uriVariables.get(name);
            ++i;
        }
        return this.expand(values);
    }

    public URI expand(Object ... uriVariableValues) {
        Assert.notNull((Object)uriVariableValues, (String)"'uriVariableValues' must not be null");
        if (uriVariableValues.length != this.variableNames.size()) {
            throw new IllegalArgumentException("Invalid amount of variables values in [" + this.uriTemplate + "]: expected " + this.variableNames.size() + "; got " + uriVariableValues.length);
        }
        Matcher matcher = NAMES_PATTERN.matcher(this.uriTemplate);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (matcher.find()) {
            Object uriVariable;
            String replacement = Matcher.quoteReplacement((uriVariable = uriVariableValues[i++]) != null ? uriVariable.toString() : "");
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return this.encodeUri(buffer.toString());
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return false;
        }
        Matcher matcher = this.matchPattern.matcher(uri);
        return matcher.matches();
    }

    public Map<String, String> match(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variableNames.size());
        Matcher matcher = this.matchPattern.matcher(uri);
        if (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                String name = this.variableNames.get(i - 1);
                String value = matcher.group(i);
                result.put(name, value);
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        return this.uriTemplate;
    }

    protected URI encodeUri(String uri) {
        try {
            String encoded = UriUtils.encodeUri(uri, "UTF-8");
            return new URI(encoded);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Could not create URI from [" + uri + "]: " + ex, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parser {
        private final List<String> variableNames = new LinkedList<String>();
        private final StringBuilder patternBuilder = new StringBuilder();

        private Parser(String uriTemplate) {
            Assert.hasText((String)uriTemplate, (String)"'uriTemplate' must not be null");
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            int end = 0;
            while (m.find()) {
                this.patternBuilder.append(this.quote(uriTemplate, end, m.start()));
                this.patternBuilder.append(UriTemplate.VALUE_REGEX);
                this.variableNames.add(m.group(1));
                end = m.end();
            }
            this.patternBuilder.append(this.quote(uriTemplate, end, uriTemplate.length()));
            int lastIdx = this.patternBuilder.length() - 1;
            if (lastIdx >= 0 && this.patternBuilder.charAt(lastIdx) == '/') {
                this.patternBuilder.deleteCharAt(lastIdx);
            }
        }

        private String quote(String fullPath, int start, int end) {
            if (start == end) {
                return "";
            }
            return Pattern.quote(fullPath.substring(start, end));
        }

        private List<String> getVariableNames() {
            return Collections.unmodifiableList(this.variableNames);
        }

        private Pattern getMatchPattern() {
            return Pattern.compile(this.patternBuilder.toString());
        }
    }
}

