/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.http;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.mock.http.MockHttpOutputMessage;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

@Deprecated(since="7.0", forRemoval=true)
public class HttpMessageContentConverter
implements JsonConverterDelegate {
    private static final MediaType JSON = MediaType.APPLICATION_JSON;
    private final List<HttpMessageConverter<?>> messageConverters;

    HttpMessageContentConverter(Iterable<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = StreamSupport.stream(messageConverters.spliterator(), false).toList();
        Assert.notEmpty(this.messageConverters, (String)"At least one message converter needs to be specified");
    }

    public static HttpMessageContentConverter of(Iterable<HttpMessageConverter<?>> candidates) {
        return new HttpMessageContentConverter(candidates);
    }

    public static HttpMessageContentConverter of(HttpMessageConverter<?> ... candidates) {
        return new HttpMessageContentConverter(Arrays.asList(candidates));
    }

    @Override
    public <T> T read(String content, ResolvableType targetType) throws IOException {
        MockHttpInputMessage message = new MockHttpInputMessage(content.getBytes(StandardCharsets.UTF_8));
        message.getHeaders().add("Content-Type", "application/json");
        return this.convert(message, MediaType.APPLICATION_JSON, targetType);
    }

    @Override
    public <T> T map(Object value, ResolvableType targetType) throws IOException {
        return this.convertViaJson(value, targetType);
    }

    public <T> T convert(HttpInputMessage message, MediaType mediaType, ResolvableType targetType) throws IOException, HttpMessageNotReadableException {
        Class<Object> contextClass = targetType.getRawClass();
        SingletonSupplier javaType = SingletonSupplier.of(() -> ((ResolvableType)targetType).getType());
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            if (messageConverter instanceof GenericHttpMessageConverter) {
                GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)messageConverter;
                Type type = (Type)javaType.obtain();
                if (!genericMessageConverter.canRead(type, contextClass, mediaType)) continue;
                return (T)genericMessageConverter.read(type, contextClass, message);
            }
            if (messageConverter instanceof SmartHttpMessageConverter) {
                SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)messageConverter;
                if (!smartMessageConverter.canRead(targetType, mediaType)) continue;
                return (T)smartMessageConverter.read(targetType, message, null);
            }
            Class<Object> targetClass = contextClass != null ? contextClass : Object.class;
            if (!messageConverter.canRead(targetClass, mediaType)) continue;
            HttpMessageConverter<?> simpleMessageConverter = messageConverter;
            Class<Object> clazz = targetClass;
            return (T)simpleMessageConverter.read(clazz, message);
        }
        throw new IllegalStateException("No converter found to read [%s] to [%s]".formatted(mediaType, targetType));
    }

    public <T> T convertViaJson(Object value, ResolvableType targetType) throws IOException {
        MockHttpOutputMessage outputMessage = this.convertToJson(value, ResolvableType.forInstance((Object)value));
        return this.convert(HttpMessageContentConverter.fromHttpOutputMessage(outputMessage), JSON, targetType);
    }

    private MockHttpOutputMessage convertToJson(Object value, ResolvableType valueType) throws IOException {
        MockHttpOutputMessage outputMessage = new MockHttpOutputMessage();
        Class<?> valueClass = value.getClass();
        SingletonSupplier javaType = SingletonSupplier.of(() -> ((ResolvableType)valueType).getType());
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            if (messageConverter instanceof GenericHttpMessageConverter) {
                GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)messageConverter;
                Type type = (Type)javaType.obtain();
                if (!genericMessageConverter.canWrite(type, valueClass, JSON)) continue;
                genericMessageConverter.write(value, type, JSON, (HttpOutputMessage)outputMessage);
                return outputMessage;
            }
            if (messageConverter instanceof SmartHttpMessageConverter) {
                SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)messageConverter;
                if (!smartMessageConverter.canWrite(valueType, valueClass, JSON)) continue;
                smartMessageConverter.write(value, valueType, JSON, (HttpOutputMessage)outputMessage, null);
                return outputMessage;
            }
            if (!messageConverter.canWrite(valueClass, JSON)) continue;
            messageConverter.write(value, JSON, (HttpOutputMessage)outputMessage);
            return outputMessage;
        }
        throw new IllegalStateException("No converter found to convert [%s] to JSON".formatted(valueType));
    }

    private static HttpInputMessage fromHttpOutputMessage(MockHttpOutputMessage message) {
        MockHttpInputMessage inputMessage = new MockHttpInputMessage(message.getBodyAsBytes());
        inputMessage.getHeaders().addAll(message.getHeaders());
        return inputMessage;
    }
}

