/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.bean.override.BeanOverrideBeanFactoryPostProcessor;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.test.context.bean.override.WrapEarlyBeanPostProcessor;

class BeanOverrideContextCustomizer
implements ContextCustomizer {
    private static final String INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverridePostProcessor";
    private static final String EARLY_INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalWrapEarlyBeanPostProcessor";
    private final Set<BeanOverrideHandler> handlers;

    BeanOverrideContextCustomizer(Set<BeanOverrideHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        BeanOverrideRegistry beanOverrideRegistry = new BeanOverrideRegistry((ConfigurableBeanFactory)beanFactory);
        beanFactory.registerSingleton("org.springframework.test.context.bean.override.internalBeanOverrideRegistry", (Object)beanOverrideRegistry);
        beanFactory.registerSingleton(INFRASTRUCTURE_BEAN_NAME, (Object)new BeanOverrideBeanFactoryPostProcessor(this.handlers, beanOverrideRegistry));
        beanFactory.registerSingleton(EARLY_INFRASTRUCTURE_BEAN_NAME, (Object)new WrapEarlyBeanPostProcessor(beanOverrideRegistry));
    }

    Set<BeanOverrideHandler> getBeanOverrideHandlers() {
        return this.handlers;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        BeanOverrideContextCustomizer that = (BeanOverrideContextCustomizer)other;
        return this.handlers.equals(that.handlers);
    }

    public int hashCode() {
        return this.handlers.hashCode();
    }
}

