/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.function.support;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;

public abstract class AbstractResultCollector<T, S>
implements ResultCollector<T, S> {
    protected static final String NOT_IMPLEMENTED = "Not Implemented";
    protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private AtomicBoolean resultsEnded = new AtomicBoolean(false);
    private S result = null;

    public synchronized S getResult() throws FunctionException {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getResult(long duration, TimeUnit unit) throws FunctionException, InterruptedException {
        unit = this.resolveTimeUnit(unit);
        long durationInMilliseconds = unit.toMillis(duration);
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        long waitInMilliseconds = Math.max(50L, Math.min(durationInMilliseconds / 5L, durationInMilliseconds));
        AbstractResultCollector abstractResultCollector = this;
        synchronized (abstractResultCollector) {
            while (this.getResult() == null && System.currentTimeMillis() < timeout) {
                unit.timedWait(this, waitInMilliseconds);
            }
        }
        return this.getResult();
    }

    protected synchronized void setResult(S result) {
        this.result = result;
    }

    protected TimeUnit resolveTimeUnit(TimeUnit unit) {
        return unit != null ? unit : DEFAULT_TIME_UNIT;
    }

    public void clearResults() {
        this.setResult(null);
    }

    public void endResults() {
        this.resultsEnded.set(true);
    }

    protected boolean hasResultsEnded() {
        return this.resultsEnded.get();
    }

    protected boolean hasResultsNotEnded() {
        return !this.resultsEnded.get();
    }
}

