/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.repository.CrudRepository;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RepositoryAsyncEventListener<T, ID>
implements AsyncEventListener {
    protected static final AsyncEventErrorHandler DEFAULT_ASYNC_EVENT_ERROR_HANDLER = eventError -> false;
    private AsyncEventErrorHandler asyncEventErrorHandler = DEFAULT_ASYNC_EVENT_ERROR_HANDLER;
    private final AtomicBoolean hasFired = new AtomicBoolean(false);
    private final AtomicLong firedCount = new AtomicLong(0L);
    private final CrudRepository<T, ID> repository;
    private final List<AsyncEventOperationRepositoryFunction<T, ID>> repositoryFunctions = new CopyOnWriteArrayList<AsyncEventOperationRepositoryFunction<T, ID>>();

    public RepositoryAsyncEventListener(@NonNull CrudRepository<T, ID> repository) {
        Assert.notNull(repository, (String)"CrudRepository must not be null");
        this.repository = repository;
        this.repositoryFunctions.addAll(Arrays.asList(new CreateUpdateAsyncEventRepositoryFunction(this), new RemoveAsyncEventRepositoryFunction(this)));
    }

    public boolean hasFired() {
        return this.getFiredCount() > 0L;
    }

    public boolean hasFiredSinceLastCheck() {
        return this.hasFired.compareAndSet(true, false);
    }

    public long getFiredCount() {
        return this.firedCount.get();
    }

    public void setAsyncEventErrorHandler(@Nullable AsyncEventErrorHandler asyncEventErrorHandler) {
        this.asyncEventErrorHandler = asyncEventErrorHandler;
    }

    @NonNull
    protected AsyncEventErrorHandler getAsyncEventErrorHandler() {
        return this.asyncEventErrorHandler != null ? this.asyncEventErrorHandler : DEFAULT_ASYNC_EVENT_ERROR_HANDLER;
    }

    @NonNull
    protected CrudRepository<T, ID> getRepository() {
        return this.repository;
    }

    @NonNull
    protected List<AsyncEventOperationRepositoryFunction<T, ID>> getRepositoryFunctions() {
        return this.repositoryFunctions;
    }

    public final boolean processEvents(List<AsyncEvent> events) {
        try {
            boolean bl = this.doProcessEvents(events);
            return bl;
        }
        finally {
            this.firedCount.incrementAndGet();
            this.hasFired.set(true);
        }
    }

    protected boolean doProcessEvents(List<AsyncEvent> events) {
        AtomicBoolean result = new AtomicBoolean(true);
        CollectionUtils.nullSafeList(events).stream().filter(Objects::nonNull).forEach(event -> {
            Optional<AsyncEventOperationRepositoryFunction> repositoryFunction = this.getRepositoryFunctions().stream().filter(function -> function.canProcess(event)).findFirst();
            boolean processed = Boolean.TRUE.equals(repositoryFunction.map(function -> (Boolean)function.apply(event)).orElse(false));
            result.compareAndSet(true, processed);
        });
        return result.get();
    }

    public boolean register(@NonNull AsyncEventOperationRepositoryFunction<T, ID> repositoryFunction) {
        if (repositoryFunction != null) {
            this.getRepositoryFunctions().add(0, repositoryFunction);
            return true;
        }
        return false;
    }

    public boolean unregister(@Nullable AsyncEventOperationRepositoryFunction<T, ID> repositoryFunction) {
        return this.getRepositoryFunctions().remove(repositoryFunction);
    }

    public static class RemoveAsyncEventRepositoryFunction<T, ID>
    extends AbstractAsyncEventOperationRepositoryFunction<T, ID> {
        public RemoveAsyncEventRepositoryFunction(@NonNull RepositoryAsyncEventListener<T, ID> listener) {
            super(listener);
        }

        @Override
        public boolean canProcess(@Nullable AsyncEvent<ID, T> event) {
            Operation operation = event != null ? event.getOperation() : null;
            return Operation.REMOVE.equals(operation);
        }

        @Override
        protected <R> R doRepositoryOp(T entity) {
            this.getRepository().delete(entity);
            return null;
        }
    }

    public static class CreateUpdateAsyncEventRepositoryFunction<T, ID>
    extends AbstractAsyncEventOperationRepositoryFunction<T, ID> {
        public CreateUpdateAsyncEventRepositoryFunction(@NonNull RepositoryAsyncEventListener<T, ID> listener) {
            super(listener);
        }

        @Override
        public boolean canProcess(@Nullable AsyncEvent<ID, T> event) {
            Operation operation = event != null ? event.getOperation() : null;
            return operation != null && (operation.isCreate() || operation.isUpdate());
        }

        @Override
        protected <R> R doRepositoryOp(T entity) {
            return (R)this.getRepository().save(entity);
        }
    }

    public static abstract class AbstractAsyncEventOperationRepositoryFunction<T, ID>
    implements AsyncEventOperationRepositoryFunction<T, ID> {
        private final RepositoryAsyncEventListener<T, ID> listener;

        public AbstractAsyncEventOperationRepositoryFunction(@NonNull RepositoryAsyncEventListener<T, ID> listener) {
            Assert.notNull(listener, (String)"RepositoryAsyncEventListener must not be null");
            this.listener = listener;
        }

        protected AsyncEventErrorHandler getErrorHandler() {
            return this.getListener().getAsyncEventErrorHandler();
        }

        @NonNull
        protected RepositoryAsyncEventListener<T, ID> getListener() {
            return this.listener;
        }

        @NonNull
        protected CrudRepository<T, ID> getRepository() {
            return this.getListener().getRepository();
        }

        @Override
        public Boolean apply(@Nullable AsyncEvent<ID, T> event) {
            try {
                if (this.canProcess(event)) {
                    T entity = this.resolveEntity(event);
                    this.doRepositoryOp(entity);
                    return true;
                }
                return false;
            }
            catch (Throwable cause) {
                return (Boolean)this.getErrorHandler().apply(new AsyncEventError(event, cause));
            }
        }

        protected abstract <R> R doRepositoryOp(@NonNull T var1);

        protected T resolveEntity(@NonNull AsyncEvent<ID, T> event) {
            Assert.notNull(event, (String)"AsyncEvent must not be null");
            Object entity = event.getDeserializedValue();
            Assert.state((entity != null ? 1 : 0) != 0, (String)"The entity (deserialized value) was null");
            return (T)entity;
        }
    }

    @FunctionalInterface
    public static interface AsyncEventOperationRepositoryFunction<T, ID>
    extends Function<AsyncEvent<ID, T>, Boolean> {
        default public boolean canProcess(@Nullable AsyncEvent<ID, T> event) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface AsyncEventErrorHandler
    extends Function<AsyncEventError, Boolean> {
    }

    public static class AsyncEventError {
        private final AsyncEvent<?, ?> event;
        private final Throwable cause;

        public AsyncEventError(@NonNull AsyncEvent<?, ?> event, @NonNull Throwable cause) {
            Assert.notNull(event, (String)"AsyncEvent must not be null");
            Assert.notNull((Object)cause, (String)"Cause must not be null");
            this.event = event;
            this.cause = cause;
        }

        @NonNull
        public Throwable getCause() {
            return this.cause;
        }

        @NonNull
        public AsyncEvent<?, ?> getEvent() {
            return this.event;
        }

        public String toString() {
            return String.format("Error [%s] thrown when processing AsyncEvent [%s]", this.getCause().getMessage(), this.getEvent());
        }
    }
}

