/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CompositeIterator;
import org.springframework.util.ObjectUtils;

public final class ExposedFields
implements Iterable<ExposedField> {
    private static final List<ExposedField> NO_FIELDS = Collections.emptyList();
    private static final ExposedFields EMPTY = new ExposedFields(NO_FIELDS, NO_FIELDS);
    private final List<ExposedField> originalFields;
    private final List<ExposedField> syntheticFields;

    public static ExposedFields empty() {
        return EMPTY;
    }

    public static ExposedFields from(ExposedField ... fields) {
        return ExposedFields.from(Arrays.asList(fields));
    }

    private static ExposedFields from(List<ExposedField> fields) {
        ExposedFields result = EMPTY;
        for (ExposedField field : fields) {
            result = result.and(field);
        }
        return result;
    }

    public static ExposedFields synthetic(Fields fields) {
        return ExposedFields.createFields(fields, true);
    }

    public static ExposedFields nonSynthetic(Fields fields) {
        return ExposedFields.createFields(fields, false);
    }

    private static ExposedFields createFields(Fields fields, boolean synthetic) {
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        ArrayList<ExposedField> result = new ArrayList<ExposedField>();
        for (Field field : fields) {
            result.add(new ExposedField(field, synthetic));
        }
        return ExposedFields.from(result);
    }

    private ExposedFields(List<ExposedField> originals, List<ExposedField> synthetic) {
        this.originalFields = originals;
        this.syntheticFields = synthetic;
    }

    public ExposedFields and(ExposedField field) {
        Assert.notNull((Object)field, (String)"Exposed field must not be null!");
        ArrayList<ExposedField> result = new ArrayList<ExposedField>();
        result.addAll(field.synthetic ? this.syntheticFields : this.originalFields);
        result.add(field);
        return new ExposedFields(field.synthetic ? this.originalFields : result, field.synthetic ? result : this.syntheticFields);
    }

    @Nullable
    public ExposedField getField(String name) {
        for (ExposedField field : this) {
            if (!field.canBeReferredToBy(name)) continue;
            return field;
        }
        return null;
    }

    boolean exposesNoNonSyntheticFields() {
        return this.originalFields.isEmpty();
    }

    boolean exposesSingleNonSyntheticFieldOnly() {
        return this.originalFields.size() == 1;
    }

    boolean exposesNoFields() {
        return this.exposedFieldsCount() == 0;
    }

    boolean exposesSingleFieldOnly() {
        return this.exposedFieldsCount() == 1;
    }

    private int exposedFieldsCount() {
        return this.originalFields.size() + this.syntheticFields.size();
    }

    @Override
    public Iterator<ExposedField> iterator() {
        CompositeIterator iterator = new CompositeIterator();
        if (!this.syntheticFields.isEmpty()) {
            iterator.add(this.syntheticFields.iterator());
        }
        if (!this.originalFields.isEmpty()) {
            iterator.add(this.originalFields.iterator());
        }
        return iterator;
    }

    static class ExpressionFieldReference
    implements FieldReference {
        private FieldReference delegate;

        public ExpressionFieldReference(FieldReference field) {
            this.delegate = field;
        }

        @Override
        public String getRaw() {
            return this.delegate.getRaw();
        }

        @Override
        public Object getReferenceValue() {
            return this.delegate.getReferenceValue();
        }

        public String toString() {
            String fieldRef = this.delegate.toString();
            if (fieldRef.startsWith("$$")) {
                return fieldRef;
            }
            if (fieldRef.startsWith("$")) {
                return "$" + fieldRef;
            }
            return fieldRef;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExpressionFieldReference)) {
                return false;
            }
            ExpressionFieldReference that = (ExpressionFieldReference)obj;
            return ObjectUtils.nullSafeEquals((Object)this.delegate, (Object)that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    static class DirectFieldReference
    implements FieldReference {
        private final ExposedField field;

        public DirectFieldReference(ExposedField field) {
            Assert.notNull((Object)field, (String)"ExposedField must not be null!");
            this.field = field;
        }

        @Override
        public String getRaw() {
            String target = this.field.getTarget();
            return this.field.synthetic ? target : String.format("%s.%s", "_id", target);
        }

        @Override
        public Object getReferenceValue() {
            return this.field.synthetic && !this.field.isAliased() ? Integer.valueOf(1) : this.toString();
        }

        public String toString() {
            if (this.getRaw().startsWith("$")) {
                return this.getRaw();
            }
            return String.format("$%s", this.getRaw());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DirectFieldReference)) {
                return false;
            }
            DirectFieldReference that = (DirectFieldReference)obj;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }

    public static interface FieldReference {
        public String getRaw();

        public Object getReferenceValue();
    }

    static class ExposedField
    implements Field {
        private final boolean synthetic;
        private final Field field;

        public ExposedField(String key, boolean synthetic) {
            this(Fields.field(key), synthetic);
        }

        public ExposedField(Field delegate, boolean synthetic) {
            this.field = delegate;
            this.synthetic = synthetic;
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public String getTarget() {
            return this.field.getTarget();
        }

        @Override
        public boolean isAliased() {
            return this.field.isAliased();
        }

        public boolean isSynthetic() {
            return this.synthetic;
        }

        public boolean canBeReferredToBy(String name) {
            return this.getName().equals(name) || this.getTarget().equals(name);
        }

        public String toString() {
            return String.format("AggregationField: %s, synthetic: %s", this.field, this.synthetic);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExposedField)) {
                return false;
            }
            ExposedField that = (ExposedField)obj;
            return this.field.equals(that.field) && this.synthetic == that.synthetic;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.field.hashCode();
            return result += 31 * (this.synthetic ? 0 : 1);
        }
    }
}

