/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoJsonSchemaCreator;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.schema.IdentifiableJsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class MappingMongoJsonSchemaCreator
implements MongoJsonSchemaCreator {
    private final MongoConverter converter;
    private final MappingContext<MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    MappingMongoJsonSchemaCreator(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null!");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    @Override
    public MongoJsonSchema createSchemaFor(Class<?> type) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        MongoJsonSchema.MongoJsonSchemaBuilder schemaBuilder = MongoJsonSchema.builder();
        List<JsonSchemaProperty> schemaProperties = this.computePropertiesForEntity(Collections.emptyList(), entity);
        schemaBuilder.properties(schemaProperties.toArray(new JsonSchemaProperty[0]));
        return schemaBuilder.build();
    }

    private List<JsonSchemaProperty> computePropertiesForEntity(List<MongoPersistentProperty> path, MongoPersistentEntity<?> entity) {
        ArrayList<JsonSchemaProperty> schemaProperties = new ArrayList<JsonSchemaProperty>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty nested = (MongoPersistentProperty)iterator.next();
            ArrayList<MongoPersistentProperty> currentPath = new ArrayList<MongoPersistentProperty>(path);
            if (path.contains(nested)) {
                schemaProperties.add(this.createSchemaProperty(this.computePropertyFieldName((PersistentProperty)CollectionUtils.lastElement(currentPath)), Object.class, false));
                break;
            }
            currentPath.add(nested);
            schemaProperties.add(this.computeSchemaForProperty(currentPath));
        }
        return schemaProperties;
    }

    private JsonSchemaProperty computeSchemaForProperty(List<MongoPersistentProperty> path) {
        MongoPersistentProperty property = (MongoPersistentProperty)CollectionUtils.lastElement(path);
        boolean required = this.isRequiredProperty(property);
        Class<?> rawTargetType = this.computeTargetType(property);
        Class<?> targetType = this.converter.getTypeMapper().getWriteTargetTypeFor(rawTargetType);
        if (property.isEntity() && ObjectUtils.nullSafeEquals(rawTargetType, targetType)) {
            return this.createObjectSchemaPropertyForEntity(path, property, required);
        }
        String fieldName = this.computePropertyFieldName(property);
        if (property.isCollectionLike()) {
            return this.createSchemaProperty(fieldName, targetType, required);
        }
        if (property.isMap()) {
            return this.createSchemaProperty(fieldName, JsonSchemaObject.Type.objectType(), required);
        }
        if (ClassUtils.isAssignable(Enum.class, targetType)) {
            return this.createEnumSchemaProperty(fieldName, targetType, required);
        }
        return this.createSchemaProperty(fieldName, targetType, required);
    }

    private JsonSchemaProperty createObjectSchemaPropertyForEntity(List<MongoPersistentProperty> path, MongoPersistentProperty property, boolean required) {
        IdentifiableJsonSchemaProperty.ObjectJsonSchemaProperty target = JsonSchemaProperty.object(property.getName());
        List<JsonSchemaProperty> nestedProperties = this.computePropertiesForEntity(path, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property));
        return MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(target.properties(nestedProperties.toArray(new JsonSchemaProperty[0])), required);
    }

    private JsonSchemaProperty createEnumSchemaProperty(String fieldName, Class<?> targetType, boolean required) {
        ArrayList<Object> possibleValues = new ArrayList<Object>();
        for (Object enumValue : EnumSet.allOf(targetType)) {
            possibleValues.add(this.converter.convertToMongoType(enumValue));
        }
        targetType = possibleValues.isEmpty() ? targetType : possibleValues.iterator().next().getClass();
        return this.createSchemaProperty(fieldName, targetType, required, possibleValues);
    }

    JsonSchemaProperty createSchemaProperty(String fieldName, Object type, boolean required) {
        return this.createSchemaProperty(fieldName, type, required, Collections.emptyList());
    }

    JsonSchemaProperty createSchemaProperty(String fieldName, Object type, boolean required, Collection<?> possibleValues) {
        UntypedJsonSchemaObject schemaObject;
        TypedJsonSchemaObject typedJsonSchemaObject = schemaObject = type instanceof JsonSchemaObject.Type ? JsonSchemaObject.of((JsonSchemaObject.Type)JsonSchemaObject.Type.class.cast(type)) : JsonSchemaObject.of((Class)Class.class.cast(type));
        if (!CollectionUtils.isEmpty(possibleValues)) {
            schemaObject = schemaObject.possibleValues(possibleValues);
        }
        return MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(JsonSchemaProperty.named(fieldName).with((TypedJsonSchemaObject)schemaObject), required);
    }

    private String computePropertyFieldName(PersistentProperty property) {
        return property instanceof MongoPersistentProperty ? ((MongoPersistentProperty)property).getFieldName() : property.getName();
    }

    private boolean isRequiredProperty(PersistentProperty property) {
        return property.getType().isPrimitive();
    }

    private Class<?> computeTargetType(PersistentProperty<?> property) {
        if (!(property instanceof MongoPersistentProperty)) {
            return property.getType();
        }
        MongoPersistentProperty mongoProperty = (MongoPersistentProperty)property;
        if (!mongoProperty.isIdProperty()) {
            return mongoProperty.getFieldType();
        }
        if (mongoProperty.hasExplicitWriteTarget()) {
            return ((Field)mongoProperty.getRequiredAnnotation(Field.class)).targetType().getJavaClass();
        }
        return mongoProperty.getFieldType() != mongoProperty.getActualType() ? Object.class : mongoProperty.getFieldType();
    }

    static JsonSchemaProperty createPotentiallyRequiredSchemaProperty(JsonSchemaProperty property, boolean required) {
        if (!required) {
            return property;
        }
        return JsonSchemaProperty.required(property);
    }
}

