/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.math.BigInteger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverters;

public abstract class AbstractMongoConverter
implements MongoConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected CustomConversions conversions = new CustomConversions();

    public AbstractMongoConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService == null ? ConversionServiceFactory.createDefaultConversionService() : conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    private void initializeConverters() {
        if (!this.conversionService.canConvert(ObjectId.class, String.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(String.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.StringToObjectIdConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(ObjectId.class, BigInteger.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToBigIntegerConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(BigInteger.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.BigIntegerToObjectIdConverter.INSTANCE);
        }
        this.conversions.registerConvertersIn(this.conversionService);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }
}

