/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.mongodb.config.ParsingUtils;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return MongoFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "port", "port");
        ParsingUtils.setPropertyValue(element, builder, "host", "host");
        ParsingUtils.setPropertyValue(element, builder, "write-concern", "writeConcern");
        ParsingUtils.parseMongoOptions(element, builder);
        ParsingUtils.parseReplicaSet(element, builder);
        this.registerServerAddressPropertyEditor(parserContext.getRegistry());
        ParsingUtils.registerWriteConcernPropertyEditor(parserContext.getRegistry());
    }

    private void registerServerAddressPropertyEditor(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder customEditorConfigurer = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        customEditorConfigurer.addPropertyValue("customEditors", (Object)customEditors);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)customEditorConfigurer.getBeanDefinition(), (BeanDefinitionRegistry)registry);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "mongo";
        }
        return name;
    }
}

