/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarException;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaKeysetScrollQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpqlQueryCreator;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.PartTreeQueryCache;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private static final Logger log = LoggerFactory.getLogger(PartTreeJpaQuery.class);
    private final JpqlQueryTemplates templates = JpqlQueryTemplates.UPPER;
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer queryPreparer;
    private final QueryPreparer countQuery;
    private final EntityManager em;
    private final EscapeCharacter escape;
    private final JpaMetamodelEntityInformation<?, Object> entityInformation;

    PartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, EscapeCharacter.DEFAULT);
    }

    PartTreeJpaQuery(JpaQueryMethod method, EntityManager em, EscapeCharacter escape) {
        super(method, em);
        this.em = em;
        this.escape = escape;
        this.parameters = method.getParameters();
        Class domainClass = method.getEntityInformation().getJavaType();
        PersistenceUnitUtil persistenceUnitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
        this.entityInformation = new JpaMetamodelEntityInformation(domainClass, em.getMetamodel(), persistenceUnitUtil);
        try {
            this.tree = new PartTree(method.getName(), domainClass);
            PartTreeJpaQuery.validate(this.tree, this.parameters, method.toString());
            this.countQuery = new CountQueryPreparer();
            this.queryPreparer = this.tree.isCountProjection() ? this.countQuery : new QueryPreparer();
        }
        catch (Exception o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s; %s", new Object[]{method, o_O.getMessage()}), o_O);
        }
    }

    @Override
    public boolean hasDeclaredCountQuery() {
        return false;
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        return this.queryPreparer.createQuery(accessor);
    }

    public TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        return (TypedQuery)this.countQuery.createQuery(accessor);
    }

    @Override
    protected JpaQueryExecution getExecution(JpaParametersParameterAccessor accessor) {
        if (this.getQueryMethod().isScrollQuery()) {
            return new JpaQueryExecution.ScrollExecution(this.tree.getSort(), new ScrollDelegate(this.entityInformation));
        }
        if (this.tree.isDelete()) {
            return new JpaQueryExecution.DeleteExecution(this.em);
        }
        if (this.tree.isExistsProjection()) {
            return new JpaQueryExecution.ExistsExecution();
        }
        return super.getExecution(accessor);
    }

    private static void validate(PartTree tree, JpaParameters parameters, String methodName) {
        int argCount = 0;
        Iterable parts = () -> tree.stream().flatMap(Streamable::stream).iterator();
        for (Part part : parts) {
            int numberOfArguments = part.getNumberOfArguments();
            int i = 0;
            while (i < numberOfArguments) {
                PartTreeJpaQuery.throwExceptionOnArgumentMismatch(methodName, part, parameters, argCount);
                ++argCount;
                ++i;
            }
        }
    }

    private static void throwExceptionOnArgumentMismatch(String methodName, Part part, JpaParameters parameters, int index) {
        Part.Type type = part.getType();
        String property = part.getProperty().toDotPath();
        if (!((JpaParameters)parameters.getBindableParameters()).hasParameterAt(index)) {
            throw new IllegalStateException(String.format("Method %s expects at least %d arguments but only found %d; This leaves an operator of type %s for property %s unbound", methodName, index + 1, index, type.name(), property));
        }
        JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)parameters.getBindableParameter(index);
        if (PartTreeJpaQuery.expectsCollection(type)) {
            if (!PartTreeJpaQuery.parameterIsCollectionLike(parameter)) {
                throw new IllegalStateException(PartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "Collection", parameter));
            }
        } else if (!part.getProperty().isCollection() && !PartTreeJpaQuery.parameterIsScalarLike(parameter)) {
            throw new IllegalStateException(PartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "scalar", parameter));
        }
    }

    private static String wrongParameterTypeMessage(String methodName, String property, Part.Type operatorType, String expectedArgumentType, JpaParameters.JpaParameter parameter) {
        return String.format("Operator %s on %s requires a %s argument, found %s in method %s", operatorType.name(), property, expectedArgumentType, parameter.getType(), methodName);
    }

    private static boolean parameterIsCollectionLike(JpaParameters.JpaParameter parameter) {
        return Iterable.class.isAssignableFrom(parameter.getType()) || parameter.getType().isArray();
    }

    private static boolean parameterIsScalarLike(JpaParameters.JpaParameter parameter) {
        return !Iterable.class.isAssignableFrom(parameter.getType());
    }

    private static boolean expectsCollection(Part.Type type) {
        return type == Part.Type.IN || type == Part.Type.NOT_IN;
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        private final PartTreeQueryCache cache;

        private CountQueryPreparer() {
            this.cache = new PartTreeQueryCache();
        }

        @Override
        protected JpqlQueryCreator createCreator(Sort sort, JpaParametersParameterAccessor accessor) {
            JpqlQueryCreator cached = this.cache.get(Sort.unsorted(), accessor);
            if (cached != null) {
                return cached;
            }
            ParameterMetadataProvider provider = new ParameterMetadataProvider(accessor, PartTreeJpaQuery.this.escape, PartTreeJpaQuery.this.templates);
            JpaCountQueryCreator creator = new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().getResultProcessor().getReturnedType(), provider, PartTreeJpaQuery.this.templates, PartTreeJpaQuery.this.em);
            if (!accessor.getParameters().hasDynamicProjection()) {
                cached = new CacheableJpqlCountQueryCreator(creator);
                this.cache.put(Sort.unsorted(), accessor, cached);
                return cached;
            }
            return creator;
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, Query query, JpaParametersParameterAccessor accessor) {
            return binder.bind(query, accessor);
        }

        static class CacheableJpqlCountQueryCreator
        implements JpqlQueryCreator {
            private final String query;
            private final boolean useTupleQuery;
            private final List<ParameterBinding> parameterBindings;
            private final ParameterBinder binder;

            public CacheableJpqlCountQueryCreator(JpqlQueryCreator delegate) {
                this.query = delegate.createQuery(Sort.unsorted());
                this.useTupleQuery = delegate.useTupleQuery();
                this.parameterBindings = delegate.getBindings();
                this.binder = delegate.getBinder();
            }

            @Override
            public boolean useTupleQuery() {
                return this.useTupleQuery;
            }

            @Override
            public String createQuery(Sort sort) {
                return this.query;
            }

            @Override
            public List<ParameterBinding> getBindings() {
                return this.parameterBindings;
            }

            @Override
            public ParameterBinder getBinder() {
                return this.binder;
            }
        }
    }

    private class QueryPreparer {
        private final PartTreeQueryCache cache = new PartTreeQueryCache();

        private QueryPreparer() {
        }

        public Query createQuery(JpaParametersParameterAccessor accessor) {
            Query query;
            Sort sort = this.getDynamicSort(accessor);
            JpqlQueryCreator creator = this.createCreator(sort, accessor);
            String jpql = creator.createQuery(sort);
            if (log.isDebugEnabled()) {
                log.debug(String.format("%s: Derived query for query method [%s]: '%s'", new Object[]{this.getClass().getSimpleName(), PartTreeJpaQuery.this.getQueryMethod(), jpql}));
            }
            try {
                query = creator.useTupleQuery() ? PartTreeJpaQuery.this.em.createQuery(jpql, Tuple.class) : PartTreeJpaQuery.this.em.createQuery(jpql);
            }
            catch (Exception e) {
                throw new BadJpqlGrammarException(e.getMessage(), jpql, e);
            }
            ParameterBinder binder = creator.getBinder();
            ScrollPosition scrollPosition = accessor.getParameters().hasScrollPositionParameter() ? accessor.getScrollPosition() : null;
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(binder, query, accessor), scrollPosition);
        }

        private Query restrictMaxResultsIfNecessary(Query query, @Nullable ScrollPosition scrollPosition) {
            OffsetScrollPosition offset;
            if (scrollPosition instanceof OffsetScrollPosition && !(offset = (OffsetScrollPosition)scrollPosition).isInitial()) {
                query.setFirstResult(Math.toIntExact(offset.getOffset()) + 1);
            }
            if (PartTreeJpaQuery.this.tree.isLimiting()) {
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > PartTreeJpaQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - PartTreeJpaQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(PartTreeJpaQuery.this.tree.getMaxResults().intValue());
            }
            if (PartTreeJpaQuery.this.tree.isExistsProjection()) {
                query.setMaxResults(1);
            }
            return query;
        }

        protected JpqlQueryCreator createCreator(Sort sort, JpaParametersParameterAccessor accessor) {
            JpqlQueryCreator jpqlQueryCreator = this.cache.get(sort, accessor);
            if (jpqlQueryCreator != null) {
                return jpqlQueryCreator;
            }
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            ResultProcessor processor = PartTreeJpaQuery.this.getQueryMethod().getResultProcessor();
            ParameterMetadataProvider provider = new ParameterMetadataProvider(accessor, PartTreeJpaQuery.this.escape, PartTreeJpaQuery.this.templates);
            ReturnedType returnedType = processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            ScrollPosition scrollPosition = accessor.getScrollPosition();
            if (scrollPosition instanceof KeysetScrollPosition) {
                KeysetScrollPosition keyset = (KeysetScrollPosition)scrollPosition;
                return new JpaKeysetScrollQueryCreator(PartTreeJpaQuery.this.tree, returnedType, provider, PartTreeJpaQuery.this.templates, PartTreeJpaQuery.this.entityInformation, keyset, entityManager);
            }
            JpaParameters parameters = PartTreeJpaQuery.this.getQueryMethod().getParameters();
            if (accessor.getParameters().hasDynamicProjection() || PartTreeJpaQuery.this.getQueryMethod().isSearchQuery() || parameters.hasScoreRangeParameter() || parameters.hasScoreParameter()) {
                return new JpaQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().isSearchQuery(), returnedType, provider, PartTreeJpaQuery.this.templates, PartTreeJpaQuery.this.em.getMetamodel());
            }
            CacheableJpqlQueryCreator creator = new CacheableJpqlQueryCreator(sort, new JpaQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().isSearchQuery(), returnedType, provider, PartTreeJpaQuery.this.templates, PartTreeJpaQuery.this.em.getMetamodel()));
            this.cache.put(sort, accessor, creator);
            return creator;
        }

        protected Query invokeBinding(ParameterBinder binder, Query query, JpaParametersParameterAccessor accessor) {
            return binder.bindAndPrepare(query, accessor);
        }

        private Sort getDynamicSort(JpaParametersParameterAccessor accessor) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
        }

        static class CacheableJpqlQueryCreator
        implements JpqlQueryCreator {
            private final Sort expectedSort;
            private final String query;
            private final boolean useTupleQuery;
            private final List<ParameterBinding> parameterBindings;
            private final ParameterBinder binder;

            public CacheableJpqlQueryCreator(Sort expectedSort, JpqlQueryCreator delegate) {
                this.expectedSort = expectedSort;
                this.query = delegate.createQuery(expectedSort);
                this.useTupleQuery = delegate.useTupleQuery();
                this.parameterBindings = delegate.getBindings();
                this.binder = delegate.getBinder();
            }

            @Override
            public boolean useTupleQuery() {
                return this.useTupleQuery;
            }

            @Override
            public String createQuery(Sort sort) {
                Assert.isTrue((boolean)sort.equals((Object)this.expectedSort), (String)"Expected sort does not match");
                return this.query;
            }

            @Override
            public List<ParameterBinding> getBindings() {
                return this.parameterBindings;
            }

            @Override
            public ParameterBinder getBinder() {
                return this.binder;
            }
        }
    }
}

