/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;

public class DefaultQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;
    private final boolean hasConstructorExpression;
    private final String alias;
    private final String projection;
    private final Set<String> joinAliases;

    public DefaultQueryEnhancer(DeclaredQuery query) {
        this.query = query;
        this.hasConstructorExpression = QueryUtils.hasConstructorExpression(query.getQueryString());
        this.alias = QueryUtils.detectAlias(query.getQueryString());
        this.projection = QueryUtils.getProjection(this.query.getQueryString());
        this.joinAliases = QueryUtils.getOuterJoinAliases(this.query.getQueryString());
    }

    @Override
    public String applySorting(Sort sort) {
        return QueryUtils.applySorting(this.query.getQueryString(), sort, this.alias);
    }

    @Override
    public String applySorting(Sort sort, @Nullable String alias) {
        return QueryUtils.applySorting(this.query.getQueryString(), sort, alias);
    }

    @Override
    public String rewrite(QueryEnhancer.QueryRewriteInformation rewriteInformation) {
        return QueryUtils.applySorting(this.query.getQueryString(), rewriteInformation.getSort(), this.alias);
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        return QueryUtils.createCountQueryFor(this.query.getQueryString(), countProjection, this.query.isNativeQuery());
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    public String detectAlias() {
        return this.alias;
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public Set<String> getJoinAliases() {
        return this.joinAliases;
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }
}

