/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.RuntimeField;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface Query {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final Pageable DEFAULT_PAGE = PageRequest.of((int)0, (int)10);

    public static Query findAll() {
        return new StringQuery("{\"match_all\":{}}");
    }

    public <T extends Query> T setPageable(Pageable var1);

    public Pageable getPageable();

    public <T extends Query> T addSort(@Nullable Sort var1);

    @Nullable
    public Sort getSort();

    public void addFields(String ... var1);

    public List<String> getFields();

    public void setFields(List<String> var1);

    public void addStoredFields(String ... var1);

    @Nullable
    public List<String> getStoredFields();

    public void setStoredFields(@Nullable List<String> var1);

    public void addSourceFilter(SourceFilter var1);

    @Nullable
    public SourceFilter getSourceFilter();

    public float getMinScore();

    public boolean getTrackScores();

    @Nullable
    public Collection<String> getIds();

    public List<IdWithRouting> getIdsWithRouting();

    public static Query multiGetQueryWithRouting(List<IdWithRouting> idsWithRouting) {
        Assert.notNull(idsWithRouting, (String)"idsWithRouting must not be null");
        BaseQuery query = new BaseQuery();
        query.setIdsWithRouting(idsWithRouting);
        return query;
    }

    public static Query multiGetQuery(Collection<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        BaseQuery query = new BaseQuery();
        query.setIds(ids);
        return query;
    }

    @Nullable
    public String getRoute();

    public SearchType getSearchType();

    @Nullable
    public IndicesOptions getIndicesOptions();

    @Nullable
    public String getPreference();

    public void setPreference(String var1);

    default public boolean isLimiting() {
        return false;
    }

    @Nullable
    default public Integer getMaxResults() {
        return null;
    }

    public void setHighlightQuery(HighlightQuery var1);

    default public Optional<HighlightQuery> getHighlightQuery() {
        return Optional.empty();
    }

    public void setTrackTotalHits(@Nullable Boolean var1);

    @Nullable
    public Boolean getTrackTotalHits();

    public void setTrackTotalHitsUpTo(@Nullable Integer var1);

    @Nullable
    public Integer getTrackTotalHitsUpTo();

    @Nullable
    public Duration getScrollTime();

    public void setScrollTime(@Nullable Duration var1);

    default public boolean hasScrollTime() {
        return this.getScrollTime() != null;
    }

    @Nullable
    public Duration getTimeout();

    default public boolean getExplain() {
        return false;
    }

    public void setSearchAfter(@Nullable List<Object> var1);

    @Nullable
    public List<Object> getSearchAfter();

    public void addRescorerQuery(RescorerQuery var1);

    public void setRescorerQueries(List<RescorerQuery> var1);

    default public List<RescorerQuery> getRescorerQueries() {
        return Collections.emptyList();
    }

    public void setRequestCache(@Nullable Boolean var1);

    @Nullable
    public Boolean getRequestCache();

    public void addRuntimeField(RuntimeField var1);

    public List<RuntimeField> getRuntimeFields();

    @Nullable
    public List<IndexBoost> getIndicesBoost();

    public static final class IdWithRouting {
        private final String id;
        @Nullable
        private final String routing;

        public IdWithRouting(String id, @Nullable String routing) {
            Assert.notNull((Object)id, (String)"id must not be null");
            this.id = id;
            this.routing = routing;
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public String getRouting() {
            return this.routing;
        }
    }

    public static enum SearchType {
        QUERY_THEN_FETCH,
        DFS_QUERY_THEN_FETCH;

    }
}

