/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.util.Assert;

public class Settings
extends DefaultStringObjectMap<Settings> {
    public Settings() {
    }

    public Settings(Map<String, Object> map) {
        super(map);
    }

    public static Settings parse(String json) {
        return (Settings)new Settings().fromJson(json);
    }

    @Override
    public String toString() {
        return "Settings: " + this.toJson();
    }

    @Override
    public Object get(Object key) {
        return this.containsKey(key) ? super.get(key) : this.path(key.toString());
    }

    public void merge(Settings other) {
        Assert.notNull((Object)other, (String)"other must not be null");
        Settings.deepMerge(this, other);
    }

    private static Map<?, ?> deepMerge(Map<String, Object> original, Map<String, Object> newMap) {
        for (String key : newMap.keySet()) {
            Object newChild;
            Object originalChild;
            if (newMap.get(key) instanceof Map && original.get(key) instanceof Map) {
                originalChild = (Map)original.get(key);
                newChild = (Map)newMap.get(key);
                original.put(key.toString(), Settings.deepMerge((Map<String, Object>)originalChild, (Map<String, Object>)newChild));
                continue;
            }
            if (newMap.get(key) instanceof List && original.get(key) instanceof List) {
                originalChild = (List)original.get(key);
                newChild = (List)newMap.get(key);
                Iterator iterator = newChild.iterator();
                while (iterator.hasNext()) {
                    Object each = iterator.next();
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key.toString(), newMap.get(key));
        }
        return original;
    }

    public Settings flatten() {
        return new Settings(this.entrySet().stream().flatMap(Settings::doFlatten).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static Stream<Map.Entry<String, Object>> doFlatten(Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof Map) {
            Map nested = (Map)entry.getValue();
            return nested.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((String)entry.getKey() + "." + e.getKey(), e.getValue())).flatMap(e2 -> Settings.doFlatten(e2));
        }
        return Stream.of(entry);
    }
}

