/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.NullableWrapperConverters;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.SearchResults;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.DefaultParameters;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryMethod {
    private final RepositoryMetadata metadata;
    private final Method method;
    private final Class<?> unwrappedReturnType;
    private final Parameters<?, ?> parameters;
    private final ResultProcessor resultProcessor;
    private final Lazy<Class<?>> domainClass;
    private final Lazy<Boolean> isCollectionQuery;

    @Deprecated(since="3.5")
    public QueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        this(method, metadata, factory, null);
    }

    public QueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, @Nullable Function<ParametersSource, ? extends Parameters<?, ?>> parametersFunction) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)metadata, (String)"Repository metadata must not be null");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null");
        Parameters.TYPES.stream().filter(type -> ReflectionUtils.getParameterCount(method, type::equals) > 1).findFirst().ifPresent(type -> {
            throw new IllegalStateException(String.format("Method must have only one argument of type %s; Offending method: %s", type.getSimpleName(), method));
        });
        this.method = method;
        this.unwrappedReturnType = QueryMethod.potentiallyUnwrapReturnTypeFor(metadata, method);
        this.metadata = metadata;
        this.parameters = parametersFunction == null ? this.createParameters(ParametersSource.of(metadata, method)) : parametersFunction.apply(ParametersSource.of(metadata, method));
        this.domainClass = Lazy.of(() -> {
            Class<?> repositoryDomainClass = metadata.getDomainType();
            Class<?> methodDomainClass = metadata.getReturnedDomainClass(method);
            return repositoryDomainClass == null || repositoryDomainClass.isAssignableFrom(methodDomainClass) ? methodDomainClass : repositoryDomainClass;
        });
        this.resultProcessor = new ResultProcessor(this, factory);
        this.isCollectionQuery = Lazy.of(this::calculateIsCollectionQuery);
        this.validate();
    }

    private void validate() {
        QueryMethodValidator.validate(this.method);
        if (ReflectionUtils.hasParameterOfType(this.method, Pageable.class)) {
            if (!this.isStreamQuery()) {
                QueryMethod.assertReturnTypeAssignable(this.method, QueryExecutionConverters.getAllowedPageableTypes());
            }
            if (ReflectionUtils.hasParameterOfType(this.method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameters. Use sorting capabilities on Pageable instead; Offending method: %s", this.method));
            }
        }
        if (ReflectionUtils.hasParameterOfType(this.method, ScrollPosition.class)) {
            QueryMethod.assertReturnTypeAssignable(this.method, Collections.singleton(Window.class));
        }
        Assert.notNull(this.parameters, () -> String.format("Parameters extracted from method '%s' must not be null", ReflectionUtils.toString(this.method)));
        if (this.isPageQuery()) {
            Assert.isTrue((boolean)this.parameters.hasPageableParameter(), (String)String.format("Paging query needs to have a Pageable parameter; Offending method: %s", ReflectionUtils.toString(this.method)));
        }
        if (this.isScrollQuery()) {
            Assert.isTrue((this.parameters.hasScrollPositionParameter() || this.parameters.hasPageableParameter() ? 1 : 0) != 0, (String)String.format("Scroll query needs to have a ScrollPosition parameter; Offending method: %s", ReflectionUtils.toString(this.method)));
        }
    }

    private boolean calculateIsCollectionQuery() {
        if (this.isPageQuery() || this.isSliceQuery() || this.isScrollQuery()) {
            return false;
        }
        TypeInformation<?> returnTypeInformation = this.metadata.getReturnType(this.method);
        if (this.metadata.getDomainTypeInformation().isAssignableFrom(NullableWrapperConverters.unwrapActualType(returnTypeInformation))) {
            return false;
        }
        Class<?> returnType = returnTypeInformation.getType();
        if (QueryExecutionConverters.supports(returnType) && !QueryExecutionConverters.isSingleValue(returnType)) {
            return true;
        }
        if (QueryExecutionConverters.supports(this.unwrappedReturnType)) {
            return !QueryExecutionConverters.isSingleValue(this.unwrappedReturnType);
        }
        return TypeInformation.of(this.unwrappedReturnType).isCollectionLike();
    }

    @Deprecated(since="3.5")
    protected Parameters<?, ?> createParameters(ParametersSource parametersSource) {
        return new DefaultParameters(parametersSource);
    }

    public String getName() {
        return this.method.getName();
    }

    public EntityMetadata<?> getEntityInformation() {
        return () -> this.getDomainClass();
    }

    public String getNamedQueryName() {
        return String.format("%s.%s", this.getDomainClass().getSimpleName(), this.method.getName());
    }

    protected Class<?> getDomainClass() {
        return this.domainClass.get();
    }

    public Class<?> getReturnedObjectType() {
        return this.metadata.getReturnedDomainClass(this.method);
    }

    public boolean isCollectionQuery() {
        return this.isCollectionQuery.get();
    }

    public boolean isScrollQuery() {
        return ClassUtils.isAssignable(Window.class, this.unwrappedReturnType);
    }

    public boolean isSliceQuery() {
        return !this.isPageQuery() && ClassUtils.isAssignable(Slice.class, this.unwrappedReturnType);
    }

    public final boolean isPageQuery() {
        return ClassUtils.isAssignable(Page.class, this.unwrappedReturnType);
    }

    public boolean isSearchQuery() {
        if (ClassUtils.isAssignable(SearchResults.class, this.unwrappedReturnType)) {
            return true;
        }
        TypeInformation<?> returnType = this.metadata.getReturnType(this.method);
        TypeInformation<?> componentType = returnType.getComponentType();
        return componentType != null && SearchResult.class.isAssignableFrom(componentType.getType());
    }

    public boolean isModifyingQuery() {
        return false;
    }

    public boolean isQueryForEntity() {
        return this.getDomainClass().isAssignableFrom(this.getReturnedObjectType());
    }

    public boolean isStreamQuery() {
        return Stream.class.isAssignableFrom(this.unwrappedReturnType);
    }

    public Parameters<?, ?> getParameters() {
        return this.parameters;
    }

    public ResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }

    private static Class<? extends Object> potentiallyUnwrapReturnTypeFor(RepositoryMetadata metadata, Method method) {
        TypeInformation<?> returnType = metadata.getReturnType(method);
        if (QueryExecutionConverters.supports(returnType.getType()) || ReactiveWrapperConverters.supports(returnType.getType())) {
            TypeInformation<?> componentType = returnType.getComponentType();
            if (componentType == null) {
                throw new IllegalStateException(String.format("Couldn't find component type for return value of method %s", method));
            }
            return componentType.getType();
        }
        return returnType.getType();
    }

    private static void assertReturnTypeAssignable(Method method, Set<Class<?>> types) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notEmpty(types, (String)"Types must not be null or empty");
        TypeInformation<?> returnType = TypeInformation.fromReturnTypeOf(method);
        returnType = ReactiveWrappers.isSingleValueType(returnType.getType()) ? returnType.getRequiredComponentType() : returnType;
        returnType = QueryExecutionConverters.isSingleValue(returnType.getType()) ? returnType.getRequiredComponentType() : returnType;
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(returnType.getType())) continue;
            return;
        }
        throw new IllegalStateException("Method '%s' has to have one of the following return types: %s".formatted(method, types));
    }

    static class QueryMethodValidator {
        static Predicate<Method> pageableCannotHaveSortOrLimit = method -> {
            if (!ReflectionUtils.hasParameterAssignableToType(method, Pageable.class)) {
                return true;
            }
            return !ReflectionUtils.hasParameterAssignableToType(method, Sort.class) && !ReflectionUtils.hasParameterAssignableToType(method, Limit.class);
        };

        QueryMethodValidator() {
        }

        static void validate(Method method) {
            if (!pageableCannotHaveSortOrLimit.test(method)) {
                throw new IllegalStateException("Method method using Pageable parameter must not define Limit nor Sort. Offending method: %s".formatted(method));
            }
        }
    }
}

