/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.repository.query.EvaluationContextExtensionInformation;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Functions;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.spi.EvaluationContextExtension;
import org.springframework.data.repository.query.spi.Function;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExtensionAwareEvaluationContextProvider
implements EvaluationContextProvider,
ApplicationContextAware {
    private final Map<Class<?>, EvaluationContextExtensionInformation> extensionInformationCache = new HashMap();
    private final Lazy<List<? extends EvaluationContextExtension>> extensions;
    private Optional<ListableBeanFactory> beanFactory = Optional.empty();

    public ExtensionAwareEvaluationContextProvider() {
        this.extensions = Lazy.of(() -> ExtensionAwareEvaluationContextProvider.getExtensionsFrom(this.beanFactory));
    }

    public ExtensionAwareEvaluationContextProvider(List<? extends EvaluationContextExtension> extensions) {
        Assert.notNull(extensions, (String)"List of EvaluationContextExtensions must not be null!");
        this.extensions = Lazy.of(() -> extensions);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = Optional.of(applicationContext);
    }

    public <T extends Parameters<?, ?>> StandardEvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
        StandardEvaluationContext ec = new StandardEvaluationContext();
        this.beanFactory.ifPresent(it -> ec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)it)));
        ExtensionAwarePropertyAccessor accessor = new ExtensionAwarePropertyAccessor(this.extensions.get());
        ec.addPropertyAccessor((PropertyAccessor)accessor);
        ec.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        ec.addMethodResolver((MethodResolver)accessor);
        ec.setRootObject((Object)parameterValues);
        ec.setVariables(this.collectVariables(parameters, parameterValues));
        return ec;
    }

    private <T extends Parameters<?, ?>> Map<String, Object> collectVariables(T parameters, Object[] arguments) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        parameters.stream().filter(Parameter::isSpecialParameter).forEach(it -> variables.put(StringUtils.uncapitalize((String)it.getType().getSimpleName()), arguments[it.getIndex()]));
        parameters.stream().filter(Parameter::isNamedParameter).forEach(it -> variables.put(it.getName().orElseThrow(() -> new IllegalStateException("Should never occur!")), arguments[it.getIndex()]));
        return variables;
    }

    private static List<? extends EvaluationContextExtension> getExtensionsFrom(Optional<ListableBeanFactory> beanFactory) {
        Collection extensions = beanFactory.map(it -> it.getBeansOfType(EvaluationContextExtension.class, true, false).values()).orElseGet(() -> Collections.emptyList());
        return new ArrayList(extensions);
    }

    private EvaluationContextExtensionInformation getOrCreateInformation(EvaluationContextExtension extension) {
        Class<?> extensionType = extension.getClass();
        return this.extensionInformationCache.computeIfAbsent(extensionType, type -> new EvaluationContextExtensionInformation(extensionType));
    }

    private List<EvaluationContextExtensionAdapter> toAdapters(List<? extends EvaluationContextExtension> extensions) {
        return extensions.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).map(it -> new EvaluationContextExtensionAdapter((EvaluationContextExtension)it, this.getOrCreateInformation((EvaluationContextExtension)it))).collect(Collectors.toList());
    }

    private static class EvaluationContextExtensionAdapter {
        private final EvaluationContextExtension extension;
        private final Functions functions = new Functions();
        private final Map<String, Object> properties;

        public EvaluationContextExtensionAdapter(EvaluationContextExtension extension, EvaluationContextExtensionInformation information) {
            Assert.notNull((Object)extension, (String)"Extension must not be null!");
            Assert.notNull((Object)information, (String)"Extension information must not be null!");
            Optional<Object> target = Optional.ofNullable(extension.getRootObject());
            EvaluationContextExtensionInformation.ExtensionTypeInformation extensionTypeInformation = information.getExtensionTypeInformation();
            EvaluationContextExtensionInformation.RootObjectInformation rootObjectInformation = information.getRootObjectInformation(target);
            this.functions.addAll(extension.getFunctions());
            this.functions.addAll(rootObjectInformation.getFunctions(target));
            this.functions.addAll(extensionTypeInformation.getFunctions());
            this.properties = new HashMap<String, Object>();
            this.properties.putAll(extensionTypeInformation.getProperties());
            this.properties.putAll(rootObjectInformation.getProperties(target));
            this.properties.putAll(extension.getProperties());
            this.extension = extension;
        }

        String getExtensionId() {
            return this.extension.getExtensionId();
        }

        Functions getFunctions() {
            return this.functions;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    private static class FunctionMethodExecutor
    implements MethodExecutor {
        @NonNull
        private final Function function;

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            try {
                return new TypedValue(this.function.invoke(arguments));
            }
            catch (Exception e) {
                throw new SpelEvaluationException((Throwable)e, SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, new Object[]{this.function.getName(), this.function.getDeclaringClass()});
            }
        }

        public FunctionMethodExecutor(@NonNull Function function) {
            if (function == null) {
                throw new IllegalArgumentException("function is null");
            }
            this.function = function;
        }
    }

    private class ExtensionAwarePropertyAccessor
    implements PropertyAccessor,
    MethodResolver {
        private final List<EvaluationContextExtensionAdapter> adapters;
        private final Map<String, EvaluationContextExtensionAdapter> adapterMap;

        public ExtensionAwarePropertyAccessor(List<? extends EvaluationContextExtension> extensions) {
            Assert.notNull(extensions, (String)"Extensions must not be null!");
            this.adapters = ExtensionAwareEvaluationContextProvider.this.toAdapters(extensions);
            this.adapterMap = this.adapters.stream().collect(Collectors.toMap(EvaluationContextExtensionAdapter::getExtensionId, it -> it));
            Collections.reverse(this.adapters);
        }

        public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
            if (target instanceof EvaluationContextExtension) {
                return true;
            }
            if (this.adapterMap.containsKey(name)) {
                return true;
            }
            return this.adapters.stream().anyMatch(it -> it.getProperties().containsKey(name));
        }

        public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
            if (target instanceof EvaluationContextExtensionAdapter) {
                return this.lookupPropertyFrom((EvaluationContextExtensionAdapter)target, name);
            }
            if (this.adapterMap.containsKey(name)) {
                return new TypedValue((Object)this.adapterMap.get(name));
            }
            return this.adapters.stream().filter(it -> it.getProperties().containsKey(name)).map(it -> this.lookupPropertyFrom((EvaluationContextExtensionAdapter)it, name)).findFirst().orElse(TypedValue.NULL);
        }

        @Nullable
        public MethodExecutor resolve(EvaluationContext context, @Nullable Object target, String name, List<TypeDescriptor> argumentTypes) {
            if (target instanceof EvaluationContextExtensionAdapter) {
                return this.getMethodExecutor((EvaluationContextExtensionAdapter)target, name, argumentTypes).orElse(null);
            }
            return this.adapters.stream().flatMap(it -> Optionals.toStream(this.getMethodExecutor((EvaluationContextExtensionAdapter)it, name, argumentTypes))).findFirst().orElse(null);
        }

        public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
            return false;
        }

        public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) {
        }

        @Nullable
        public Class<?>[] getSpecificTargetClasses() {
            return null;
        }

        private Optional<MethodExecutor> getMethodExecutor(EvaluationContextExtensionAdapter adapter, String name, List<TypeDescriptor> argumentTypes) {
            return adapter.getFunctions().get(name, argumentTypes).map(FunctionMethodExecutor::new);
        }

        private TypedValue lookupPropertyFrom(EvaluationContextExtensionAdapter extension, String name) {
            Object value = extension.getProperties().get(name);
            if (!(value instanceof Function)) {
                return new TypedValue(value);
            }
            Function function = (Function)value;
            try {
                return new TypedValue(function.invoke(new Object[0]));
            }
            catch (Exception e) {
                throw new SpelEvaluationException((Throwable)e, SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, new Object[]{name, function.getDeclaringClass()});
            }
        }
    }
}

