/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationResourceLoader
extends DefaultResourceLoader {
    @Deprecated(since="3.4.0", forRemoval=true)
    public ApplicationResourceLoader() {
        this(null);
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    public ApplicationResourceLoader(ClassLoader classLoader) {
        super(classLoader);
        SpringFactoriesLoader loader = SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader);
        this.getProtocolResolvers().addAll(loader.load(ProtocolResolver.class));
    }

    protected Resource getResourceByPath(String path) {
        return new ApplicationResource(path);
    }

    public static ResourceLoader get() {
        return ApplicationResourceLoader.get((ClassLoader)null);
    }

    public static ResourceLoader get(ClassLoader classLoader) {
        return ApplicationResourceLoader.get(classLoader, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader));
    }

    public static ResourceLoader get(ClassLoader classLoader, SpringFactoriesLoader springFactoriesLoader) {
        return ApplicationResourceLoader.get(classLoader, springFactoriesLoader, null);
    }

    public static ResourceLoader get(ClassLoader classLoader, SpringFactoriesLoader springFactoriesLoader, Path workingDirectory) {
        return ApplicationResourceLoader.get(ApplicationFileSystemResourceLoader.get(classLoader, workingDirectory), springFactoriesLoader);
    }

    public static ResourceLoader get(ResourceLoader resourceLoader) {
        return ApplicationResourceLoader.get(resourceLoader, false);
    }

    public static ResourceLoader get(ResourceLoader resourceLoader, boolean preferFileResolution) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        return ApplicationResourceLoader.get(resourceLoader, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)resourceLoader.getClassLoader()), preferFileResolution);
    }

    public static ResourceLoader get(ResourceLoader resourceLoader, SpringFactoriesLoader springFactoriesLoader) {
        return ApplicationResourceLoader.get(resourceLoader, springFactoriesLoader, false);
    }

    private static ResourceLoader get(ResourceLoader resourceLoader, SpringFactoriesLoader springFactoriesLoader, boolean preferFileResolution) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        Assert.notNull((Object)springFactoriesLoader, (String)"'springFactoriesLoader' must not be null");
        List protocolResolvers = springFactoriesLoader.load(ProtocolResolver.class);
        List filePathResolvers = preferFileResolution ? springFactoriesLoader.load(FilePathResolver.class) : Collections.emptyList();
        return new ProtocolResolvingResourceLoader(resourceLoader, protocolResolvers, filePathResolvers);
    }

    private static final class ApplicationResource
    extends FileSystemResource
    implements ContextResource {
        ApplicationResource(String path) {
            super(path);
        }

        ApplicationResource(Path path) {
            super(path);
        }

        public String getPathWithinContext() {
            return this.getPath();
        }
    }

    private static final class ApplicationFileSystemResourceLoader
    extends DefaultResourceLoader {
        private static final ResourceLoader shared = new ApplicationFileSystemResourceLoader(null, null);
        private final Path workingDirectory;

        private ApplicationFileSystemResourceLoader(ClassLoader classLoader, Path workingDirectory) {
            super(classLoader);
            this.workingDirectory = workingDirectory;
        }

        public Resource getResource(String location) {
            Resource resource = super.getResource(location);
            if (this.workingDirectory == null) {
                return resource;
            }
            if (!resource.isFile()) {
                return resource;
            }
            return this.resolveFile(resource);
        }

        private Resource resolveFile(Resource resource) {
            try {
                File file = resource.getFile();
                return new ApplicationResource(this.workingDirectory.resolve(file.toPath()));
            }
            catch (FileNotFoundException ex) {
                return resource;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        protected Resource getResourceByPath(String path) {
            return new ApplicationResource(path);
        }

        static ResourceLoader get(ClassLoader classLoader, Path workingDirectory) {
            if (classLoader == null && workingDirectory != null) {
                throw new IllegalArgumentException("It's not possible to use null as 'classLoader' but specify a 'workingDirectory'");
            }
            return classLoader != null ? new ApplicationFileSystemResourceLoader(classLoader, workingDirectory) : shared;
        }
    }

    public static interface FilePathResolver {
        public String resolveFilePath(String var1, Resource var2);
    }

    private static class ProtocolResolvingResourceLoader
    implements ResourceLoader {
        private final ResourceLoader resourceLoader;
        private final List<ProtocolResolver> protocolResolvers;
        private final List<FilePathResolver> filePathResolvers;

        ProtocolResolvingResourceLoader(ResourceLoader resourceLoader, List<ProtocolResolver> protocolResolvers, List<FilePathResolver> filePathResolvers) {
            this.resourceLoader = resourceLoader;
            this.protocolResolvers = protocolResolvers;
            this.filePathResolvers = filePathResolvers;
        }

        public ClassLoader getClassLoader() {
            return this.resourceLoader.getClassLoader();
        }

        public Resource getResource(String location) {
            Resource resource;
            String filePath;
            if (StringUtils.hasLength((String)location)) {
                for (ProtocolResolver protocolResolver : this.protocolResolvers) {
                    Resource resource2 = protocolResolver.resolve(location, (ResourceLoader)this);
                    if (resource2 == null) continue;
                    return resource2;
                }
            }
            return (filePath = this.getFilePath(location, resource = this.resourceLoader.getResource(location))) != null ? new ApplicationResource(filePath) : resource;
        }

        private String getFilePath(String location, Resource resource) {
            for (FilePathResolver filePathResolver : this.filePathResolvers) {
                String filePath = filePathResolver.resolveFilePath(location, resource);
                if (filePath == null) continue;
                return filePath;
            }
            return null;
        }
    }
}

