/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.context;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;

public interface WebServerApplicationContext
extends ApplicationContext {
    public static final int GRACEFUL_SHUTDOWN_PHASE = 0x7FFFFBFF;
    public static final int START_STOP_LIFECYCLE_PHASE = 0x7FFFF7FF;

    public @Nullable WebServer getWebServer();

    public @Nullable String getServerNamespace();

    public static boolean hasServerNamespace(@Nullable ApplicationContext context, String serverNamespace) {
        WebServerApplicationContext webServerApplicationContext;
        return context instanceof WebServerApplicationContext && ObjectUtils.nullSafeEquals((Object)(webServerApplicationContext = (WebServerApplicationContext)context).getServerNamespace(), (Object)serverNamespace);
    }

    public static @Nullable String getServerNamespace(@Nullable ApplicationContext context) {
        String string;
        if (context instanceof WebServerApplicationContext) {
            WebServerApplicationContext configurableContext = (WebServerApplicationContext)context;
            string = configurableContext.getServerNamespace();
        } else {
            string = null;
        }
        return string;
    }
}

