/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.web;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;

public class SpringBootMockServletContext
extends MockServletContext {
    private static final String[] SPRING_BOOT_RESOURCE_LOCATIONS = new String[]{"classpath:META-INF/resources", "classpath:resources", "classpath:static", "classpath:public"};
    private final ResourceLoader resourceLoader;
    private File emptyRootDirectory;

    public SpringBootMockServletContext(String resourceBasePath) {
        this(resourceBasePath, (ResourceLoader)new FileSystemResourceLoader());
    }

    public SpringBootMockServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        super(resourceBasePath, resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    protected String getResourceLocation(String path) {
        String resourceLocation;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (this.exists(resourceLocation = this.getResourceBasePathLocation(path))) {
            return resourceLocation;
        }
        for (String prefix : SPRING_BOOT_RESOURCE_LOCATIONS) {
            resourceLocation = prefix + path;
            if (!this.exists(resourceLocation)) continue;
            return resourceLocation;
        }
        return super.getResourceLocation(path);
    }

    protected final String getResourceBasePathLocation(String path) {
        return super.getResourceLocation(path);
    }

    private boolean exists(String resourceLocation) {
        try {
            Resource resource = this.resourceLoader.getResource(resourceLocation);
            return resource.exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        URL resource = super.getResource(path);
        if (resource == null && "/".equals(path)) {
            try {
                if (this.emptyRootDirectory == null) {
                    SpringBootMockServletContext springBootMockServletContext = this;
                    synchronized (springBootMockServletContext) {
                        File tempDirectory = File.createTempFile("spr", "servlet");
                        tempDirectory.delete();
                        tempDirectory.mkdirs();
                        tempDirectory.deleteOnExit();
                        this.emptyRootDirectory = tempDirectory;
                    }
                }
                return this.emptyRootDirectory.toURI().toURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resource;
    }
}

