/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.boot.devtools.restart.server.RestartServer;
import org.springframework.boot.devtools.restart.server.SourceFolderUrlFilter;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;

public class HttpRestartServer {
    private static final Log logger = LogFactory.getLog(HttpRestartServer.class);
    private final RestartServer server;

    public HttpRestartServer(SourceFolderUrlFilter sourceFolderUrlFilter) {
        Assert.notNull((Object)sourceFolderUrlFilter, (String)"SourceFolderUrlFilter must not be null");
        this.server = new RestartServer(sourceFolderUrlFilter);
    }

    public HttpRestartServer(RestartServer restartServer) {
        Assert.notNull((Object)restartServer, (String)"RestartServer must not be null");
        this.server = restartServer;
    }

    public void handle(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        try {
            Assert.state((request.getHeaders().getContentLength() > 0L ? 1 : 0) != 0, (String)"No content");
            ObjectInputStream objectInputStream = new ObjectInputStream(request.getBody());
            ClassLoaderFiles files = (ClassLoaderFiles)objectInputStream.readObject();
            objectInputStream.close();
            this.server.updateAndRestart(files);
            response.setStatusCode(HttpStatus.OK);
        }
        catch (Exception ex) {
            logger.warn((Object)"Unable to handler restart server HTTP request", (Throwable)ex);
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

