/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.logging;

import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportLogger;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class ConditionEvaluationReportLoggingListener
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final LogLevel logLevel;

    public ConditionEvaluationReportLoggingListener() {
        this(LogLevel.DEBUG);
    }

    private ConditionEvaluationReportLoggingListener(LogLevel logLevel) {
        Assert.isTrue((boolean)this.isInfoOrDebug(logLevel), (String)"'logLevel' must be INFO or DEBUG");
        this.logLevel = logLevel;
    }

    private boolean isInfoOrDebug(LogLevel logLevelForReport) {
        return LogLevel.INFO.equals((Object)logLevelForReport) || LogLevel.DEBUG.equals((Object)logLevelForReport);
    }

    public static ConditionEvaluationReportLoggingListener forLogLevel(LogLevel logLevelForReport) {
        return new ConditionEvaluationReportLoggingListener(logLevelForReport);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener((ApplicationListener)new ConditionEvaluationReportListener(applicationContext));
    }

    private final class ConditionEvaluationReportListener
    implements GenericApplicationListener {
        private final ConfigurableApplicationContext context;
        private final ConditionEvaluationReportLogger logger;

        private ConditionEvaluationReportListener(ConfigurableApplicationContext context) {
            Supplier<ConditionEvaluationReport> reportSupplier;
            this.context = context;
            if (context instanceof GenericApplicationContext) {
                ConditionEvaluationReport report = this.getReport();
                reportSupplier = () -> report;
            } else {
                reportSupplier = this::getReport;
            }
            this.logger = new ConditionEvaluationReportLogger(ConditionEvaluationReportLoggingListener.this.logLevel, reportSupplier);
        }

        private ConditionEvaluationReport getReport() {
            return ConditionEvaluationReport.get(this.context.getBeanFactory());
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public boolean supportsEventType(ResolvableType resolvableType) {
            Class type = resolvableType.getRawClass();
            if (type == null) {
                return false;
            }
            return ContextRefreshedEvent.class.isAssignableFrom(type) || ApplicationFailedEvent.class.isAssignableFrom(type);
        }

        public boolean supportsSourceType(Class<?> sourceType) {
            return true;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            ApplicationFailedEvent applicationFailedEvent;
            if (event instanceof ContextRefreshedEvent) {
                ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
                if (contextRefreshedEvent.getApplicationContext() == this.context) {
                    this.logger.logReport(false);
                }
            } else if (event instanceof ApplicationFailedEvent && (applicationFailedEvent = (ApplicationFailedEvent)event).getApplicationContext() == this.context) {
                this.logger.logReport(true);
            }
        }
    }
}

