/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mustache.MustacheEnvironmentCollector;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.autoconfigure.mustache.MustacheReactiveWebConfiguration;
import org.springframework.boot.autoconfigure.mustache.MustacheResourceTemplateLoader;
import org.springframework.boot.autoconfigure.mustache.MustacheServletWebConfiguration;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Mustache.class})
@EnableConfigurationProperties(value={MustacheProperties.class})
@Import(value={MustacheServletWebConfiguration.class, MustacheReactiveWebConfiguration.class})
public class MustacheAutoConfiguration {
    private static final Log logger = LogFactory.getLog(MustacheAutoConfiguration.class);
    private final MustacheProperties mustache;
    private final ApplicationContext applicationContext;

    public MustacheAutoConfiguration(MustacheProperties mustache, ApplicationContext applicationContext) {
        this.mustache = mustache;
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void checkTemplateLocationExists() {
        TemplateLocation location;
        if (this.mustache.isCheckTemplateLocation() && !(location = new TemplateLocation(this.mustache.getPrefix())).exists((ResourcePatternResolver)this.applicationContext)) {
            logger.warn((Object)("Cannot find template location: " + location + " (please add some templates, check your Mustache configuration, or set spring.mustache.check-template-location=false)"));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public Mustache.Compiler mustacheCompiler(Mustache.TemplateLoader mustacheTemplateLoader, Environment environment) {
        return Mustache.compiler().withLoader(mustacheTemplateLoader).withCollector(this.collector(environment));
    }

    private Mustache.Collector collector(Environment environment) {
        MustacheEnvironmentCollector collector = new MustacheEnvironmentCollector();
        collector.setEnvironment(environment);
        return collector;
    }

    @Bean
    @ConditionalOnMissingBean(value={Mustache.TemplateLoader.class})
    public MustacheResourceTemplateLoader mustacheTemplateLoader() {
        MustacheResourceTemplateLoader loader = new MustacheResourceTemplateLoader(this.mustache.getPrefix(), this.mustache.getSuffix());
        loader.setCharset(this.mustache.getCharsetName());
        return loader;
    }
}

