/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mail;

import javax.mail.Session;
import javax.naming.NamingException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiLocatorDelegate;

@Configuration
@ConditionalOnClass(value={Session.class})
@ConditionalOnProperty(prefix="spring.mail", name={"jndi-name"})
@ConditionalOnJndi
class JndiSessionConfiguration {
    private final MailProperties properties;

    JndiSessionConfiguration(MailProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Session session() {
        String jndiName = this.properties.getJndiName();
        try {
            return (Session)new JndiLocatorDelegate().lookup(jndiName, Session.class);
        }
        catch (NamingException ex) {
            throw new IllegalStateException(String.format("Unable to find Session in JNDI location %s", jndiName), ex);
        }
    }
}

