/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.elasticsearch;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.NodeClientFactoryBean;
import org.springframework.data.elasticsearch.client.TransportClientFactoryBean;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Client.class, TransportClientFactoryBean.class, NodeClientFactoryBean.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
public class ElasticsearchAutoConfiguration
implements DisposableBean {
    private static final Map<String, String> DEFAULTS;
    private static Log logger;
    @Autowired
    private ElasticsearchProperties properties;
    private Releasable releasable;

    @Bean
    @ConditionalOnMissingBean
    public Client elasticsearchClient() {
        try {
            return this.createClient();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Client createClient() throws Exception {
        if (StringUtils.hasLength((String)this.properties.getClusterNodes())) {
            return this.createTransportClient();
        }
        return this.createNodeClient();
    }

    private Client createNodeClient() throws Exception {
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        for (Map.Entry<String, String> entry : DEFAULTS.entrySet()) {
            if (this.properties.getProperties().containsKey(entry.getKey())) continue;
            settings.put(entry.getKey(), entry.getValue());
        }
        settings.put(this.properties.getProperties());
        Node node = new NodeBuilder().settings((Settings.Builder)settings).clusterName(this.properties.getClusterName()).node();
        this.releasable = node;
        return node.client();
    }

    private Client createTransportClient() throws Exception {
        TransportClientFactoryBean factory = new TransportClientFactoryBean();
        factory.setClusterNodes(this.properties.getClusterNodes());
        factory.setProperties(this.createProperties());
        factory.afterPropertiesSet();
        TransportClient client = factory.getObject();
        this.releasable = client;
        return client;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        properties.put("cluster.name", this.properties.getClusterName());
        properties.putAll(this.properties.getProperties());
        return properties;
    }

    public void destroy() throws Exception {
        block6: {
            if (this.releasable != null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Closing Elasticsearch client");
                    }
                    try {
                        this.releasable.close();
                    }
                    catch (NoSuchMethodError ex) {
                        ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(Releasable.class, (String)"release"), (Object)this.releasable);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error((Object)"Error closing Elasticsearch client: ", (Throwable)ex);
                }
            }
        }
    }

    static {
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put("http.enabled", String.valueOf(false));
        defaults.put("node.local", String.valueOf(true));
        DEFAULTS = Collections.unmodifiableMap(defaults);
        logger = LogFactory.getLog(ElasticsearchAutoConfiguration.class);
    }
}

