/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.antlr.runtime.CommonToken;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecReducer;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileMapper;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanMapper;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.Graph;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Shell;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.hive.com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.apache.hive.common.util.ReflectionUtil;
import org.datanucleus.store.types.backed.List;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class Utilities {
    public static String HADOOP_LOCAL_FS = "file:///";
    public static String MAP_PLAN_NAME = "map.xml";
    public static String REDUCE_PLAN_NAME = "reduce.xml";
    public static String MERGE_PLAN_NAME = "merge.xml";
    public static final String INPUT_NAME = "iocontext.input.name";
    public static final String MAPRED_MAPPER_CLASS = "mapred.mapper.class";
    public static final String MAPRED_REDUCER_CLASS = "mapred.reducer.class";
    public static final String HIVE_ADDED_JARS = "hive.added.jars";
    public static String MAPNAME = "Map ";
    public static String REDUCENAME = "Reducer ";
    public static java.util.List<String> reduceFieldNameList = new ArrayList<String>();
    private static ThreadLocal<Map<Path, BaseWork>> gWorkMap;
    private static final String CLASS_NAME;
    private static final Log LOG;
    public static ThreadLocal<Kryo> runtimeSerializationKryo;
    public static ThreadLocal<Kryo> sparkSerializationKryo;
    private static ThreadLocal<Kryo> cloningQueryPlanKryo;
    public static TableDesc defaultTd;
    public static final int carriageReturnCode = 13;
    public static final int newLineCode = 10;
    public static final int tabCode = 9;
    public static final int ctrlaCode = 1;
    public static final String INDENT = "  ";
    public static String nullStringStorage;
    public static String nullStringOutput;
    public static Random randGen;
    public static final String NSTR = "";
    private static final String tmpPrefix = "_tmp.";
    private static final String taskTmpPrefix = "_task_tmp.";
    private static final Pattern FILE_NAME_TO_TASK_ID_REGEX;
    private static final String COPY_KEYWORD = "_copy_";
    private static final Pattern COPY_FILE_NAME_TO_TASK_ID_REGEX;
    private static final Pattern FILE_NAME_PREFIXED_TASK_ID_REGEX;
    private static final Pattern PREFIXED_TASK_ID_REGEX;
    private static final Object INPUT_SUMMARY_LOCK;
    public static String suffix;
    public static final char sqlEscapeChar = '\\';

    public static String removeValueTag(String column) {
        if (column.startsWith((Object)((Object)ReduceField.VALUE) + ".")) {
            return column.substring(6);
        }
        return column;
    }

    private Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearWork(Configuration conf) {
        Path mapPath = Utilities.getPlanPath(conf, MAP_PLAN_NAME);
        Path reducePath = Utilities.getPlanPath(conf, REDUCE_PLAN_NAME);
        if (mapPath == null && reducePath == null) {
            return;
        }
        try {
            FileSystem fs = mapPath.getFileSystem(conf);
            if (fs.exists(mapPath)) {
                fs.delete(mapPath, true);
            }
            if (fs.exists(reducePath)) {
                fs.delete(reducePath, true);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to clean-up tmp directories.", (Throwable)e);
        }
        finally {
            Utilities.clearWorkMapForConf(conf);
        }
    }

    public static MapredWork getMapRedWork(Configuration conf) {
        MapredWork w = new MapredWork();
        w.setMapWork(Utilities.getMapWork(conf));
        w.setReduceWork(Utilities.getReduceWork(conf));
        return w;
    }

    public static void cacheMapWork(Configuration conf, MapWork work, Path hiveScratchDir) {
        Utilities.cacheBaseWork(conf, MAP_PLAN_NAME, work, hiveScratchDir);
    }

    public static void setMapWork(Configuration conf, MapWork work) {
        Utilities.setBaseWork(conf, MAP_PLAN_NAME, work);
    }

    public static MapWork getMapWork(Configuration conf) {
        return (MapWork)Utilities.getBaseWork(conf, MAP_PLAN_NAME);
    }

    public static void setReduceWork(Configuration conf, ReduceWork work) {
        Utilities.setBaseWork(conf, REDUCE_PLAN_NAME, work);
    }

    public static ReduceWork getReduceWork(Configuration conf) {
        return (ReduceWork)Utilities.getBaseWork(conf, REDUCE_PLAN_NAME);
    }

    public static Path setMergeWork(JobConf conf, MergeJoinWork mergeJoinWork, Path mrScratchDir, boolean useCache) {
        for (BaseWork baseWork : mergeJoinWork.getBaseWorkList()) {
            String prefix = baseWork.getName();
            Utilities.setBaseWork((Configuration)conf, baseWork, mrScratchDir, prefix + MERGE_PLAN_NAME, useCache);
            String prefixes = conf.get("hive.tez.merge.file.prefixes");
            prefixes = prefixes == null ? prefix : prefixes + "," + prefix;
            conf.set("hive.tez.merge.file.prefixes", prefixes);
        }
        return null;
    }

    public static BaseWork getMergeWork(JobConf jconf) {
        if (jconf.get("hive.tez.current.merge.file.prefix") == null || jconf.get("hive.tez.current.merge.file.prefix").isEmpty()) {
            return null;
        }
        return Utilities.getMergeWork(jconf, jconf.get("hive.tez.current.merge.file.prefix"));
    }

    public static BaseWork getMergeWork(JobConf jconf, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return Utilities.getBaseWork((Configuration)jconf, prefix + MERGE_PLAN_NAME);
    }

    public static void cacheBaseWork(Configuration conf, String name, BaseWork work, Path hiveScratchDir) {
        try {
            Utilities.setPlanPath(conf, hiveScratchDir);
            Utilities.setBaseWork(conf, name, work);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to cache plan", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setBaseWork(Configuration conf, String name, BaseWork work) {
        Path path = Utilities.getPlanPath(conf, name);
        gWorkMap.get().put(path, work);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BaseWork getBaseWork(Configuration conf, String name) {
        BaseWork localPath;
        BaseWork gWork;
        Path path = null;
        InputStream in = null;
        try {
            String addedJars;
            String engine = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
            if (engine.equals("spark") && (addedJars = conf.get(HIVE_ADDED_JARS)) != null && !addedJars.isEmpty()) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                ClassLoader newLoader = Utilities.addToClassPath(loader, addedJars.split(";"));
                Thread.currentThread().setContextClassLoader(newLoader);
            }
            path = Utilities.getPlanPath(conf, name);
            LOG.info((Object)("PLAN PATH = " + path));
            assert (path != null);
            gWork = gWorkMap.get().get(path);
            if (gWork == null) {
                if (conf.getBoolean("mapreduce.task.uberized", false) && name.equals(REDUCE_PLAN_NAME)) {
                    localPath = new Path(name);
                } else if (ShimLoader.getHadoopShims().isLocalMode(conf)) {
                    localPath = path;
                } else {
                    LOG.info((Object)"***************non-local mode***************");
                    localPath = new Path(name);
                }
                localPath = path;
                LOG.info((Object)("local path = " + localPath));
                if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN)) {
                    LOG.debug((Object)("Loading plan from string: " + path.toUri().getPath()));
                    String planString = conf.get(path.toUri().getPath());
                    if (planString == null) {
                        LOG.info((Object)"Could not find plan string in conf");
                        BaseWork baseWork = null;
                        return baseWork;
                    }
                    byte[] planBytes = Base64.decodeBase64((String)planString);
                    in = new ByteArrayInputStream(planBytes);
                    in = new InflaterInputStream(in);
                } else {
                    LOG.info((Object)("Open file to read in plan: " + localPath));
                    in = localPath.getFileSystem(conf).open((Path)localPath);
                }
                if (MAP_PLAN_NAME.equals(name)) {
                    if (ExecMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) {
                        gWork = Utilities.deserializePlan(in, MapWork.class, conf);
                    } else if (MergeFileMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) {
                        gWork = Utilities.deserializePlan(in, MergeFileWork.class, conf);
                    } else if (ColumnTruncateMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) {
                        gWork = Utilities.deserializePlan(in, ColumnTruncateWork.class, conf);
                    } else {
                        if (!PartialScanMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) throw new RuntimeException("unable to determine work from configuration .mapred.mapper.class was " + conf.get(MAPRED_MAPPER_CLASS));
                        gWork = Utilities.deserializePlan(in, PartialScanWork.class, conf);
                    }
                } else if (REDUCE_PLAN_NAME.equals(name)) {
                    if (!ExecReducer.class.getName().equals(conf.get(MAPRED_REDUCER_CLASS))) throw new RuntimeException("unable to determine work from configuration .mapred.reducer.class was " + conf.get(MAPRED_REDUCER_CLASS));
                    gWork = Utilities.deserializePlan(in, ReduceWork.class, conf);
                } else if (name.contains(MERGE_PLAN_NAME)) {
                    if (name.startsWith(MAPNAME)) {
                        gWork = Utilities.deserializePlan(in, MapWork.class, conf);
                    } else {
                        if (!name.startsWith(REDUCENAME)) throw new RuntimeException("Unknown work type: " + name);
                        gWork = Utilities.deserializePlan(in, ReduceWork.class, conf);
                    }
                }
                gWorkMap.get().put(path, gWork);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found plan in cache for name: " + name));
            }
            localPath = gWork;
        }
        catch (FileNotFoundException fnf) {
            LOG.info((Object)("File not found: " + fnf.getMessage()));
            LOG.info((Object)("No plan file found: " + path));
            gWork = null;
            return gWork;
        }
        catch (Exception e) {
            String msg = "Failed to load plan: " + path + ": " + e;
            LOG.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException cantBlameMeForTrying) {}
            }
        }
        return localPath;
    }

    public static Map<Integer, String> getMapWorkVectorScratchColumnTypeMap(Configuration hiveConf) {
        MapWork mapWork = Utilities.getMapWork(hiveConf);
        return mapWork.getVectorScratchColumnTypeMap();
    }

    public static void setWorkflowAdjacencies(Configuration conf, QueryPlan plan) {
        try {
            Graph stageGraph = plan.getQueryPlan().getStageGraph();
            if (stageGraph == null) {
                return;
            }
            java.util.List<Adjacency> adjList = stageGraph.getAdjacencyList();
            if (adjList == null) {
                return;
            }
            for (Adjacency adj : adjList) {
                java.util.List<String> children = adj.getChildren();
                if (children == null || children.isEmpty()) {
                    return;
                }
                conf.setStrings("mapreduce.workflow.adjacency." + adj.getNode(), children.toArray(new String[children.size()]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static java.util.List<String> getFieldSchemaString(java.util.List<FieldSchema> fl) {
        if (fl == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema f : fl) {
            ret.add(f.getName() + " " + f.getType() + (f.getComment() != null ? " " + f.getComment() : NSTR));
        }
        return ret;
    }

    public static void setMapRedWork(Configuration conf, MapredWork w, Path hiveScratchDir) {
        String useName = conf.get(INPUT_NAME);
        if (useName == null) {
            useName = "mapreduce";
        }
        conf.set(INPUT_NAME, useName);
        Utilities.setMapWork(conf, w.getMapWork(), hiveScratchDir, true);
        if (w.getReduceWork() != null) {
            conf.set(INPUT_NAME, useName);
            Utilities.setReduceWork(conf, w.getReduceWork(), hiveScratchDir, true);
        }
    }

    public static Path setMapWork(Configuration conf, MapWork w, Path hiveScratchDir, boolean useCache) {
        return Utilities.setBaseWork(conf, w, hiveScratchDir, MAP_PLAN_NAME, useCache);
    }

    public static Path setReduceWork(Configuration conf, ReduceWork w, Path hiveScratchDir, boolean useCache) {
        return Utilities.setBaseWork(conf, w, hiveScratchDir, REDUCE_PLAN_NAME, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path setBaseWork(Configuration conf, BaseWork w, Path hiveScratchDir, String name, boolean useCache) {
        try {
            Path planPath;
            block11: {
                Object out;
                block10: {
                    Utilities.setPlanPath(conf, hiveScratchDir);
                    planPath = Utilities.getPlanPath(conf, name);
                    out = null;
                    if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN)) break block10;
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    try {
                        out = new DeflaterOutputStream((OutputStream)byteOut, new Deflater(1));
                        Utilities.serializePlan(w, (OutputStream)out, conf);
                        ((OutputStream)out).close();
                        out = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(out);
                        throw throwable;
                    }
                    IOUtils.closeStream((Closeable)out);
                    LOG.info((Object)("Setting plan: " + planPath.toUri().getPath()));
                    conf.set(planPath.toUri().getPath(), Base64.encodeBase64String((byte[])byteOut.toByteArray()));
                    break block11;
                }
                FileSystem fs = planPath.getFileSystem(conf);
                try {
                    out = fs.create(planPath);
                    Utilities.serializePlan(w, (OutputStream)out, conf);
                    ((OutputStream)out).close();
                    out = null;
                }
                finally {
                    IOUtils.closeStream((Closeable)out);
                }
                if (useCache && !ShimLoader.getHadoopShims().isLocalMode(conf)) {
                    if (!DistributedCache.getSymlink((Configuration)conf)) {
                        DistributedCache.createSymlink((Configuration)conf);
                    }
                    String uriWithLink = planPath.toUri().toString() + "#" + name;
                    DistributedCache.addCacheFile((URI)new URI(uriWithLink), (Configuration)conf);
                    short replication = (short)conf.getInt("mapred.submit.replication", 10);
                    fs.setReplication(planPath, replication);
                }
            }
            gWorkMap.get().put(planPath, w);
            return planPath;
        }
        catch (Exception e) {
            String msg = "Error caching " + name + ": " + e;
            LOG.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private static Path getPlanPath(Configuration conf, String name) {
        Path planPath = Utilities.getPlanPath(conf);
        if (planPath == null) {
            return null;
        }
        return new Path(planPath, name);
    }

    private static void setPlanPath(Configuration conf, Path hiveScratchDir) throws IOException {
        if (Utilities.getPlanPath(conf) == null) {
            String jobID = UUID.randomUUID().toString();
            Path planPath = new Path(hiveScratchDir, jobID);
            FileSystem fs = planPath.getFileSystem(conf);
            fs.mkdirs(planPath);
            HiveConf.setVar(conf, HiveConf.ConfVars.PLAN, planPath.toUri().toString());
        }
    }

    public static Path getPlanPath(Configuration conf) {
        String plan = HiveConf.getVar(conf, HiveConf.ConfVars.PLAN);
        if (plan != null && !plan.isEmpty()) {
            return new Path(plan);
        }
        return null;
    }

    public static byte[] serializeExpressionToKryo(ExprNodeGenericFuncDesc expr) {
        return Utilities.serializeObjectToKryo(expr);
    }

    public static ExprNodeGenericFuncDesc deserializeExpressionFromKryo(byte[] bytes) {
        return Utilities.deserializeObjectFromKryo(bytes, ExprNodeGenericFuncDesc.class);
    }

    public static String serializeExpression(ExprNodeGenericFuncDesc expr) {
        try {
            return new String(Base64.encodeBase64((byte[])Utilities.serializeExpressionToKryo(expr)), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    public static ExprNodeGenericFuncDesc deserializeExpression(String s) {
        byte[] bytes;
        try {
            bytes = Base64.decodeBase64((byte[])s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        return Utilities.deserializeExpressionFromKryo(bytes);
    }

    private static byte[] serializeObjectToKryo(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output(baos);
        runtimeSerializationKryo.get().writeObject(output, object);
        output.close();
        return baos.toByteArray();
    }

    private static <T extends Serializable> T deserializeObjectFromKryo(byte[] bytes, Class<T> clazz) {
        Input inp = new Input(new ByteArrayInputStream(bytes));
        Serializable func = (Serializable)runtimeSerializationKryo.get().readObject(inp, clazz);
        inp.close();
        return (T)func;
    }

    public static String serializeObject(Serializable expr) {
        try {
            return new String(Base64.encodeBase64((byte[])Utilities.serializeObjectToKryo(expr)), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    public static <T extends Serializable> T deserializeObject(String s, Class<T> clazz) {
        try {
            return Utilities.deserializeObjectFromKryo(Base64.decodeBase64((byte[])s.getBytes("UTF-8")), clazz);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    public static java.util.List<Operator<?>> cloneOperatorTree(Configuration conf, java.util.List<Operator<?>> roots) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        Utilities.serializePlan(roots, baos, conf, true);
        java.util.List result = (java.util.List)Utilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), roots.getClass(), conf, true);
        return result;
    }

    private static void serializePlan(Object plan, OutputStream out, Configuration conf, boolean cloningPlan) {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "serializePlan");
        String serializationType = conf.get(HiveConf.ConfVars.PLAN_SERIALIZATION.varname, "kryo");
        LOG.info((Object)("Serializing " + plan.getClass().getSimpleName() + " via " + serializationType));
        if ("javaXML".equalsIgnoreCase(serializationType)) {
            Utilities.serializeObjectByJavaXML(plan, out);
        } else if (cloningPlan) {
            Utilities.serializeObjectByKryo(cloningQueryPlanKryo.get(), plan, out);
        } else {
            Utilities.serializeObjectByKryo(runtimeSerializationKryo.get(), plan, out);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "serializePlan");
    }

    public static void serializePlan(Object plan, OutputStream out, Configuration conf) {
        Utilities.serializePlan(plan, out, conf, false);
    }

    private static <T> T deserializePlan(InputStream in, Class<T> planClass, Configuration conf, boolean cloningPlan) {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "deserializePlan");
        String serializationType = conf.get(HiveConf.ConfVars.PLAN_SERIALIZATION.varname, "kryo");
        LOG.info((Object)("Deserializing " + planClass.getSimpleName() + " via " + serializationType));
        T plan = "javaXML".equalsIgnoreCase(serializationType) ? Utilities.deserializeObjectByJavaXML(in) : (cloningPlan ? Utilities.deserializeObjectByKryo(cloningQueryPlanKryo.get(), in, planClass) : Utilities.deserializeObjectByKryo(runtimeSerializationKryo.get(), in, planClass));
        perfLogger.PerfLogEnd(CLASS_NAME, "deserializePlan");
        return plan;
    }

    public static <T> T deserializePlan(InputStream in, Class<T> planClass, Configuration conf) {
        return Utilities.deserializePlan(in, planClass, conf, false);
    }

    public static MapredWork clonePlan(MapredWork plan) {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "clonePlan");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        HiveConf conf = new HiveConf();
        Utilities.serializePlan(plan, baos, conf, true);
        MapredWork newPlan = Utilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), MapredWork.class, conf, true);
        perfLogger.PerfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    public static BaseWork cloneBaseWork(BaseWork plan) {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "clonePlan");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        HiveConf conf = new HiveConf();
        Utilities.serializePlan(plan, baos, conf, true);
        BaseWork newPlan = (BaseWork)Utilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), plan.getClass(), conf, true);
        perfLogger.PerfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    private static void serializeObjectByJavaXML(Object plan, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                LOG.warn((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new RuntimeException("Cannot serialize object", e);
            }
        });
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
        e.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
        e.setPersistenceDelegate(org.datanucleus.store.types.backed.Map.class, new MapDelegate());
        e.setPersistenceDelegate(List.class, new ListDelegate());
        e.setPersistenceDelegate(CommonToken.class, new CommonTokenDelegate());
        e.setPersistenceDelegate(Path.class, new PathDelegate());
        e.writeObject(plan);
        e.close();
    }

    private static void serializeObjectByKryo(Kryo kryo, Object plan, OutputStream out) {
        Output output = new Output(out);
        kryo.writeObject(output, plan);
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T deserializeObjectByJavaXML(InputStream in) {
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(in, null, null);
            Object object = d.readObject();
            return (T)object;
        }
        finally {
            if (null != d) {
                d.close();
            }
        }
    }

    private static <T> T deserializeObjectByKryo(Kryo kryo, InputStream in, Class<T> clazz) {
        Input inp = new Input(in);
        T t = kryo.readObject(inp, clazz);
        inp.close();
        return t;
    }

    protected static void removeField(Kryo kryo, Class type, String fieldName) {
        FieldSerializer fld = new FieldSerializer(kryo, type);
        fld.removeField(fieldName);
        kryo.register(type, fld);
    }

    public static String getTaskId(Configuration hconf) {
        String taskid;
        String string = taskid = hconf == null ? null : hconf.get("mapred.task.id");
        if (taskid == null || taskid.equals(NSTR)) {
            return NSTR + Math.abs(randGen.nextInt());
        }
        String ret = taskid.replaceAll(".*_[mr]_", NSTR).replaceAll(".*_(map|reduce)_", NSTR);
        return ret;
    }

    public static HashMap makeMap(Object ... olist) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (int i = 0; i < olist.length; i += 2) {
            ret.put(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static Properties makeProperties(String ... olist) {
        Properties ret = new Properties();
        for (int i = 0; i < olist.length; i += 2) {
            ret.setProperty(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static ArrayList makeList(Object ... olist) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object element : olist) {
            ret.add(element);
        }
        return ret;
    }

    public static TableDesc getTableDesc(Table tbl) {
        Properties props = tbl.getMetadata();
        props.put("serialization.lib", tbl.getDeserializer().getClass().getName());
        return new TableDesc(tbl.getInputFormatClass(), tbl.getOutputFormatClass(), props);
    }

    public static TableDesc getTableDesc(String cols, String colTypes) {
        return new TableDesc(SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", cols, "columns.types", colTypes, "serialization.lib", LazySimpleSerDe.class.getName()));
    }

    public static PartitionDesc getPartitionDesc(Partition part) throws HiveException {
        return new PartitionDesc(part);
    }

    public static PartitionDesc getPartitionDescFromTableDesc(TableDesc tblDesc, Partition part) throws HiveException {
        return new PartitionDesc(part, tblDesc);
    }

    private static String getOpTreeSkel_helper(Operator<?> op, String indent) {
        if (op == null) {
            return NSTR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(op.toString());
        sb.append("\n");
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                sb.append(Utilities.getOpTreeSkel_helper(child, indent + INDENT));
            }
        }
        return sb.toString();
    }

    public static String getOpTreeSkel(Operator<?> op) {
        return Utilities.getOpTreeSkel_helper(op, NSTR);
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) throws IOException {
        try {
            int c2;
            int c1;
            if (is1 == is2 || is1 == null && is2 == null) {
                return true;
            }
            if (is1 == null || is2 == null) {
                return false;
            }
            do {
                c1 = is1.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = is1.read();
                }
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                return true;
            } while (c1 == c2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String abbreviate(String str, int max) {
        str = str.trim();
        int len = str.length();
        int suffixlength = 20;
        if (len <= max) {
            return str;
        }
        suffixlength = Math.min(suffixlength, (max - 3) / 2);
        String rev = StringUtils.reverse((String)str);
        String suffix = WordUtils.abbreviate((String)rev, (int)0, (int)suffixlength, (String)NSTR);
        suffix = StringUtils.reverse((String)suffix);
        String prefix = StringUtils.abbreviate((String)str, (int)(max - suffix.length()));
        return prefix + suffix;
    }

    public static StreamStatus readColumn(DataInput in, OutputStream out) throws IOException {
        boolean foundCrChar = false;
        while (true) {
            byte b;
            try {
                b = in.readByte();
            }
            catch (EOFException e) {
                return StreamStatus.EOF;
            }
            if (Shell.WINDOWS) {
                if (foundCrChar && b != 10) {
                    out.write(13);
                    foundCrChar = false;
                }
                if (b == 13) {
                    foundCrChar = true;
                    continue;
                }
            }
            if (b == 10) {
                return StreamStatus.TERMINATED;
            }
            out.write(b);
        }
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createCompressedStream(jc, out, isCompressed);
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out, boolean isCompressed) throws IOException {
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
            return codec.createOutputStream(out);
        }
        return out;
    }

    @Deprecated
    public static String getFileExtension(JobConf jc, boolean isCompressed) {
        return Utilities.getFileExtension(jc, isCompressed, new HiveIgnoreKeyTextOutputFormat());
    }

    public static String getFileExtension(JobConf jc, boolean isCompressed, HiveOutputFormat<?, ?> hiveOutputFormat) {
        String extension = HiveConf.getVar((Configuration)jc, HiveConf.ConfVars.OUTPUT_FILE_EXTENSION);
        if (!StringUtils.isEmpty((String)extension)) {
            return extension;
        }
        if (hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat && isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
            return codec.getDefaultExtension();
        }
        return NSTR;
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, Progressable progressable) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createSequenceWriter(jc, fs, file, keyClass, valClass, isCompressed, progressable);
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, boolean isCompressed, Progressable progressable) throws IOException {
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        Class codecClass = null;
        if (isCompressed) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)jc);
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
        }
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)jc, (Path)file, keyClass, valClass, (SequenceFile.CompressionType)compressionType, codec, (Progressable)progressable);
    }

    public static RCFile.Writer createRCFileWriter(JobConf jc, FileSystem fs, Path file, boolean isCompressed, Progressable progressable) throws IOException {
        CompressionCodec codec = null;
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
        }
        return new RCFile.Writer(fs, (Configuration)jc, file, progressable, codec);
    }

    public static String realFile(String newFile, Configuration conf) throws IOException {
        Path path = new Path(newFile);
        URI pathURI = path.toUri();
        Object fs = pathURI.getScheme() == null ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
        if (!fs.exists(path)) {
            return null;
        }
        String file = path.makeQualified((FileSystem)fs).toString();
        return file;
    }

    public static java.util.List<String> mergeUniqElems(java.util.List<String> src, java.util.List<String> dest) {
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        for (int pos = 0; pos < dest.size(); ++pos) {
            if (src.contains(dest.get(pos))) continue;
            src.add(dest.get(pos));
        }
        return src;
    }

    public static Path toTaskTempPath(Path orig) {
        if (orig.getName().indexOf(taskTmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), taskTmpPrefix + orig.getName());
    }

    public static Path toTempPath(Path orig) {
        if (orig.getName().indexOf(tmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), tmpPrefix + orig.getName());
    }

    public static Path toTempPath(String orig) {
        return Utilities.toTempPath(new Path(orig));
    }

    public static boolean isTempPath(FileStatus file) {
        String name = file.getPath().getName();
        return name.startsWith("_task") || name.startsWith(tmpPrefix);
    }

    public static void rename(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.rename(src, dst)) {
            throw new HiveException("Unable to move: " + src + " to: " + dst);
        }
    }

    public static void renameOrMoveFiles(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.exists(dst)) {
            if (!fs.rename(src, dst)) {
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        } else {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(src)) {
                Path srcFilePath = file.getPath();
                String fileName = srcFilePath.getName();
                Path dstFilePath = new Path(dst, fileName);
                if (file.isDir()) {
                    Utilities.renameOrMoveFiles(fs, srcFilePath, dstFilePath);
                    continue;
                }
                if (fs.exists(dstFilePath)) {
                    int suffix = 0;
                    while (fs.exists(dstFilePath = new Path(dst, fileName + "_" + ++suffix))) {
                    }
                }
                if (fs.rename(srcFilePath, dstFilePath)) continue;
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        }
    }

    public static String getTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_TO_TASK_ID_REGEX);
    }

    public static String getPrefixedTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_PREFIXED_TASK_ID_REGEX);
    }

    private static String getIdFromFilename(String filename, Pattern pattern) {
        Matcher m;
        String taskId = filename;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = pattern.matcher(taskId)).matches()) {
            LOG.warn((Object)("Unable to get task id from file name: " + filename + ". Using last component" + taskId + " as task id."));
        } else {
            taskId = m.group(1);
        }
        LOG.debug((Object)("TaskId for " + filename + " = " + taskId));
        return taskId;
    }

    public static String getFileNameFromDirName(String dirName) {
        int dirEnd = dirName.lastIndexOf("/");
        if (dirEnd != -1) {
            return dirName.substring(dirEnd + 1);
        }
        return dirName;
    }

    public static String replaceTaskIdFromFilename(String filename, int bucketNum) {
        return Utilities.replaceTaskIdFromFilename(filename, String.valueOf(bucketNum));
    }

    public static String replaceTaskIdFromFilename(String filename, String fileId) {
        String taskId = Utilities.getTaskIdFromFilename(filename);
        String newTaskId = Utilities.replaceTaskId(taskId, fileId);
        String ret = Utilities.replaceTaskIdFromFilename(filename, taskId, newTaskId);
        return ret;
    }

    private static String replaceTaskId(String taskId, int bucketNum) {
        return Utilities.replaceTaskId(taskId, String.valueOf(bucketNum));
    }

    private static String replaceTaskId(String taskId, String strBucketNum) {
        Matcher m = PREFIXED_TASK_ID_REGEX.matcher(strBucketNum);
        if (!m.matches()) {
            LOG.warn((Object)("Unable to determine bucket number from file ID: " + strBucketNum + ". Using " + "file ID as bucket number."));
            return Utilities.adjustBucketNumLen(strBucketNum, taskId);
        }
        String adjustedBucketNum = Utilities.adjustBucketNumLen(m.group(2), taskId);
        return (m.group(1) == null ? NSTR : m.group(1)) + adjustedBucketNum;
    }

    private static String adjustBucketNumLen(String bucketNum, String taskId) {
        int bucketNumLen = bucketNum.length();
        int taskIdLen = taskId.length();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < taskIdLen - bucketNumLen; ++i) {
            s.append("0");
        }
        return s.toString() + bucketNum;
    }

    private static String replaceTaskIdFromFilename(String filename, String oldTaskId, String newTaskId) {
        String[] spl = filename.split(oldTaskId);
        if (spl.length == 0 || spl.length == 1) {
            return filename.replaceAll(oldTaskId, newTaskId);
        }
        StringBuffer snew = new StringBuffer();
        for (int idx = 0; idx < spl.length - 1; ++idx) {
            if (idx > 0) {
                snew.append(oldTaskId);
            }
            snew.append(spl[idx]);
        }
        snew.append(newTaskId);
        snew.append(spl[spl.length - 1]);
        return snew.toString();
    }

    public static FileStatus[] listStatusIfExists(Path path, FileSystem fs) throws IOException {
        try {
            return fs.listStatus(path, org.apache.hadoop.hive.common.FileUtils.HIDDEN_FILES_PATH_FILTER);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void mvFileToFinalPath(Path specPath, Configuration hconf, boolean success, Log log, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Reporter reporter) throws IOException, HiveException {
        FileSystem fs = specPath.getFileSystem(hconf);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        if (success) {
            if (fs.exists(tmpPath)) {
                ArrayList<String> emptyBuckets = Utilities.removeTempOrDuplicateFiles(fs, tmpPath, dpCtx);
                if (emptyBuckets.size() > 0) {
                    Utilities.createEmptyBuckets(hconf, emptyBuckets, conf, reporter);
                }
                log.info((Object)("Moving tmp dir: " + tmpPath + " to: " + specPath));
                Utilities.renameOrMoveFiles(fs, tmpPath, specPath);
            }
        } else {
            fs.delete(tmpPath, true);
        }
        fs.delete(taskTmpPath, true);
    }

    private static void createEmptyBuckets(Configuration hconf, ArrayList<String> paths, FileSinkDesc conf, Reporter reporter) throws HiveException, IOException {
        JobConf jc = hconf instanceof JobConf ? new JobConf(hconf) : new JobConf(hconf);
        HiveOutputFormat<?, ?> hiveOutputFormat = null;
        Class<? extends Writable> outputClass = null;
        boolean isCompressed = conf.getCompressed();
        TableDesc tableInfo = conf.getTableInfo();
        try {
            Serializer serializer = (Serializer)((Object)tableInfo.getDeserializerClass().newInstance());
            serializer.initialize(null, tableInfo.getProperties());
            outputClass = serializer.getSerializedClass();
            hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat(hconf, conf.getTableInfo());
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (InstantiationException e) {
            throw new HiveException(e);
        }
        catch (IllegalAccessException e) {
            throw new HiveException(e);
        }
        for (String p : paths) {
            Path path = new Path(p);
            FileSinkOperator.RecordWriter writer = HiveFileFormatUtils.getRecordWriter(jc, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), path, reporter);
            writer.close(false);
            LOG.info((Object)("created empty bucket for enforcing bucketing at " + path));
        }
    }

    public static void removeTempOrDuplicateFiles(FileSystem fs, Path path) throws IOException {
        Utilities.removeTempOrDuplicateFiles(fs, path, null);
    }

    public static ArrayList<String> removeTempOrDuplicateFiles(FileSystem fs, Path path, DynamicPartitionCtx dpCtx) throws IOException {
        if (path == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (dpCtx != null) {
            FileStatus[] parts = HiveStatsUtils.getFileStatusRecurse(path, dpCtx.getNumDPCols(), fs);
            HashMap<String, FileStatus> taskIDToFile = null;
            for (int i = 0; i < parts.length; ++i) {
                assert (parts[i].isDir()) : "dynamic partition " + parts[i].getPath() + " is not a directory";
                FileStatus[] items = fs.listStatus(parts[i].getPath());
                if (items.length == 0 && !fs.delete(parts[i].getPath(), true)) {
                    LOG.error((Object)("Cannot delete empty directory " + parts[i].getPath()));
                    throw new IOException("Cannot delete empty directory " + parts[i].getPath());
                }
                taskIDToFile = Utilities.removeTempOrDuplicateFiles(items, fs);
                if (dpCtx.getNumBuckets() <= 0 || taskIDToFile == null) continue;
                items = fs.listStatus(parts[i].getPath());
                String taskID1 = taskIDToFile.keySet().iterator().next();
                Path bucketPath = taskIDToFile.values().iterator().next().getPath();
                for (int j = 0; j < dpCtx.getNumBuckets(); ++j) {
                    String taskID2 = Utilities.replaceTaskId(taskID1, j);
                    if (taskIDToFile.containsKey(taskID2)) continue;
                    String path2 = Utilities.replaceTaskIdFromFilename(bucketPath.toUri().getPath().toString(), j);
                    result.add(path2);
                }
            }
        } else {
            FileStatus[] items = fs.listStatus(path);
            Utilities.removeTempOrDuplicateFiles(items, fs);
        }
        return result;
    }

    public static HashMap<String, FileStatus> removeTempOrDuplicateFiles(FileStatus[] items, FileSystem fs) throws IOException {
        if (items == null || fs == null) {
            return null;
        }
        HashMap<String, FileStatus> taskIdToFile = new HashMap<String, FileStatus>();
        for (FileStatus one : items) {
            if (Utilities.isTempPath(one)) {
                if (fs.delete(one.getPath(), true)) continue;
                throw new IOException("Unable to delete tmp file: " + one.getPath());
            }
            String taskId = Utilities.getPrefixedTaskIdFromFilename(one.getPath().getName());
            FileStatus otherFile = taskIdToFile.get(taskId);
            if (otherFile == null) {
                taskIdToFile.put(taskId, one);
                continue;
            }
            FileStatus toDelete = null;
            if (!Utilities.isCopyFile(one.getPath().getName())) {
                if (otherFile.getLen() >= one.getLen()) {
                    toDelete = one;
                } else {
                    toDelete = otherFile;
                    taskIdToFile.put(taskId, one);
                }
                long len1 = toDelete.getLen();
                long len2 = taskIdToFile.get(taskId).getLen();
                if (!fs.delete(toDelete.getPath(), true)) {
                    throw new IOException("Unable to delete duplicate file: " + toDelete.getPath() + ". Existing file: " + taskIdToFile.get(taskId).getPath());
                }
                LOG.warn((Object)("Duplicate taskid file removed: " + toDelete.getPath() + " with length " + len1 + ". Existing file: " + taskIdToFile.get(taskId).getPath() + " with length " + len2));
                continue;
            }
            LOG.info((Object)(one.getPath() + " file identified as duplicate. This file is" + " not deleted as it has copySuffix."));
        }
        return taskIdToFile;
    }

    public static boolean isCopyFile(String filename) {
        Matcher m;
        String taskId = filename;
        String copyFileSuffix = null;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = COPY_FILE_NAME_TO_TASK_ID_REGEX.matcher(taskId)).matches()) {
            LOG.warn((Object)("Unable to verify if file name " + filename + " has _copy_ suffix."));
        } else {
            taskId = m.group(1);
            copyFileSuffix = m.group(4);
        }
        LOG.debug((Object)("Filename: " + filename + " TaskId: " + taskId + " CopySuffix: " + copyFileSuffix));
        return taskId != null && copyFileSuffix != null;
    }

    public static String getBucketFileNameFromPathSubString(String bucketName) {
        try {
            return bucketName.split(COPY_KEYWORD)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return bucketName;
        }
    }

    public static String getNameMessage(Exception e) {
        return e.getClass().getName() + "(" + e.getMessage() + ")";
    }

    public static String getResourceFiles(Configuration conf, SessionState.ResourceType t) {
        Set<String> files;
        SessionState ss = SessionState.get();
        Set<String> set = files = ss == null ? null : ss.list_resource(t, null);
        if (files != null) {
            ArrayList<String> realFiles = new ArrayList<String>(files.size());
            for (String one : files) {
                try {
                    realFiles.add(Utilities.realFile(one, conf));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot validate file " + one + "due to exception: " + e.getMessage(), e);
                }
            }
            return StringUtils.join(realFiles, (String)",");
        }
        return NSTR;
    }

    public static ClassLoader getSessionSpecifiedClassLoader() {
        SessionState state = SessionState.get();
        if (state == null || state.getConf() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Hive Conf not found or Session not initiated, use thread based class loader instead");
            }
            return JavaUtils.getClassLoader();
        }
        ClassLoader sessionCL = state.getConf().getClassLoader();
        if (sessionCL != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Use session specified class loader");
            }
            return sessionCL;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Session specified class loader not found, use thread based class loader");
        }
        return JavaUtils.getClassLoader();
    }

    public static void restoreSessionSpecifiedClassLoader(ClassLoader prev) {
        ClassLoader current;
        SessionState state = SessionState.get();
        if (state != null && state.getConf() != null && (current = state.getConf().getClassLoader()) != prev && JavaUtils.closeClassLoadersTo(current, prev)) {
            Thread.currentThread().setContextClassLoader(prev);
            state.getConf().setClassLoader(prev);
        }
    }

    private static URL urlFromPathString(String onestr) {
        URL oneurl = null;
        try {
            oneurl = StringUtils.indexOf((String)onestr, (String)"file:/") == 0 ? new URL(onestr) : new File(onestr).toURL();
        }
        catch (Exception err) {
            LOG.error((Object)("Bad URL " + onestr + ", ignoring path"));
        }
        return oneurl;
    }

    public static Set<String> getJarFilesByPath(String path) {
        HashSet<String> result = new HashSet<String>();
        if (path == null || path.isEmpty()) {
            return result;
        }
        File paths = new File(path);
        if (paths.exists() && paths.isDirectory()) {
            HashSet jarFiles = new HashSet();
            jarFiles.addAll(FileUtils.listFiles((File)paths, (String[])new String[]{"jar"}, (boolean)true));
            for (File f : jarFiles) {
                result.add(f.getAbsolutePath());
            }
        } else {
            String[] files = path.split(",");
            Collections.addAll(result, files);
        }
        return result;
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        URLClassLoader loader = (URLClassLoader)cloader;
        java.util.List<URL> curPath = Arrays.asList(loader.getURLs());
        ArrayList<URL> newPath = new ArrayList<URL>();
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl = Utilities.urlFromPathString(onestr);
            if (oneurl == null || curPath.contains(oneurl)) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), (ClassLoader)loader);
    }

    public static void removeFromClassPath(String[] pathsToRemove) throws Exception {
        Thread curThread = Thread.currentThread();
        URLClassLoader loader = (URLClassLoader)curThread.getContextClassLoader();
        HashSet<URL> newPath = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        for (String onestr : pathsToRemove) {
            URL oneurl = Utilities.urlFromPathString(onestr);
            if (oneurl == null) continue;
            newPath.remove(oneurl);
        }
        JavaUtils.closeClassLoader(loader);
        Registry reg = SessionState.getRegistry();
        if (reg != null) {
            reg.removeFromUDFLoaders(loader);
        }
        loader = new URLClassLoader(newPath.toArray(new URL[0]));
        curThread.setContextClassLoader(loader);
        SessionState.get().getConf().setClassLoader(loader);
    }

    public static String formatBinaryString(byte[] array, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append("x");
            sb.append(array[i] < 0 ? array[i] + 256 : array[i] + 0);
        }
        return sb.toString();
    }

    public static java.util.List<String> getColumnNamesFromSortCols(java.util.List<Order> sortCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (Order o : sortCols) {
            names.add(o.getCol());
        }
        return names;
    }

    public static java.util.List<String> getColumnNamesFromFieldSchema(java.util.List<FieldSchema> partCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldSchema o : partCols) {
            names.add(o.getName());
        }
        return names;
    }

    public static java.util.List<String> getInternalColumnNamesFromSignature(java.util.List<ColumnInfo> colInfos) {
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnInfo ci : colInfos) {
            names.add(ci.getInternalName());
        }
        return names;
    }

    public static java.util.List<String> getColumnNames(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static java.util.List<String> getColumnTypes(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns.types");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static String[] getDbTableName(String dbtable) throws SemanticException {
        return Utilities.getDbTableName(SessionState.get().getCurrentDatabase(), dbtable);
    }

    public static String[] getDbTableName(String defaultDb, String dbtable) throws SemanticException {
        if (dbtable == null) {
            return new String[2];
        }
        String[] names = dbtable.split("\\.");
        switch (names.length) {
            case 2: {
                return names;
            }
            case 1: {
                return new String[]{defaultDb, dbtable};
            }
        }
        throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbtable);
    }

    public static String getDatabaseName(String dbTableName) throws SemanticException {
        String[] split = dbTableName.split("\\.");
        if (split.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbTableName);
        }
        return split[0];
    }

    public static String getTableName(String dbTableName) throws SemanticException {
        String[] split = dbTableName.split("\\.");
        if (split.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbTableName);
        }
        return split[1];
    }

    public static void validateColumnNames(java.util.List<String> colNames, java.util.List<String> checkCols) throws SemanticException {
        for (String toCheck : checkCols) {
            boolean found = false;
            for (String colName : colNames) {
                if (!toCheck.equalsIgnoreCase(colName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
        }
    }

    public static int getDefaultNotificationInterval(Configuration hconf) {
        Integer expInterval = Integer.decode(hconf.get("mapred.tasktracker.expiry.interval"));
        int notificationInterval = expInterval != null ? expInterval / 2 : 300000;
        return notificationInterval;
    }

    public static void copyTableJobPropertiesToConf(TableDesc tbl, Configuration job) {
        Properties tblProperties = tbl.getProperties();
        for (String name : tblProperties.stringPropertyNames()) {
            String val;
            if (job.get(name) != null || (val = (String)tblProperties.get(name)) == null) continue;
            job.set(name, StringEscapeUtils.escapeJava((String)val));
        }
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            job.set(entry.getKey(), entry.getValue());
        }
    }

    public static void copyTablePropertiesToConf(TableDesc tbl, JobConf job) {
        Properties tblProperties = tbl.getProperties();
        for (String name : tblProperties.stringPropertyNames()) {
            String val = (String)tblProperties.get(name);
            if (val == null) continue;
            job.set(name, StringEscapeUtils.escapeJava((String)val));
        }
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            job.set(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSummary getInputSummary(final Context ctx, MapWork work, PathFilter filter) throws IOException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getInputSummary");
        long[] summary = new long[]{0L, 0L, 0L};
        final ArrayList<String> pathNeedProcess = new ArrayList<String>();
        Object object = INPUT_SUMMARY_LOCK;
        synchronized (object) {
            ContentSummary contentSummary;
            ThreadPoolExecutor executor;
            for (String path : work.getPathToAliases().keySet()) {
                Path p = new Path(path);
                if (filter != null && !filter.accept(p)) continue;
                ContentSummary cs = ctx.getCS(path);
                if (cs == null) {
                    if (path == null) continue;
                    pathNeedProcess.add(path);
                    continue;
                }
                summary[0] = summary[0] + cs.getLength();
                summary[1] = summary[1] + cs.getFileCount();
                summary[2] = summary[2] + cs.getDirectoryCount();
            }
            final ConcurrentHashMap resultMap = new ConcurrentHashMap();
            ArrayList results = new ArrayList();
            int maxThreads = ctx.getConf().getInt("mapred.dfsclient.parallelism.max", 0);
            if (pathNeedProcess.size() > 1 && maxThreads > 1) {
                int numExecutors = Math.min(pathNeedProcess.size(), maxThreads);
                LOG.info((Object)("Using " + numExecutors + " threads for getContentSummary"));
                executor = new ThreadPoolExecutor(numExecutors, numExecutors, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            } else {
                executor = null;
            }
            HiveInterruptCallback interrup = HiveInterruptUtils.add(new HiveInterruptCallback(){

                @Override
                public void interrupt() {
                    for (String path : pathNeedProcess) {
                        try {
                            new Path(path).getFileSystem(ctx.getConf()).close();
                        }
                        catch (IOException ignore) {
                            LOG.debug((Object)ignore);
                        }
                    }
                    if (executor != null) {
                        executor.shutdownNow();
                    }
                }
            });
            try {
                Configuration conf = ctx.getConf();
                JobConf jobConf = new JobConf(conf);
                for (String string : pathNeedProcess) {
                    final Path p = new Path(string);
                    final String pathStr = string;
                    final Configuration myConf = conf;
                    final JobConf myJobConf = jobConf;
                    final LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = work.getAliasToWork();
                    final LinkedHashMap<String, ArrayList<String>> pathToAlias = work.getPathToAliases();
                    final PartitionDesc partDesc = work.getPathToPartitionInfo().get(p.toString());
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Class<? extends InputFormat> inputFormatCls = partDesc.getInputFileFormatClass();
                                InputFormat<WritableComparable, Writable> inputFormatObj = HiveInputFormat.getInputFormatFromCache(inputFormatCls, myJobConf);
                                if (inputFormatObj instanceof ContentSummaryInputFormat) {
                                    ContentSummaryInputFormat cs = (ContentSummaryInputFormat)inputFormatObj;
                                    resultMap.put(pathStr, cs.getContentSummary(p, myJobConf));
                                    return;
                                }
                                HiveStorageHandler handler = HiveUtils.getStorageHandler(myConf, SerDeUtils.createOverlayedProperties(partDesc.getTableDesc().getProperties(), partDesc.getProperties()).getProperty("storage_handler"));
                                if (handler instanceof InputEstimator) {
                                    long total = 0L;
                                    TableDesc tableDesc = partDesc.getTableDesc();
                                    InputEstimator estimator = (InputEstimator)((Object)handler);
                                    for (String alias : HiveFileFormatUtils.doGetAliasesFromPath(pathToAlias, p)) {
                                        JobConf jobConf = new JobConf((Configuration)myJobConf);
                                        TableScanOperator scanOp = (TableScanOperator)aliasToWork.get(alias);
                                        Utilities.setColumnNameList(jobConf, scanOp, true);
                                        Utilities.setColumnTypeList(jobConf, scanOp, true);
                                        PlanUtils.configureInputJobPropertiesForStorageHandler(tableDesc);
                                        Utilities.copyTableJobPropertiesToConf(tableDesc, (Configuration)jobConf);
                                        total += estimator.estimate(myJobConf, scanOp, -1L).getTotalLength();
                                    }
                                    resultMap.put(pathStr, new ContentSummary(total, -1L, -1L));
                                }
                                FileSystem fs = p.getFileSystem(myConf);
                                resultMap.put(pathStr, fs.getContentSummary(p));
                            }
                            catch (Exception e) {
                                LOG.info((Object)("Cannot get size of " + pathStr + ". Safely ignored."));
                            }
                        }
                    };
                    if (executor == null) {
                        r.run();
                        continue;
                    }
                    Future<?> result = executor.submit(r);
                    results.add(result);
                }
                if (executor != null) {
                    block11: for (Future future : results) {
                        boolean executorDone = false;
                        do {
                            try {
                                future.get();
                                executorDone = true;
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)"Interrupted when waiting threads: ", (Throwable)e);
                                Thread.currentThread().interrupt();
                                continue block11;
                            }
                            catch (ExecutionException e) {
                                throw new IOException(e);
                            }
                        } while (!executorDone);
                    }
                    executor.shutdown();
                }
                HiveInterruptUtils.checkInterrupted();
                for (Map.Entry entry : resultMap.entrySet()) {
                    ContentSummary cs = (ContentSummary)entry.getValue();
                    summary[0] = summary[0] + cs.getLength();
                    summary[1] = summary[1] + cs.getFileCount();
                    summary[2] = summary[2] + cs.getDirectoryCount();
                    ctx.addCS((String)entry.getKey(), cs);
                    LOG.info((Object)("Cache Content Summary for " + (String)entry.getKey() + " length: " + cs.getLength() + " file count: " + cs.getFileCount() + " directory count: " + cs.getDirectoryCount()));
                }
                perfLogger.PerfLogEnd(CLASS_NAME, "getInputSummary");
                contentSummary = new ContentSummary(summary[0], summary[1], summary[2]);
            }
            catch (Throwable throwable) {
                HiveInterruptUtils.remove(interrup);
                throw throwable;
            }
            HiveInterruptUtils.remove(interrup);
            return contentSummary;
        }
    }

    public static long sumOf(Map<String, Long> aliasToSize, Set<String> aliases) {
        return Utilities.sumOfExcept(aliasToSize, aliases, null);
    }

    public static long sumOfExcept(Map<String, Long> aliasToSize, Set<String> aliases, Set<String> excepts) {
        long total = 0L;
        for (String alias : aliases) {
            if (excepts != null && excepts.contains(alias)) continue;
            Long size = aliasToSize.get(alias);
            if (size == null) {
                return -1L;
            }
            total += size.longValue();
        }
        return total;
    }

    public static boolean isEmptyPath(JobConf job, Path dirPath, Context ctx) throws Exception {
        if (ctx != null) {
            ContentSummary cs = ctx.getCS(dirPath);
            if (cs != null) {
                LOG.info((Object)("Content Summary " + dirPath + "length: " + cs.getLength() + " num files: " + cs.getFileCount() + " num directories: " + cs.getDirectoryCount()));
                return cs.getLength() == 0L && cs.getFileCount() == 0L && cs.getDirectoryCount() <= 1L;
            }
            LOG.info((Object)("Content Summary not cached for " + dirPath));
        }
        return Utilities.isEmptyPath(job, dirPath);
    }

    public static boolean isEmptyPath(JobConf job, Path dirPath) throws Exception {
        FileStatus[] fStats;
        FileSystem inpFs = dirPath.getFileSystem((Configuration)job);
        return !inpFs.exists(dirPath) || (fStats = inpFs.listStatus(dirPath, org.apache.hadoop.hive.common.FileUtils.HIDDEN_FILES_PATH_FILTER)).length <= 0;
    }

    public static java.util.List<TezTask> getTezTasks(java.util.List<Task<? extends Serializable>> tasks) {
        ArrayList<TezTask> tezTasks = new ArrayList<TezTask>();
        if (tasks != null) {
            Utilities.getTezTasks(tasks, tezTasks);
        }
        return tezTasks;
    }

    private static void getTezTasks(java.util.List<Task<? extends Serializable>> tasks, java.util.List<TezTask> tezTasks) {
        for (Task<? extends Serializable> task : tasks) {
            if (task instanceof TezTask && !tezTasks.contains(task)) {
                tezTasks.add((TezTask)task);
            }
            if (task.getDependentTasks() == null) continue;
            Utilities.getTezTasks(task.getDependentTasks(), tezTasks);
        }
    }

    public static java.util.List<SparkTask> getSparkTasks(java.util.List<Task<? extends Serializable>> tasks) {
        ArrayList<SparkTask> sparkTasks = new ArrayList<SparkTask>();
        if (tasks != null) {
            Utilities.getSparkTasks(tasks, sparkTasks);
        }
        return sparkTasks;
    }

    private static void getSparkTasks(java.util.List<Task<? extends Serializable>> tasks, java.util.List<SparkTask> sparkTasks) {
        for (Task<? extends Serializable> task : tasks) {
            if (task instanceof SparkTask && !sparkTasks.contains(task)) {
                sparkTasks.add((SparkTask)task);
            }
            if (task.getDependentTasks() == null) continue;
            Utilities.getSparkTasks(task.getDependentTasks(), sparkTasks);
        }
    }

    public static java.util.List<ExecDriver> getMRTasks(java.util.List<Task<? extends Serializable>> tasks) {
        ArrayList<ExecDriver> mrTasks = new ArrayList<ExecDriver>();
        if (tasks != null) {
            Utilities.getMRTasks(tasks, mrTasks);
        }
        return mrTasks;
    }

    private static void getMRTasks(java.util.List<Task<? extends Serializable>> tasks, java.util.List<ExecDriver> mrTasks) {
        for (Task<? extends Serializable> task : tasks) {
            if (task instanceof ExecDriver && !mrTasks.contains(task)) {
                mrTasks.add((ExecDriver)task);
            }
            if (task.getDependentTasks() == null) continue;
            Utilities.getMRTasks(task.getDependentTasks(), mrTasks);
        }
    }

    public static java.util.List<LinkedHashMap<String, String>> getFullDPSpecs(Configuration conf, DynamicPartitionCtx dpCtx) throws HiveException {
        try {
            Path loadPath = dpCtx.getRootPath();
            FileSystem fs = loadPath.getFileSystem(conf);
            int numDPCols = dpCtx.getNumDPCols();
            FileStatus[] status = HiveStatsUtils.getFileStatusRecurse(loadPath, numDPCols, fs);
            if (status.length == 0) {
                LOG.warn((Object)"No partition is generated by dynamic partitioning");
                return null;
            }
            Map<String, String> partSpec = dpCtx.getPartSpec();
            ArrayList<LinkedHashMap<String, String>> fullPartSpecs = new ArrayList<LinkedHashMap<String, String>>();
            for (int i = 0; i < status.length; ++i) {
                Path partPath = status[i].getPath();
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                Warehouse.makeSpecFromName(fullPartSpec, (Path)partPath);
                fullPartSpecs.add(fullPartSpec);
            }
            return fullPartSpecs;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static StatsPublisher getStatsPublisher(JobConf jc) {
        StatsFactory factory = StatsFactory.newFactory((Configuration)jc);
        return factory == null ? null : factory.getStatsPublisher();
    }

    public static String getHashedStatsPrefix(String statsPrefix, int maxPrefixLength) {
        if (maxPrefixLength >= 0 && statsPrefix.length() > maxPrefixLength) {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                digester.update(statsPrefix.getBytes());
                return new String(digester.digest()) + "/";
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return statsPrefix.endsWith("/") ? statsPrefix : statsPrefix + "/";
    }

    public static String join(String ... elements) {
        StringBuilder builder = new StringBuilder();
        for (String element : elements) {
            if (element == null || element.isEmpty()) continue;
            builder.append(element);
            if (element.endsWith("/")) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    public static void setColumnNameList(JobConf jobConf, Operator op) {
        Utilities.setColumnNameList(jobConf, op, false);
    }

    public static void setColumnNameList(JobConf jobConf, Operator op, boolean excludeVCs) {
        RowSchema rowSchema = op.getSchema();
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnNames = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (excludeVCs && colInfo.getIsVirtualCol()) continue;
            if (columnNames.length() > 0) {
                columnNames.append(",");
            }
            columnNames.append(colInfo.getInternalName());
        }
        String columnNamesString = columnNames.toString();
        jobConf.set("columns", columnNamesString);
    }

    public static void setColumnTypeList(JobConf jobConf, Operator op) {
        Utilities.setColumnTypeList(jobConf, op, false);
    }

    public static void setColumnTypeList(JobConf jobConf, Operator op, boolean excludeVCs) {
        RowSchema rowSchema = op.getSchema();
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnTypes = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (excludeVCs && colInfo.getIsVirtualCol()) continue;
            if (columnTypes.length() > 0) {
                columnTypes.append(",");
            }
            columnTypes.append(colInfo.getTypeName());
        }
        String columnTypesString = columnTypes.toString();
        jobConf.set("columns.types", columnTypesString);
    }

    public static Path generatePath(Path basePath, String dumpFilePrefix, Byte tag, String bigBucketFileName) {
        return new Path(basePath, "MapJoin-" + dumpFilePrefix + tag + "-" + bigBucketFileName + suffix);
    }

    public static String generateFileName(Byte tag, String bigBucketFileName) {
        String fileName = new String("MapJoin-" + tag + "-" + bigBucketFileName + suffix);
        return fileName;
    }

    public static Path generateTmpPath(Path basePath, String id) {
        return new Path(basePath, "HashTable-" + id);
    }

    public static Path generateTarPath(Path basePath, String filename) {
        return new Path(basePath, filename + ".tar.gz");
    }

    public static String generateTarFileName(String name) {
        return name + ".tar.gz";
    }

    public static String generatePath(Path baseURI, String filename) {
        String path = new String(baseURI + "/" + filename);
        return path;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public static double showTime(long time) {
        double result = (double)time / 1000.0;
        return result;
    }

    public static void reworkMapRedWork(Task<? extends Serializable> task, boolean reworkMapredWork, HiveConf conf) throws SemanticException {
        if (reworkMapredWork && task instanceof MapRedTask) {
            try {
                MapredWork mapredWork = (MapredWork)((MapRedTask)task).getWork();
                HashSet<Class<? extends InputFormat>> reworkInputFormats = new HashSet<Class<? extends InputFormat>>();
                for (PartitionDesc partitionDesc : mapredWork.getMapWork().getPathToPartitionInfo().values()) {
                    Class<? extends InputFormat> inputFormatCls = partitionDesc.getInputFileFormatClass();
                    if (!ReworkMapredInputFormat.class.isAssignableFrom(inputFormatCls)) continue;
                    reworkInputFormats.add(inputFormatCls);
                }
                if (reworkInputFormats.size() > 0) {
                    for (Class clazz : reworkInputFormats) {
                        ReworkMapredInputFormat inst = (ReworkMapredInputFormat)ReflectionUtil.newInstance(clazz, null);
                        inst.rework(conf, mapredWork);
                    }
                }
            }
            catch (IOException e) {
                throw new SemanticException(e);
            }
        }
    }

    public static <T> T executeWithRetry(SQLCommand<T> cmd, PreparedStatement stmt, long baseWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        T result = null;
        int failures = 0;
        while (true) {
            try {
                result = cmd.run(stmt);
                return result;
            }
            catch (SQLTransientException e) {
                LOG.warn((Object)("Failure and retry #" + failures + " with exception " + e.getMessage()));
                if (failures >= maxRetries) {
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(baseWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException iex) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static Connection connectWithRetry(String connectionString, long waitWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        int failures = 0;
        while (true) {
            try {
                Connection conn = DriverManager.getConnection(connectionString);
                return conn;
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error((Object)("Error during JDBC connection. " + e));
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static PreparedStatement prepareWithRetry(Connection conn, String stmt, long waitWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        int failures = 0;
        while (true) {
            try {
                return conn.prepareStatement(stmt);
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error((Object)("Error preparing JDBC Statement " + stmt + " :" + e));
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static void setQueryTimeout(Statement stmt, int timeout) throws SQLException {
        if (timeout < 0) {
            LOG.info((Object)("Invalid query timeout " + timeout));
            return;
        }
        try {
            stmt.setQueryTimeout(timeout);
        }
        catch (SQLException e) {
            String message;
            String string = message = e.getMessage() == null ? null : e.getMessage().toLowerCase();
            if (e instanceof SQLFeatureNotSupportedException || message != null && (message.contains("implemented") || message.contains("supported"))) {
                LOG.info((Object)"setQueryTimeout is not supported");
                return;
            }
            throw e;
        }
    }

    public static long getRandomWaitTime(long baseWindow, int failures, Random r) {
        return (long)((double)(baseWindow * (long)failures) + (double)(baseWindow * (long)(failures + 1)) * r.nextDouble());
    }

    public static String escapeSqlLike(String key) {
        StringBuffer sb = new StringBuffer(key.length());
        for (char c : key.toCharArray()) {
            switch (c) {
                case '%': 
                case '\\': 
                case '_': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String formatMsecToStr(long msec) {
        long day = -1L;
        long hour = -1L;
        long minute = -1L;
        long second = -1L;
        long ms = msec % 1000L;
        long timeLeft = msec / 1000L;
        if (timeLeft > 0L) {
            second = timeLeft % 60L;
            if ((timeLeft /= 60L) > 0L) {
                minute = timeLeft % 60L;
                if ((timeLeft /= 60L) > 0L) {
                    hour = timeLeft % 24L;
                    day = timeLeft / 24L;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (day != -1L) {
            sb.append(day + " days ");
        }
        if (hour != -1L) {
            sb.append(hour + " hours ");
        }
        if (minute != -1L) {
            sb.append(minute + " minutes ");
        }
        if (second != -1L) {
            sb.append(second + " seconds ");
        }
        sb.append(ms + " msec");
        return sb.toString();
    }

    public static int estimateNumberOfReducers(HiveConf conf, ContentSummary inputSummary, MapWork work, boolean finalMapRed) throws IOException {
        long bytesPerReducer = conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
        double samplePercentage = Utilities.getHighestSamplePercentage(work);
        long totalInputFileSize = Utilities.getTotalInputFileSize(inputSummary, work, samplePercentage);
        if (totalInputFileSize != inputSummary.getLength()) {
            LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " estimated totalInputFileSize=" + totalInputFileSize));
        } else {
            LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " totalInputFileSize=" + totalInputFileSize));
        }
        boolean powersOfTwo = conf.getBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT_NUM_BUCKETS_POWER_TWO) && finalMapRed && !work.getBucketedColsByDirectory().isEmpty();
        return Utilities.estimateReducers(totalInputFileSize, bytesPerReducer, maxReducers, powersOfTwo);
    }

    public static int estimateReducers(long totalInputFileSize, long bytesPerReducer, int maxReducers, boolean powersOfTwo) {
        double bytes = Math.max(totalInputFileSize, bytesPerReducer);
        int reducers = (int)Math.ceil(bytes / (double)bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        int reducersLog = (int)(Math.log(reducers) / Math.log(2.0)) + 1;
        int reducersPowerTwo = (int)Math.pow(2.0, reducersLog);
        if (powersOfTwo && reducersPowerTwo / 2 != reducers) {
            reducers = reducersPowerTwo > maxReducers ? reducersPowerTwo / 2 : reducersPowerTwo;
        }
        return reducers;
    }

    public static long getTotalInputFileSize(ContentSummary inputSummary, MapWork work, double highestSamplePercentage) {
        long totalInputFileSize = inputSummary.getLength();
        if (work.getNameToSplitSample() == null || work.getNameToSplitSample().isEmpty()) {
            return totalInputFileSize;
        }
        if (highestSamplePercentage >= 0.0) {
            totalInputFileSize = Math.min((long)((double)totalInputFileSize * (highestSamplePercentage / 100.0)), totalInputFileSize);
        }
        return totalInputFileSize;
    }

    public static long getTotalInputNumFiles(ContentSummary inputSummary, MapWork work, double highestSamplePercentage) {
        long totalInputNumFiles = inputSummary.getFileCount();
        if (work.getNameToSplitSample() == null || work.getNameToSplitSample().isEmpty()) {
            return totalInputNumFiles;
        }
        if (highestSamplePercentage >= 0.0) {
            totalInputNumFiles = Math.min((long)((double)totalInputNumFiles * (highestSamplePercentage / 100.0)), totalInputNumFiles);
        }
        return totalInputNumFiles;
    }

    public static double getHighestSamplePercentage(MapWork work) {
        double highestSamplePercentage = 0.0;
        for (String alias : work.getAliasToWork().keySet()) {
            if (work.getNameToSplitSample().containsKey(alias)) {
                Double rate = work.getNameToSplitSample().get(alias).getPercent();
                if (rate == null || !(rate > highestSamplePercentage)) continue;
                highestSamplePercentage = rate;
                continue;
            }
            highestSamplePercentage = -1.0;
            break;
        }
        return highestSamplePercentage;
    }

    public static java.util.List<Path> getInputPathsTez(JobConf job, MapWork work) throws Exception {
        String scratchDir = job.get("_hive_tez_tmp_dir");
        java.util.List<Path> paths = Utilities.getInputPaths(job, work, new Path(scratchDir), null, !work.isUseOneNullRowInputFormat());
        return paths;
    }

    public static java.util.List<Path> getInputPaths(JobConf job, MapWork work, Path hiveScratchDir, Context ctx, boolean skipDummy) throws Exception {
        int sequenceNumber = 0;
        HashSet<Path> pathsProcessed = new HashSet<Path>();
        LinkedList<Path> pathsToAdd = new LinkedList<Path>();
        for (String alias : work.getAliasToWork().keySet()) {
            LOG.info((Object)("Processing alias " + alias));
            Path path = null;
            for (String file : new LinkedList<String>(work.getPathToAliases().keySet())) {
                java.util.List aliases = work.getPathToAliases().get(file);
                if (!aliases.contains(alias) || pathsProcessed.contains(path = new Path(file))) continue;
                pathsProcessed.add(path);
                LOG.info((Object)("Adding input file " + path));
                if (!skipDummy && Utilities.isEmptyPath(job, path, ctx)) {
                    path = Utilities.createDummyFileForEmptyPartition(path, job, work, hiveScratchDir, alias, sequenceNumber++);
                }
                pathsToAdd.add(path);
            }
            if (path != null || skipDummy) continue;
            path = Utilities.createDummyFileForEmptyTable(job, work, hiveScratchDir, alias, sequenceNumber++);
            pathsToAdd.add(path);
        }
        return pathsToAdd;
    }

    private static Path createEmptyFile(Path hiveScratchDir, HiveOutputFormat outFileFormat, JobConf job, int sequenceNumber, Properties props, boolean dummyRow) throws IOException, InstantiationException, IllegalAccessException {
        String newDir = hiveScratchDir + "/" + sequenceNumber;
        Path newPath = new Path(newDir);
        FileSystem fs = newPath.getFileSystem((Configuration)job);
        fs.mkdirs(newPath);
        newPath = fs.makeQualified(newPath);
        String newFile = newDir + "/" + "emptyFile";
        Path newFilePath = new Path(newFile);
        FileSinkOperator.RecordWriter recWriter = outFileFormat.getHiveRecordWriter(job, newFilePath, Text.class, false, props, null);
        if (dummyRow) {
            recWriter.write((Writable)new Text("empty"));
        }
        recWriter.close(false);
        return newPath;
    }

    private static Path createDummyFileForEmptyPartition(Path path, JobConf job, MapWork work, Path hiveScratchDir, String alias, int sequenceNumber) throws Exception {
        String strPath = path.toString();
        PartitionDesc partDesc = work.getPathToPartitionInfo().get(strPath);
        if (partDesc.getTableDesc().isNonNative()) {
            return path;
        }
        Properties props = SerDeUtils.createOverlayedProperties(partDesc.getTableDesc().getProperties(), partDesc.getProperties());
        HiveOutputFormat<?, ?> outFileFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, partDesc);
        boolean oneRow = partDesc.getInputFileFormatClass() == OneNullRowInputFormat.class;
        Path newPath = Utilities.createEmptyFile(hiveScratchDir, outFileFormat, job, sequenceNumber, props, oneRow);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Changed input file " + strPath + " to empty file " + newPath));
        }
        String strNewPath = newPath.toString();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = work.getPathToAliases();
        pathToAliases.put(strNewPath, pathToAliases.get(strPath));
        pathToAliases.remove(strPath);
        work.setPathToAliases(pathToAliases);
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = work.getPathToPartitionInfo();
        pathToPartitionInfo.put(strNewPath, pathToPartitionInfo.get(strPath));
        pathToPartitionInfo.remove(strPath);
        work.setPathToPartitionInfo(pathToPartitionInfo);
        return newPath;
    }

    private static Path createDummyFileForEmptyTable(JobConf job, MapWork work, Path hiveScratchDir, String alias, int sequenceNumber) throws Exception {
        TableDesc tableDesc = work.getAliasToPartnInfo().get(alias).getTableDesc();
        if (tableDesc.isNonNative()) {
            return null;
        }
        Properties props = tableDesc.getProperties();
        HiveOutputFormat<?, ?> outFileFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, tableDesc);
        Path newPath = Utilities.createEmptyFile(hiveScratchDir, outFileFormat, job, sequenceNumber, props, false);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Changed input file for alias " + alias + " to " + newPath));
        }
        LinkedHashMap<String, ArrayList<String>> pathToAliases = work.getPathToAliases();
        ArrayList<String> newList = new ArrayList<String>();
        newList.add(alias);
        pathToAliases.put(newPath.toUri().toString(), newList);
        work.setPathToAliases(pathToAliases);
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = work.getPathToPartitionInfo();
        PartitionDesc pDesc = work.getAliasToPartnInfo().get(alias).clone();
        pathToPartitionInfo.put(newPath.toUri().toString(), pDesc);
        work.setPathToPartitionInfo(pathToPartitionInfo);
        return newPath;
    }

    public static void setInputPaths(JobConf job, java.util.List<Path> pathsToAdd) {
        Path[] addedPaths = FileInputFormat.getInputPaths((JobConf)job);
        if (addedPaths == null) {
            addedPaths = new Path[]{};
        }
        Path[] combined = new Path[addedPaths.length + pathsToAdd.size()];
        System.arraycopy(addedPaths, 0, combined, 0, addedPaths.length);
        int i = 0;
        for (Path p : pathsToAdd) {
            combined[addedPaths.length + i++] = p;
        }
        FileInputFormat.setInputPaths((JobConf)job, (Path[])combined);
    }

    public static void setInputAttributes(Configuration conf, MapWork mWork) {
        HiveConf.ConfVars var;
        HiveConf.ConfVars confVars = var = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") ? HiveConf.ConfVars.HIVETEZINPUTFORMAT : HiveConf.ConfVars.HIVEINPUTFORMAT;
        if (mWork.getInputformat() != null) {
            HiveConf.setVar(conf, var, mWork.getInputformat());
        }
        if (mWork.getIndexIntermediateFile() != null) {
            conf.set(HiveConf.ConfVars.HIVE_INDEX_COMPACT_FILE.varname, mWork.getIndexIntermediateFile());
            conf.set(HiveConf.ConfVars.HIVE_INDEX_BLOCKFILTER_FILE.varname, mWork.getIndexIntermediateFile());
        }
        conf.setBoolean("hive.input.format.sorted", mWork.isInputFormatSorted());
    }

    public static void createTmpDirs(Configuration conf, MapWork mWork) throws IOException {
        LinkedHashMap<String, ArrayList<String>> pa = mWork.getPathToAliases();
        if (pa != null) {
            ArrayList<Operator<? extends OperatorDesc>> ops = new ArrayList<Operator<? extends OperatorDesc>>();
            for (java.util.List ls : pa.values()) {
                for (String a : ls) {
                    ops.add(mWork.getAliasToWork().get(a));
                }
            }
            Utilities.createTmpDirs(conf, ops);
        }
    }

    public static void createTmpDirs(Configuration conf, ReduceWork rWork) throws IOException {
        if (rWork == null) {
            return;
        }
        LinkedList<Operator<? extends OperatorDesc>> ops = new LinkedList<Operator<? extends OperatorDesc>>();
        ops.add(rWork.getReducer());
        Utilities.createTmpDirs(conf, ops);
    }

    private static void createTmpDirs(Configuration conf, java.util.List<Operator<? extends OperatorDesc>> ops) throws IOException {
        while (!ops.isEmpty()) {
            FileSinkDesc fdesc;
            Path tempDir;
            Operator<? extends OperatorDesc> op = ops.remove(0);
            if (op instanceof FileSinkOperator && (tempDir = (fdesc = (FileSinkDesc)((FileSinkOperator)op).getConf()).getDirName()) != null) {
                Path tempPath = Utilities.toTempPath(tempDir);
                FileSystem fs = tempPath.getFileSystem(conf);
                fs.mkdirs(tempPath);
            }
            if (op.getChildOperators() == null) continue;
            ops.addAll(op.getChildOperators());
        }
    }

    public static boolean createDirsWithPermission(Configuration conf, Path mkdirPath, FsPermission fsPermission, boolean recursive) throws IOException {
        String origUmask = null;
        LOG.debug((Object)("Create dirs " + mkdirPath + " with permission " + fsPermission + " recursive " + recursive));
        if (recursive) {
            origUmask = conf.get("fs.permissions.umask-mode");
            conf.set("fs.permissions.umask-mode", "000");
        }
        FileSystem fs = ShimLoader.getHadoopShims().getNonCachedFileSystem(mkdirPath.toUri(), conf);
        boolean retval = false;
        try {
            retval = fs.mkdirs(mkdirPath, fsPermission);
            Utilities.resetUmaskInConf(conf, recursive, origUmask);
        }
        catch (IOException ioe) {
            Utilities.resetUmaskInConf(conf, recursive, origUmask);
            throw ioe;
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
        }
        return retval;
    }

    private static void resetUmaskInConf(Configuration conf, boolean unsetUmask, String origUmask) {
        if (unsetUmask) {
            if (origUmask != null) {
                conf.set("fs.permissions.umask-mode", origUmask);
            } else {
                conf.unset("fs.permissions.umask-mode");
            }
        }
    }

    public static boolean isVectorMode(Configuration conf) {
        return HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && Utilities.getPlanPath(conf) != null && Utilities.getMapWork(conf).getVectorMode();
    }

    public static void clearWorkMapForConf(Configuration conf) {
        Path mapPath = Utilities.getPlanPath(conf, MAP_PLAN_NAME);
        Path reducePath = Utilities.getPlanPath(conf, REDUCE_PLAN_NAME);
        if (mapPath != null) {
            gWorkMap.get().remove(mapPath);
        }
        if (reducePath != null) {
            gWorkMap.get().remove(reducePath);
        }
    }

    public static void clearWorkMap() {
        gWorkMap.get().clear();
    }

    public static File createTempDir(String baseDir) {
        int MAX_ATTEMPS = 30;
        for (int i = 0; i < 30; ++i) {
            String tempDirName = "tmp_" + (int)(100000.0 * Math.random());
            File tempDir = new File(baseDir, tempDirName);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create a temp dir under " + baseDir + " Giving up after " + 30 + " attemps");
    }

    public static boolean skipHeader(RecordReader<WritableComparable, Writable> currRecReader, int headerCount, WritableComparable key, Writable value) throws IOException {
        while (headerCount > 0) {
            if (!currRecReader.next((Object)key, (Object)value)) {
                return false;
            }
            --headerCount;
        }
        return true;
    }

    public static int getHeaderCount(TableDesc table) throws IOException {
        int headerCount;
        try {
            headerCount = Integer.parseInt(table.getProperties().getProperty("skip.header.line.count", "0"));
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
        return headerCount;
    }

    public static int getFooterCount(TableDesc table, JobConf job) throws IOException {
        int footerCount;
        try {
            footerCount = Integer.parseInt(table.getProperties().getProperty("skip.footer.line.count", "0"));
            if (footerCount > HiveConf.getIntVar((Configuration)job, HiveConf.ConfVars.HIVE_FILE_MAX_FOOTER)) {
                throw new IOException("footer number exceeds the limit defined in hive.file.max.footer");
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
        return footerCount;
    }

    public static String getQualifiedPath(HiveConf conf, Path path) throws HiveException {
        if (path == null) {
            return null;
        }
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            return fs.makeQualified(path).toString();
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static boolean isDefaultNameNode(HiveConf conf) {
        return !conf.getChangedProperties().containsKey(HiveConf.ConfVars.HADOOPFS.varname);
    }

    public static boolean isPerfOrAboveLogging(HiveConf conf) {
        String loggingLevel = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
        return conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED) && (loggingLevel.equalsIgnoreCase("PERFORMANCE") || loggingLevel.equalsIgnoreCase("VERBOSE"));
    }

    public static void stripHivePasswordDetails(Configuration conf) {
        if (HiveConf.getVar(conf, HiveConf.ConfVars.METASTOREPWD) != null) {
            HiveConf.setVar(conf, HiveConf.ConfVars.METASTOREPWD, NSTR);
        }
        if (HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD) != null) {
            HiveConf.setVar(conf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD, NSTR);
        }
    }

    static {
        for (ReduceField r : ReduceField.values()) {
            reduceFieldNameList.add(r.toString());
        }
        gWorkMap = new ThreadLocal<Map<Path, BaseWork>>(){

            @Override
            protected Map<Path, BaseWork> initialValue() {
                return new HashMap<Path, BaseWork>();
            }
        };
        CLASS_NAME = Utilities.class.getName();
        LOG = LogFactory.getLog((String)CLASS_NAME);
        runtimeSerializationKryo = new ThreadLocal<Kryo>(){

            @Override
            protected synchronized Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                kryo.register(java.sql.Date.class, new SqlDateSerializer());
                kryo.register(Timestamp.class, new TimestampSerializer());
                kryo.register(Path.class, new PathSerializer());
                kryo.setInstantiatorStrategy(new StdInstantiatorStrategy());
                Utilities.removeField(kryo, Operator.class, "colExprMap");
                Utilities.removeField(kryo, ColumnInfo.class, "objectInspector");
                Utilities.removeField(kryo, AbstractOperatorDesc.class, "statistics");
                return kryo;
            }
        };
        sparkSerializationKryo = new ThreadLocal<Kryo>(){

            @Override
            protected synchronized Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                kryo.register(java.sql.Date.class, new SqlDateSerializer());
                kryo.register(Timestamp.class, new TimestampSerializer());
                kryo.register(Path.class, new PathSerializer());
                kryo.setInstantiatorStrategy(new StdInstantiatorStrategy());
                Utilities.removeField(kryo, Operator.class, "colExprMap");
                Utilities.removeField(kryo, ColumnInfo.class, "objectInspector");
                kryo.register(SparkEdgeProperty.class);
                kryo.register(MapWork.class);
                kryo.register(ReduceWork.class);
                kryo.register(SparkWork.class);
                kryo.register(TableDesc.class);
                kryo.register(Pair.class);
                return kryo;
            }
        };
        cloningQueryPlanKryo = new ThreadLocal<Kryo>(){

            @Override
            protected synchronized Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                kryo.register(CommonToken.class, new CommonTokenSerializer());
                kryo.register(java.sql.Date.class, new SqlDateSerializer());
                kryo.register(Timestamp.class, new TimestampSerializer());
                kryo.register(Path.class, new PathSerializer());
                kryo.setInstantiatorStrategy(new StdInstantiatorStrategy());
                return kryo;
            }
        };
        defaultTd = PlanUtils.getDefaultTableDesc("1");
        nullStringStorage = "\\N";
        nullStringOutput = "NULL";
        randGen = new Random();
        FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^.*?([0-9]+)(_[0-9]{1,6})?(\\..*)?$");
        COPY_FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^.*?([0-9]+)(_)([0-9]{1,6})?((_)(\\Bcopy\\B)(_)([0-9]{1,6})$)?(\\..*)?$");
        FILE_NAME_PREFIXED_TASK_ID_REGEX = Pattern.compile("^.*?((\\(.*\\))?[0-9]+)(_[0-9]{1,6})?(\\..*)?$");
        PREFIXED_TASK_ID_REGEX = Pattern.compile("^(.*?\\(.*\\))?([0-9]+)$");
        INPUT_SUMMARY_LOCK = new Object();
        suffix = ".hashtable";
    }

    public static class SQLCommand<T> {
        public T run(PreparedStatement stmt) throws SQLException {
            return null;
        }
    }

    public static enum StreamStatus {
        EOF,
        TERMINATED;

    }

    private static class PathSerializer
    extends org.apache.hive.com.esotericsoftware.kryo.Serializer<Path> {
        private PathSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, Path path) {
            output.writeString(path.toUri().toString());
        }

        @Override
        public Path read(Kryo kryo, Input input, Class<Path> type) {
            return new Path(URI.create(input.readString()));
        }
    }

    private static class CommonTokenSerializer
    extends org.apache.hive.com.esotericsoftware.kryo.Serializer<CommonToken> {
        private CommonTokenSerializer() {
        }

        @Override
        public CommonToken read(Kryo kryo, Input input, Class<CommonToken> clazz) {
            return new CommonToken(input.readInt(), input.readString());
        }

        @Override
        public void write(Kryo kryo, Output output, CommonToken token) {
            output.writeInt(token.getType());
            output.writeString(token.getText());
        }
    }

    private static class SqlDateSerializer
    extends org.apache.hive.com.esotericsoftware.kryo.Serializer<java.sql.Date> {
        private SqlDateSerializer() {
        }

        @Override
        public java.sql.Date read(Kryo kryo, Input input, Class<java.sql.Date> clazz) {
            return new java.sql.Date(input.readLong());
        }

        @Override
        public void write(Kryo kryo, Output output, java.sql.Date sqlDate) {
            output.writeLong(sqlDate.getTime());
        }
    }

    private static class TimestampSerializer
    extends org.apache.hive.com.esotericsoftware.kryo.Serializer<Timestamp> {
        private TimestampSerializer() {
        }

        @Override
        public Timestamp read(Kryo kryo, Input input, Class<Timestamp> clazz) {
            Timestamp ts = new Timestamp(input.readLong());
            ts.setNanos(input.readInt());
            return ts;
        }

        @Override
        public void write(Kryo kryo, Output output, Timestamp ts) {
            output.writeLong(ts.getTime());
            output.writeInt(ts.getNanos());
        }
    }

    public static class CollectionPersistenceDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", null);
        }

        protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
            Iterator ite = ((Collection)oldInstance).iterator();
            while (ite.hasNext()) {
                out.writeStatement(new java.beans.Statement(oldInstance, "add", new Object[]{ite.next()}));
            }
        }
    }

    public static class PathDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Path p = (Path)oldInstance;
            Object[] args = new Object[]{p.toString()};
            return new Expression(p, p.getClass(), "new", args);
        }
    }

    public static class CommonTokenDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            CommonToken ct = (CommonToken)oldInstance;
            Object[] args = new Object[]{ct.getType(), ct.getText()};
            return new Expression(ct, ct.getClass(), "new", args);
        }
    }

    public static class TimestampPersistenceDelegate
    extends DatePersistenceDelegate {
        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Timestamp ts = (Timestamp)oldInstance;
            Object[] args = new Object[]{ts.getNanos()};
            java.beans.Statement stmt = new java.beans.Statement(oldInstance, "setNanos", args);
            out.writeStatement(stmt);
        }
    }

    public static class DatePersistenceDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Date dateVal = (Date)oldInstance;
            Object[] args = new Object[]{dateVal.getTime()};
            return new Expression(dateVal, dateVal.getClass(), "new", args);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            if (oldInstance == null || newInstance == null) {
                return false;
            }
            return oldInstance.getClass() == newInstance.getClass();
        }
    }

    public static class ListDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            java.util.List oldList = (java.util.List)oldInstance;
            ArrayList newList = new ArrayList(oldList);
            return new Expression(newList, ArrayList.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new java.beans.Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new java.beans.Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class SetDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Set oldSet = (Set)oldInstance;
            HashSet newSet = new HashSet(oldSet);
            return new Expression(newSet, HashSet.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new java.beans.Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new java.beans.Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class MapDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Map oldMap = (Map)oldInstance;
            HashMap newMap = new HashMap(oldMap);
            return new Expression(newMap, HashMap.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new java.beans.Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new java.beans.Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class EnumDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(Enum.class, "valueOf", new Object[]{oldInstance.getClass(), ((Enum)oldInstance).name()});
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }
    }

    public static enum ReduceField {
        KEY,
        VALUE;

    }
}

