/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.hbase.WikittyHBaseUtil;

public class WikittyStorageHBase
implements WikittyStorage {
    private static Log log = LogFactory.getLog(WikittyStorageHBase.class);
    protected WikittyExtensionStorage extensionStorage;
    protected HTable hTable;

    public WikittyStorageHBase(WikittyExtensionStorage extensionStorage) {
        this.extensionStorage = extensionStorage;
        try {
            this.hTable = new HTable(WikittyHBaseUtil.getHBaseConfiguration(), WikittyHBaseUtil.T_WIKITTY);
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) throws WikittyException {
        try {
            UpdateResponse result = new UpdateResponse();
            ArrayList<Put> puts = new ArrayList<Put>();
            for (Wikitty wikitty : wikitties) {
                byte[] id = Bytes.toBytes((String)wikitty.getId());
                Get get = new Get(id);
                get.addColumn(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION);
                get.addColumn(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE);
                Result row = this.hTable.get(get);
                byte[] valueVersion = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION);
                String actualVersion = valueVersion == null ? null : Bytes.toString((byte[])valueVersion);
                String requestedVersion = wikitty.getVersion();
                String newVersion = null;
                if (disableAutoVersionIncrement) {
                    if (actualVersion == null) {
                        newVersion = requestedVersion == null ? "0.0" : requestedVersion;
                    } else if (requestedVersion == null) {
                        newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                    } else {
                        if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                        if (!WikittyUtil.versionGreaterThan((String)requestedVersion, (String)actualVersion)) throw new WikittyException(String.format("Your wikitty '%s' is obsolete (saving: '%s'; existing: '%s')", wikitty.getId(), requestedVersion, actualVersion));
                        newVersion = requestedVersion;
                    }
                } else {
                    if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                    if (WikittyUtil.versionGreaterThan((String)actualVersion, (String)requestedVersion)) {
                        throw new WikittyException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                    }
                    newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                }
                byte[] valueDeleteDate = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE);
                if (valueDeleteDate != null) {
                    throw new WikittyException(String.format("Your wikitty '%s' is deleted, you can't save it", wikitty.getId()));
                }
                Put put = new Put(id);
                put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_ID, id);
                put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION, Bytes.toBytes((String)newVersion));
                String extensionList = "";
                for (WikittyExtension ext : wikitty.getExtensions()) {
                    extensionList = extensionList + "," + ext.getId();
                    for (String fieldName : ext.getFieldNames()) {
                        byte[] byteValue;
                        FieldType type = ext.getFieldType(fieldName);
                        String fqFieldName = ext.getName() + "." + fieldName;
                        if (type.isCollection()) {
                            List list = wikitty.getFieldAsList(ext.getName(), fieldName, Object.class);
                            if (list != null) {
                                byteValue = WikittyHBaseUtil.toBytes(new ArrayList(list));
                                put.add(WikittyHBaseUtil.F_DATA, Bytes.toBytes((String)fqFieldName), byteValue);
                                continue;
                            }
                            if (type.isNotNull()) {
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                            if (!wikitty.fieldNames().contains(fqFieldName)) continue;
                            put.add(WikittyHBaseUtil.F_DATA, Bytes.toBytes((String)fqFieldName), WikittyHBaseUtil.NULL);
                            continue;
                        }
                        Object value = wikitty.getFieldAsObject(ext.getName(), fieldName);
                        if (value != null) {
                            byteValue = WikittyHBaseUtil.toBytes(type, value);
                            put.add(WikittyHBaseUtil.F_DATA, Bytes.toBytes((String)fqFieldName), byteValue);
                            continue;
                        }
                        if (type.isNotNull()) {
                            throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                        }
                        if (!wikitty.fieldNames().contains(fqFieldName)) continue;
                        put.add(WikittyHBaseUtil.F_DATA, Bytes.toBytes((String)fqFieldName), WikittyHBaseUtil.NULL);
                    }
                }
                if (extensionList.length() > 0) {
                    extensionList = extensionList.substring(1);
                }
                put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_EXTENSION, Bytes.toBytes((String)extensionList));
                wikitty.setVersion(newVersion);
                wikitty.clearDirty();
                result.addVersionUpdate(wikitty.getId(), newVersion);
                puts.add(put);
            }
            this.hTable.put(puts);
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            UpdateResponse result = new UpdateResponse();
            ArrayList<Put> puts = new ArrayList<Put>();
            Date now = new Date();
            for (String id : ids) {
                if (!this.exists(transaction, id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' don't exists", id));
                }
                Put put = new Put(Bytes.toBytes((String)id));
                put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE, Bytes.toBytes((long)now.getTime()));
                puts.add(put);
                result.addDeletionDateUpdate(id, now);
            }
            this.hTable.put(puts);
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        try {
            Get get = new Get(Bytes.toBytes((String)id));
            boolean result = this.hTable.exists(get);
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        try {
            Get get = new Get(Bytes.toBytes((String)id));
            get.addColumn(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE);
            Result row = this.hTable.get(get);
            byte[] value = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE);
            boolean result = value != null;
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) {
        try {
            Get get = new Get(Bytes.toBytes((String)id));
            Result row = this.hTable.get(get);
            if (row.isEmpty()) {
                throw new WikittyException(String.format("The wikitty not exsist with id '%s'", id));
            }
            Wikitty result = this.constructWikitty(transaction, row, fqFieldName);
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException(String.format("Can't restore wikitty '%s'", id), (Exception)eee);
        }
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        try {
            Scan scan = new Scan();
            ResultScanner resultScanner = this.hTable.getScanner(scan);
            Result row = resultScanner.next();
            while (row != null) {
                Wikitty wikitty = this.constructWikitty(transaction, row, new String[0]);
                scanner.scan(wikitty);
                row = resultScanner.next();
            }
        }
        catch (IOException eee) {
            throw new WikittyException(String.format("Can't scan wikitties", new Object[0]), (Exception)eee);
        }
    }

    protected Wikitty constructWikitty(WikittyTransaction transaction, Result row, String ... fqFieldName) {
        String extensionList;
        byte[] extensions;
        byte[] deleteDate;
        HashSet<String> acceptedField = new HashSet<String>(Arrays.asList(fqFieldName));
        String id = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_ID));
        Wikitty result = new Wikitty(id);
        byte[] version = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION);
        if (version != null) {
            result.setVersion(Bytes.toString((byte[])version));
        }
        if ((deleteDate = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_DELETE_DATE)) != null) {
            Date date = new Date(Bytes.toLong((byte[])deleteDate));
            result.setDeleteDate(date);
        }
        if ((extensions = row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_EXTENSION)) != null && !"".equals(extensionList = Bytes.toString((byte[])extensions))) {
            for (String ext : extensionList.split(",")) {
                String extName = WikittyExtension.computeName((String)ext);
                String extVersion = WikittyExtension.computeVersion((String)ext);
                WikittyExtension extension = this.extensionStorage.restore(transaction, extName, extVersion);
                result.addExtension(extension);
            }
        }
        for (KeyValue keyValue : row.list()) {
            byte[] value;
            FieldType type;
            String[] field;
            WikittyExtension ext;
            byte[] qualifier;
            String fqfieldName;
            if (!Bytes.equals((byte[])WikittyHBaseUtil.F_DATA, (byte[])keyValue.getFamily()) || !this.isAcceptedField(acceptedField, fqfieldName = Bytes.toString((byte[])(qualifier = keyValue.getQualifier()))) || (ext = result.getExtension((field = fqfieldName.split("\\."))[0])) == null) continue;
            String fieldName = field[1];
            int crochet = fieldName.indexOf("[");
            if (crochet != -1) {
                fieldName = fieldName.substring(0, crochet);
            }
            if ((type = ext.getFieldType(fieldName)) == null || Arrays.equals(value = keyValue.getValue(), WikittyHBaseUtil.NULL)) continue;
            if (type.isCollection()) {
                List list = (List)WikittyHBaseUtil.fromBytes(value);
                result.setFqField(fqfieldName, (Object)list);
                continue;
            }
            Object object = WikittyHBaseUtil.fromBytes(type, value);
            result.setFqField(fqfieldName, object);
        }
        return result;
    }

    protected boolean isAcceptedField(Set<String> acceptedField, String fqfieldName) {
        boolean result = acceptedField.isEmpty();
        if (!result) {
            int crochet = fqfieldName.indexOf("[");
            if (crochet != -1) {
                fqfieldName = fqfieldName.substring(0, crochet);
            }
            result = acceptedField.contains(fqfieldName);
        }
        return result;
    }

    public void clear(WikittyTransaction transaction) {
    }
}

