/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.hbase.WikittyHBaseUtil;

public class WikittyExtensionStorageHBase
implements WikittyExtensionStorage {
    private static Log log = LogFactory.getLog(WikittyExtensionStorageHBase.class);
    protected HTable hTable;
    protected Map<String, WikittyExtension> extensionCache = new HashMap<String, WikittyExtension>();
    protected Map<String, String> lastVersion = null;

    public WikittyExtensionStorageHBase() {
        try {
            this.hTable = new HTable(WikittyHBaseUtil.getHBaseConfiguration(), WikittyHBaseUtil.T_EXTENSION);
            this.lastVersion = new HashMap<String, String>();
            ResultScanner scanner = this.hTable.getScanner(WikittyHBaseUtil.F_ADMIN);
            for (Result row : scanner) {
                String name = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_NAME));
                String version = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION));
                String prevVersion = this.lastVersion.get(name);
                if (prevVersion != null && !WikittyUtil.versionGreaterThan((String)version, (String)prevVersion)) continue;
                this.lastVersion.put(name, version);
            }
            scanner.close();
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) {
        try {
            ArrayList<Put> puts = new ArrayList<Put>();
            for (WikittyExtension ext : extensions) {
                String extLastVersion;
                String extId = ext.getId();
                String extName = ext.getName();
                String extVersion = ext.getVersion();
                if (WikittyUtil.versionGreaterThan((String)extVersion, (String)(extLastVersion = this.getLastVersion(transaction, extName)))) {
                    Put put = new Put(Bytes.toBytes((String)extId));
                    put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_NAME, Bytes.toBytes((String)extName));
                    put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION, Bytes.toBytes((String)extVersion));
                    String extTagValues = WikittyUtil.tagValuesToString((Map)ext.getTagValues());
                    put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_TAGVALUES, Bytes.toBytes((String)extTagValues));
                    String requires = ext.getRequires();
                    if (requires != null) {
                        put.add(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_REQUIRES, Bytes.toBytes((String)requires));
                    }
                    for (String fieldName : ext.getFieldNames()) {
                        FieldType type = ext.getFieldType(fieldName);
                        put.add(WikittyHBaseUtil.F_DATA, Bytes.toBytes((String)fieldName), Bytes.toBytes((String)type.toDefinition(fieldName)));
                    }
                    this.lastVersion.put(extName, extVersion);
                    puts.add(put);
                    continue;
                }
                if (WikittyUtil.versionEquals((String)extVersion, (String)extLastVersion)) continue;
                throw new WikittyException(String.format("Your extension '%s' is obsolete", extId));
            }
            this.hTable.put(puts);
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        if (this.extensionCache.containsKey(id)) {
            return true;
        }
        try {
            Get get = new Get(Bytes.toBytes((String)id));
            boolean result = this.hTable.exists(get);
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        try {
            ResultScanner scanner = this.hTable.getScanner(WikittyHBaseUtil.F_ADMIN);
            ArrayList<String> result = new ArrayList<String>();
            for (Result row : scanner) {
                String name = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_NAME));
                String version = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION));
                result.add(WikittyExtension.computeId((String)name, (String)version));
            }
            scanner.close();
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        try {
            ResultScanner scanner = this.hTable.getScanner(WikittyHBaseUtil.F_ADMIN);
            ArrayList<String> result = new ArrayList<String>();
            for (Result row : scanner) {
                String requires = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_REQUIRES));
                if (!extensionName.equals(requires)) continue;
                String name = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_NAME));
                String version = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION));
                result.add(WikittyExtension.computeId((String)name, (String)version));
            }
            scanner.close();
            return result;
        }
        catch (IOException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public String getLastVersion(WikittyTransaction transaction, String extName) {
        String result = this.lastVersion.get(extName);
        log.debug((Object)("LastVersion=" + result + " for " + extName));
        return result;
    }

    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        String id = WikittyExtension.computeId((String)name, (String)version);
        WikittyExtension result = this.extensionCache.get(id);
        log.debug((Object)("Extension found in cache=" + result));
        if (result == null) {
            try {
                Get get = new Get(Bytes.toBytes((String)id));
                Result row = this.hTable.get(get);
                if (row.isEmpty()) {
                    log.debug((Object)"Extension not found");
                    return null;
                }
                String extName = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_NAME));
                String extVersion = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_VERSION));
                String requires = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_REQUIRES));
                LinkedHashMap<String, FieldType> fieldTypes = new LinkedHashMap<String, FieldType>();
                for (KeyValue keyValue : row.list()) {
                    if (!Bytes.equals((byte[])WikittyHBaseUtil.F_DATA, (byte[])keyValue.getFamily())) continue;
                    String fieldDef = Bytes.toString((byte[])keyValue.getValue());
                    FieldType fieldType = new FieldType();
                    String fieldName = WikittyUtil.parseField((String)fieldDef, (FieldType)fieldType);
                    fieldTypes.put(fieldName, fieldType);
                }
                result = new WikittyExtension(extName, extVersion, requires, fieldTypes);
                String tagValues = Bytes.toString((byte[])row.getValue(WikittyHBaseUtil.F_ADMIN, WikittyHBaseUtil.Q_TAGVALUES));
                result.setTagValues(WikittyUtil.tagValuesToMap((String)tagValues));
                this.extensionCache.put(id, result);
            }
            catch (IOException eee) {
                throw new WikittyException(String.format("Can't load extension %s", id), (Exception)eee);
            }
        }
        log.debug((Object)("Extension restored=" + result));
        return result;
    }

    public void clear(WikittyTransaction transaction) {
    }
}

