/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.hbase;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.AbstractWikittyService;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittySearchEngin;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.solr.WikittySearchEnginSolr;

/**
 * HBase must have 2 definitions, one for extension and one for wikitty object.
 *
 * extension:
 * - admin: id, version, ...
 * - data: field definition
 *
 * wikitty:
 * - admin: id, version, extension name and version, ...
 * - data: field value
 *
 *
 * How to create this definition:
 * <li> download and uncompress hbase distribution (from apache repository mirror)</li>
 * <li> $hbase-0.19.3/bin/start-hbase.sh</li>
 * <li> $hbase-0.19.3/bin/hbase shell</li>
 * <li> in the shell
 *   <li> create 'extension','admin','data'</li>
 *   <li> create 'wikitty', 'admin', 'data'</li>
 * </li>
 *
 *
 * @author poussin
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class WikittyServiceHBase extends AbstractWikittyService {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceHBase.class);

    protected WikittySearchEngin searchEngin;
    protected WikittyExtensionStorage extensionStorage;
    protected WikittyStorage wikittyStorage;

    public WikittyServiceHBase() {
        extensionStorage = new WikittyExtensionStorageHBase();
        wikittyStorage = new WikittyStorageHBase(extensionStorage);
        searchEngin = new WikittySearchEnginSolr(extensionStorage);
    }

    @Override
    protected WikittySearchEngin getSearchEngin() {
        return searchEngin;
    }

    @Override
    protected WikittyExtensionStorage getExtensionStorage() {
        return extensionStorage;
    }

    @Override
    protected WikittyStorage getWikittyStorage() {
        return wikittyStorage;
    }
}
