/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.storage.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v123.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v123.storage.model.InterestGroupAd;
import org.openqa.selenium.json.JsonInput;

public class InterestGroupDetails {
    private final String ownerOrigin;
    private final String name;
    private final TimeSinceEpoch expirationTime;
    private final String joiningOrigin;
    private final Optional<String> biddingLogicURL;
    private final Optional<String> biddingWasmHelperURL;
    private final Optional<String> updateURL;
    private final Optional<String> trustedBiddingSignalsURL;
    private final List<String> trustedBiddingSignalsKeys;
    private final Optional<String> userBiddingSignals;
    private final List<InterestGroupAd> ads;
    private final List<InterestGroupAd> adComponents;

    public InterestGroupDetails(String ownerOrigin, String name, TimeSinceEpoch expirationTime, String joiningOrigin, Optional<String> biddingLogicURL, Optional<String> biddingWasmHelperURL, Optional<String> updateURL, Optional<String> trustedBiddingSignalsURL, List<String> trustedBiddingSignalsKeys, Optional<String> userBiddingSignals, List<InterestGroupAd> ads, List<InterestGroupAd> adComponents) {
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime is required");
        this.joiningOrigin = Objects.requireNonNull(joiningOrigin, "joiningOrigin is required");
        this.biddingLogicURL = biddingLogicURL;
        this.biddingWasmHelperURL = biddingWasmHelperURL;
        this.updateURL = updateURL;
        this.trustedBiddingSignalsURL = trustedBiddingSignalsURL;
        this.trustedBiddingSignalsKeys = Objects.requireNonNull(trustedBiddingSignalsKeys, "trustedBiddingSignalsKeys is required");
        this.userBiddingSignals = userBiddingSignals;
        this.ads = Objects.requireNonNull(ads, "ads is required");
        this.adComponents = Objects.requireNonNull(adComponents, "adComponents is required");
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    public String getName() {
        return this.name;
    }

    public TimeSinceEpoch getExpirationTime() {
        return this.expirationTime;
    }

    public String getJoiningOrigin() {
        return this.joiningOrigin;
    }

    public Optional<String> getBiddingLogicURL() {
        return this.biddingLogicURL;
    }

    public Optional<String> getBiddingWasmHelperURL() {
        return this.biddingWasmHelperURL;
    }

    public Optional<String> getUpdateURL() {
        return this.updateURL;
    }

    public Optional<String> getTrustedBiddingSignalsURL() {
        return this.trustedBiddingSignalsURL;
    }

    public List<String> getTrustedBiddingSignalsKeys() {
        return this.trustedBiddingSignalsKeys;
    }

    public Optional<String> getUserBiddingSignals() {
        return this.userBiddingSignals;
    }

    public List<InterestGroupAd> getAds() {
        return this.ads;
    }

    public List<InterestGroupAd> getAdComponents() {
        return this.adComponents;
    }

    private static InterestGroupDetails fromJson(JsonInput input) {
        String ownerOrigin = null;
        String name = null;
        TimeSinceEpoch expirationTime = null;
        String joiningOrigin = null;
        Optional<String> biddingLogicURL = Optional.empty();
        Optional<String> biddingWasmHelperURL = Optional.empty();
        Optional<String> updateURL = Optional.empty();
        Optional<String> trustedBiddingSignalsURL = Optional.empty();
        List trustedBiddingSignalsKeys = null;
        Optional<String> userBiddingSignals = Optional.empty();
        List ads = null;
        List adComponents = null;
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block28;
                }
                case "name": {
                    name = input.nextString();
                    continue block28;
                }
                case "expirationTime": {
                    expirationTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block28;
                }
                case "joiningOrigin": {
                    joiningOrigin = input.nextString();
                    continue block28;
                }
                case "biddingLogicURL": {
                    biddingLogicURL = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "biddingWasmHelperURL": {
                    biddingWasmHelperURL = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "updateURL": {
                    updateURL = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "trustedBiddingSignalsURL": {
                    trustedBiddingSignalsURL = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "trustedBiddingSignalsKeys": {
                    trustedBiddingSignalsKeys = input.readArray(String.class);
                    continue block28;
                }
                case "userBiddingSignals": {
                    userBiddingSignals = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "ads": {
                    ads = input.readArray(InterestGroupAd.class);
                    continue block28;
                }
                case "adComponents": {
                    adComponents = input.readArray(InterestGroupAd.class);
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InterestGroupDetails(ownerOrigin, name, expirationTime, joiningOrigin, biddingLogicURL, biddingWasmHelperURL, updateURL, trustedBiddingSignalsURL, trustedBiddingSignalsKeys, userBiddingSignals, ads, adComponents);
    }
}

