/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v121.network.model.Headers;
import org.openqa.selenium.json.JsonInput;

public class WebSocketResponse {
    private final Integer status;
    private final String statusText;
    private final Headers headers;
    private final Optional<String> headersText;
    private final Optional<Headers> requestHeaders;
    private final Optional<String> requestHeadersText;

    public WebSocketResponse(Integer status, String statusText, Headers headers, Optional<String> headersText, Optional<Headers> requestHeaders, Optional<String> requestHeadersText) {
        this.status = Objects.requireNonNull(status, "status is required");
        this.statusText = Objects.requireNonNull(statusText, "statusText is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    public Optional<Headers> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Optional<String> getRequestHeadersText() {
        return this.requestHeadersText;
    }

    private static WebSocketResponse fromJson(JsonInput input) {
        Integer status = 0;
        String statusText = null;
        Headers headers = null;
        Optional<String> headersText = Optional.empty();
        Optional<Headers> requestHeaders = Optional.empty();
        Optional<String> requestHeadersText = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block16;
                }
                case "statusText": {
                    statusText = input.nextString();
                    continue block16;
                }
                case "headers": {
                    headers = (Headers)input.read(Headers.class);
                    continue block16;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "requestHeaders": {
                    requestHeaders = Optional.ofNullable((Headers)input.read(Headers.class));
                    continue block16;
                }
                case "requestHeadersText": {
                    requestHeadersText = Optional.ofNullable(input.nextString());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketResponse(status, statusText, headers, headersText, requestHeaders, requestHeadersText);
    }
}

