/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.event.DnDEvent;
import org.richfaces.renderkit.DnDValidator;

final class DnDEventsExchangeMailer {
    private Map<String, EventInfoStructure> queuedMap = new HashMap<String, EventInfoStructure>();
    private Map<String, UIComponent> components = new HashMap<String, UIComponent>();

    private DnDEventsExchangeMailer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DnDEventsExchangeMailer getInstance(FacesContext facesContext) {
        FacesContext facesContext2 = facesContext;
        synchronized (facesContext2) {
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            String attrName = DnDEventsExchangeMailer.class.getName();
            DnDEventsExchangeMailer instance = (DnDEventsExchangeMailer)requestMap.get(attrName);
            if (instance == null) {
                instance = new DnDEventsExchangeMailer();
                requestMap.put(attrName, instance);
            }
            return instance;
        }
    }

    private void processEvent(UIComponent source, FacesContext facesContext, DnDEvent dndEvent, EventCallback callback, Object type, Object value) {
        if (callback != null) {
            callback.processEvent(dndEvent, source, facesContext, type, value);
        }
    }

    public void mailEvent(String sourceId, UIComponent target, FacesContext facesContext, DnDEvent dndEvent, EventCallback callback, Object type, Object value, boolean isDraggable) {
        UIComponent component = this.components.get(sourceId);
        String targetId = target.getClientId(facesContext);
        if (component == null) {
            if (this.queuedMap.containsKey(sourceId)) {
                throw new IllegalStateException("Drag source with id '" + sourceId + "' already specified.");
            }
            this.queuedMap.put(sourceId, new EventInfoStructure(dndEvent, callback, type, value));
            this.components.put(targetId, target);
        } else {
            EventInfoStructure eventInfo = this.queuedMap.get(targetId);
            if (eventInfo != null) {
                Object dragType;
                Object acceptedTypes;
                Dropzone dropzone;
                Draggable draggable;
                EventInfoStructure dropEventInfo;
                final EventInfoStructure dragEventInfo = isDraggable ? eventInfo : new EventInfoStructure(dndEvent, callback, type, value);
                EventInfoStructure eventInfoStructure = dropEventInfo = isDraggable ? new EventInfoStructure(dndEvent, callback, type, value) : eventInfo;
                if (isDraggable) {
                    draggable = (Draggable)target;
                    dropzone = (Dropzone)component;
                    acceptedTypes = eventInfo.type;
                    dragType = type;
                } else {
                    draggable = (Draggable)component;
                    dropzone = (Dropzone)target;
                    acceptedTypes = type;
                    dragType = eventInfo.type;
                }
                if (DnDValidator.validateAcceptTypes(facesContext, draggable, dropzone, dragType, acceptedTypes)) {
                    facesContext.getViewRoot().invokeOnComponent(facesContext, isDraggable ? targetId : sourceId, new ContextCallback(){

                        public void invokeContextCallback(FacesContext fc, UIComponent targetComponent) {
                            DnDEventsExchangeMailer.this.processEvent(targetComponent, fc, dragEventInfo.dndEvent, dragEventInfo.eventCallback, dropEventInfo.type, dropEventInfo.value);
                            dropEventInfo.dndEvent.queue();
                        }
                    });
                    facesContext.getViewRoot().invokeOnComponent(facesContext, isDraggable ? sourceId : targetId, new ContextCallback(){

                        public void invokeContextCallback(FacesContext fc, UIComponent targetComponent) {
                            DnDEventsExchangeMailer.this.processEvent(targetComponent, fc, dropEventInfo.dndEvent, dropEventInfo.eventCallback, dragEventInfo.type, dragEventInfo.value);
                            dragEventInfo.dndEvent.queue();
                        }
                    });
                }
                this.queuedMap.remove(targetId);
            }
        }
    }

    static abstract class EventCallback {
        EventCallback() {
        }

        abstract void processEvent(DnDEvent var1, UIComponent var2, FacesContext var3, Object var4, Object var5);
    }

    private static class EventInfoStructure {
        private DnDEvent dndEvent;
        private EventCallback eventCallback;
        private Object type;
        private Object value;

        public EventInfoStructure(DnDEvent dndEvent, EventCallback eventCallback, Object type, Object value) {
            this.dndEvent = dndEvent;
            this.eventCallback = eventCallback;
            this.type = type;
            this.value = value;
        }
    }
}

