/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import org.ajax4jsf.util.HtmlDimensions;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;

class ColumnsSizeState
implements Serializable {
    private static final long serialVersionUID = 8724163192351491340L;
    private static final String SEP = ";";
    private static final String DEFAULT_WIDTH = "100";
    private String value;

    private ColumnsSizeState() {
    }

    static ColumnsSizeState getColumnsSize(UIExtendedDataTable extendedDataTable, String val) {
        ColumnsSizeState columnsSize = new ColumnsSizeState();
        columnsSize.init(extendedDataTable, val);
        return columnsSize;
    }

    private void init(UIExtendedDataTable extendedDataTable, String val) {
        this.value = val;
        if (this.value == null || this.value.length() == 0) {
            this.createDefaultColumnsSizeState(extendedDataTable);
        }
    }

    public String toString() {
        return this.value;
    }

    private void createDefaultColumnsSizeState(UIExtendedDataTable extendedDataTable) {
        StringBuilder builder = new StringBuilder();
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn col = iter.next();
            builder.append(col.getId().toUpperCase()).append("-").append(this.getDefaultColumnSize((UIComponent)col)).append(SEP);
        }
        this.value = builder.toString();
    }

    private String getDefaultColumnSize(UIComponent column) {
        String widthStr = (String)column.getAttributes().get("width");
        return this.formatWidth(widthStr == null || widthStr.length() == 0 ? DEFAULT_WIDTH : widthStr);
    }

    public String getColumnSize(UIComponent column) {
        if (this.value == null) {
            return this.getDefaultColumnSize(column);
        }
        String[] widths = this.value.split(SEP);
        if (widths != null) {
            String colId = column.getId().toUpperCase();
            for (String val : widths) {
                if (!val.toUpperCase().startsWith(colId + "-")) continue;
                return this.formatWidth(val.split("-")[1]);
            }
        }
        return this.getDefaultColumnSize(column);
    }

    private String formatWidth(String value) {
        return String.valueOf(HtmlDimensions.decode((String)value).intValue());
    }

    public void changeColumnSize(UIExtendedDataTable extendedDataTable, String newValue) {
        if (this.value == null) {
            return;
        }
        HashSet<String> widths = new HashSet<String>(Arrays.asList(this.value.toUpperCase().split(SEP)));
        String[] newWidths = newValue.split(SEP);
        int index = 0;
        Iterator<UIColumn> iter = extendedDataTable.getSortedColumns();
        while (iter.hasNext()) {
            UIComponent col = (UIComponent)iter.next();
            if (!col.isRendered()) continue;
            String colId = col.getId().toUpperCase();
            HashSet<String> toDel = new HashSet<String>();
            for (String val : widths) {
                if (!val.toUpperCase().startsWith(colId + "-")) continue;
                toDel.add(val);
            }
            widths.removeAll(toDel);
            String newWidth = newWidths[index++];
            String item = colId + "-" + newWidth;
            widths.add(item);
        }
        StringBuilder builder = new StringBuilder();
        for (String val : widths) {
            builder.append(val).append(SEP);
        }
        this.value = builder.toString();
    }
}

