/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnsOrder
implements Serializable {
    private static final long serialVersionUID = 907700564445889954L;
    private static final String SEP = ";";
    private String value;

    private ColumnsOrder() {
    }

    static ColumnsOrder getColumnsOrder(UIExtendedDataTable extendedDataTable, String val) {
        ColumnsOrder columnsOrder = new ColumnsOrder();
        columnsOrder.init(extendedDataTable, val);
        return columnsOrder;
    }

    private void init(UIExtendedDataTable extendedDataTable, String val) {
        this.value = val;
        if (this.value == null || this.value.length() == 0) {
            this.createDefaultColumnsOrder(extendedDataTable);
        }
    }

    public String toString() {
        return this.value;
    }

    private void createDefaultColumnsOrder(UIExtendedDataTable extendedDataTable) {
        StringBuilder builder = new StringBuilder();
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn child = iter.next();
            builder.append(child.getId().toUpperCase()).append(SEP);
        }
        this.value = builder.toString();
    }

    private Integer getColumnIndex(String columnId) {
        if (this.value == null) {
            return null;
        }
        List<String> list = Arrays.asList(this.value.toUpperCase().split(SEP));
        if (list.contains(columnId.toUpperCase())) {
            return list.indexOf(columnId.toUpperCase());
        }
        return null;
    }

    void changeOrder(String sourceColumnId, String targetColumnId, boolean dropBefore) {
        int targetIndex;
        if (this.value == null) {
            return;
        }
        if (sourceColumnId.equals(targetColumnId)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.value.toUpperCase().split(SEP)));
        int sourceIndex = list.indexOf(sourceColumnId.toUpperCase());
        if (sourceIndex != -1) {
            list.remove(sourceIndex);
        }
        if ((targetIndex = list.indexOf(targetColumnId.toUpperCase())) == -1) {
            list.add(sourceColumnId.toUpperCase());
        } else {
            list.add(targetIndex + (dropBefore ? 0 : 1), sourceColumnId.toUpperCase());
        }
        StringBuilder builder = new StringBuilder();
        for (String str : list) {
            builder.append(str).append(SEP);
        }
        this.value = builder.toString();
    }

    List<UIComponent> sortColumns(FacesContext context, List<UIComponent> children) {
        ArrayList<UIComponent> childs = new ArrayList<UIComponent>(children);
        Collections.sort(childs, new Comparator<UIComponent>(){

            @Override
            public int compare(UIComponent o1, UIComponent o2) {
                Integer index1 = ColumnsOrder.this.getColumnIndex(o1.getId());
                Integer index2 = ColumnsOrder.this.getColumnIndex(o2.getId());
                if (index1 == null) {
                    return index2 == null ? 0 : 1;
                }
                return index2 == null ? -1 : index1.compareTo(index2);
            }
        });
        return childs;
    }
}

