/**
 * 
 */
package org.ajax4jsf.config;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/**
 * @author asmirnov
 * 
 */
class StringContentHandler extends StateHandler {

	private StringBuilder result;
	
	private final XMLReader reader;

	public StringContentHandler(XMLReader reader, ContentHandler parentHandler,
			StringBuilder result) {
		super(parentHandler);
		this.reader = reader;
		this.result = result;
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		result.append(ch, start, length);
	}

	protected StringBuilder getResult() {
		return result;
	}
	
	@Override
	protected XMLReader getReader() {
		return reader;
	}
}
