/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.util.dom;

import java.util.Map;
import org.apache.cocoon.pipeline.component.sax.SAXConsumer;
import org.apache.cocoon.pipeline.util.dom.ElementInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class DOMStreamer {
    private ElementInfo currentElementInfo;
    private int newPrefixCounter;
    private SAXConsumer xmlConsumer;

    public DOMStreamer(SAXConsumer xmlConsumer) {
        this.xmlConsumer = xmlConsumer;
    }

    public void stream(Node node) throws SAXException {
        boolean isDoc;
        boolean bl = isDoc = node.getNodeType() == 9;
        if (isDoc) {
            this.xmlConsumer.startDocument();
        }
        Node top = node;
        while (null != node) {
            this.startNode(node);
            Node nextNode = node.getFirstChild();
            while (null == nextNode) {
                this.endNode(node);
                if (top.equals(node)) break;
                nextNode = node.getNextSibling();
                if (null != nextNode || null != (node = node.getParentNode()) && !top.equals(node)) continue;
                if (null != node) {
                    this.endNode(node);
                }
                nextNode = null;
                break;
            }
            node = nextNode;
        }
        if (isDoc) {
            this.xmlConsumer.endDocument();
        }
    }

    private void startNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 8: {
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                String uri;
                NamedNodeMap atts = node.getAttributes();
                int nAttrs = atts.getLength();
                this.currentElementInfo = new ElementInfo(this.currentElementInfo);
                for (int i = 0; i < nAttrs; ++i) {
                    Node attr = atts.item(i);
                    String attrName = attr.getNodeName();
                    if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:")) continue;
                    int index = attrName.indexOf(":");
                    String prefix = index < 0 ? "" : attrName.substring(index + 1);
                    this.currentElementInfo.put(prefix, attr.getNodeValue());
                }
                String namespaceURI = node.getNamespaceURI();
                String prefix = node.getPrefix();
                String localName = node.getLocalName();
                if (localName == null) {
                    String[] prefixAndLocalName = this.getPrefixAndLocalName(node.getNodeName());
                    prefix = prefixAndLocalName[0];
                    localName = prefixAndLocalName[1];
                    namespaceURI = this.getNamespaceForPrefix(prefix, (Element)node);
                }
                if (namespaceURI != null) {
                    if (prefix == null) {
                        prefix = "";
                    }
                    if ((uri = this.currentElementInfo.findNamespaceURI(prefix)) == null || !uri.equals(namespaceURI)) {
                        if (uri != null) {
                            this.currentElementInfo.put(prefix, namespaceURI);
                        } else {
                            this.currentElementInfo.put(prefix, namespaceURI);
                        }
                    }
                } else {
                    uri = this.currentElementInfo.findNamespaceURI("");
                    if (uri != null && uri.length() > 0) {
                        this.currentElementInfo.put("", "");
                    }
                }
                if (namespaceURI == null) {
                    namespaceURI = "";
                }
                String qName = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
                AttributesImpl newAttrs = new AttributesImpl();
                for (int i = 0; i < nAttrs; ++i) {
                    String attrNsURI;
                    String attrLocalName;
                    String attrPrefix;
                    Node attr = atts.item(i);
                    String attrName = attr.getNodeName();
                    String assignedAttrPrefix = null;
                    if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) continue;
                    if (attr.getLocalName() == null) {
                        String[] prefixAndLocalName = this.getPrefixAndLocalName(attrName);
                        assignedAttrPrefix = attrPrefix = prefixAndLocalName[0];
                        attrLocalName = prefixAndLocalName[1];
                        attrNsURI = attrPrefix != null ? this.getNamespaceForPrefix(attrPrefix, (Element)node) : null;
                    } else {
                        attrLocalName = attr.getLocalName();
                        attrPrefix = attr.getPrefix();
                        attrNsURI = attr.getNamespaceURI();
                    }
                    if (attrNsURI != null) {
                        String declaredUri = this.currentElementInfo.findNamespaceURI(attrPrefix);
                        if (declaredUri == null || !declaredUri.equals(attrNsURI)) {
                            String availablePrefix = this.currentElementInfo.findPrefix(attrNsURI);
                            if (availablePrefix != null && !availablePrefix.equals("")) {
                                assignedAttrPrefix = availablePrefix;
                            } else if (attrPrefix != null && declaredUri == null) {
                                assignedAttrPrefix = attrPrefix;
                                this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                            } else {
                                ++this.newPrefixCounter;
                                assignedAttrPrefix = "NS" + this.newPrefixCounter;
                                this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                            }
                        } else {
                            assignedAttrPrefix = attrPrefix;
                        }
                    }
                    String assignedAttrNsURI = attrNsURI != null ? attrNsURI : "";
                    String attrQName = assignedAttrPrefix != null ? assignedAttrPrefix + ":" + attrLocalName : attrLocalName;
                    newAttrs.addAttribute(assignedAttrNsURI, attrLocalName, attrQName, "CDATA", attr.getNodeValue());
                }
                if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                    for (Map.Entry<String, String> entry : this.currentElementInfo.namespaceDeclarations.entrySet()) {
                        String pr = entry.getKey();
                        String ns = entry.getValue();
                        this.xmlConsumer.startPrefixMapping(pr, ns);
                    }
                }
                this.xmlConsumer.startElement(namespaceURI, localName, qName, newAttrs);
                this.currentElementInfo.localName = localName;
                this.currentElementInfo.namespaceURI = namespaceURI;
                this.currentElementInfo.qName = qName;
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                this.xmlConsumer.processingInstruction(pi.getNodeName(), pi.getData());
                break;
            }
            case 4: {
                if (this.xmlConsumer != null) {
                    this.xmlConsumer.startCDATA();
                }
                this.dispatchChars(node);
                if (this.xmlConsumer == null) break;
                this.xmlConsumer.endCDATA();
                break;
            }
            case 3: {
                this.dispatchChars(node);
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (this.xmlConsumer == null) break;
                this.xmlConsumer.startEntity(eref.getNodeName());
                break;
            }
        }
    }

    private void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                this.xmlConsumer.endElement(this.currentElementInfo.namespaceURI, this.currentElementInfo.localName, this.currentElementInfo.qName);
                if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                    for (Map.Entry<String, String> entry : this.currentElementInfo.namespaceDeclarations.entrySet()) {
                        this.xmlConsumer.endPrefixMapping(entry.getKey());
                    }
                }
                this.currentElementInfo = this.currentElementInfo.parent;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (this.xmlConsumer == null) break;
                this.xmlConsumer.endEntity(eref.getNodeName());
                break;
            }
        }
    }

    private void dispatchChars(Node node) throws SAXException {
        String data = ((Text)node).getData();
        if (data != null) {
            this.xmlConsumer.characters(data.toCharArray(), 0, data.length());
        }
    }

    private String getNamespaceForPrefix(String prefix, Element namespaceContext) {
        if (prefix == null) {
            prefix = "";
        }
        String namespace = null;
        if (prefix.equals("xml")) {
            namespace = "http://www.w3.org/XML/1998/namespace";
        } else if (prefix.equals("xmlns")) {
            namespace = "http://www.w3.org/2000/xmlns/";
        } else {
            String declname = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
            Node parent = namespaceContext;
            int type = -1;
            if (parent != null) {
                type = parent.getNodeType();
            }
            while (parent != null && namespace == null && (type == 1 || type == 5)) {
                Attr attr;
                if (type == 1 && (attr = parent.getAttributeNode(declname)) != null) {
                    namespace = attr.getNodeValue();
                    break;
                }
                if ((parent = parent.getParentNode()) == null) continue;
                type = parent.getNodeType();
            }
        }
        return namespace;
    }

    private String[] getPrefixAndLocalName(String nodeName) {
        String localName;
        String prefix;
        int colonPos = nodeName.indexOf(":");
        if (colonPos != -1) {
            prefix = nodeName.substring(0, colonPos);
            localName = nodeName.substring(colonPos + 1, nodeName.length());
        } else {
            prefix = null;
            localName = nodeName;
        }
        return new String[]{prefix, localName};
    }
}

