/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class BondTools {
    public static boolean isValidDoubleBondConfiguration(IAtomContainer container, IBond bond) {
        List connectedAtoms = container.getConnectedAtomsList(bond.getBegin());
        IAtom from = null;
        for (IAtom connectedAtom : connectedAtoms) {
            if (connectedAtom.equals(bond.getEnd())) continue;
            from = connectedAtom;
        }
        boolean[] array = new boolean[container.getBondCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = true;
        }
        return BondTools.isStartOfDoubleBond(container, bond.getBegin(), from, array) && BondTools.isEndOfDoubleBond(container, bond.getEnd(), bond.getBegin(), array) && !bond.getFlag(32);
    }

    public static boolean isCisTrans(IAtom firstOuterAtom, IAtom firstInnerAtom, IAtom secondInnerAtom, IAtom secondOuterAtom, IAtomContainer ac) throws CDKException {
        boolean secondDirection;
        if (!BondTools.isValidDoubleBondConfiguration(ac, ac.getBond(firstInnerAtom, secondInnerAtom))) {
            throw new CDKException("There is no valid double bond configuration between your inner atoms!");
        }
        boolean firstDirection = BondTools.isLeft(firstOuterAtom, firstInnerAtom, secondInnerAtom);
        return firstDirection == (secondDirection = BondTools.isLeft(secondOuterAtom, secondInnerAtom, firstInnerAtom));
    }

    public static boolean isLeft(IAtom whereIs, IAtom viewFrom, IAtom viewTo) {
        double angle = BondTools.giveAngleBothMethods(viewFrom, viewTo, whereIs, false);
        return !(angle < 0.0);
    }

    public static boolean closeEnoughToBond(IAtom atom1, IAtom atom2, double distanceFudgeFactor) {
        double bondingDistance;
        double distanceBetweenAtoms;
        return !atom1.equals(atom2) && (distanceBetweenAtoms = atom1.getPoint3d().distance(atom2.getPoint3d())) <= distanceFudgeFactor * (bondingDistance = atom1.getCovalentRadius() + atom2.getCovalentRadius());
    }

    public static double giveAngleBothMethods(IAtom from, IAtom to1, IAtom to2, boolean bool) {
        return BondTools.giveAngleBothMethods(from.getPoint2d(), to1.getPoint2d(), to2.getPoint2d(), bool);
    }

    public static double giveAngleBothMethods(Point2d from, Point2d to1, Point2d to2, boolean bool) {
        double[] A = new double[2];
        from.get(A);
        double[] B = new double[2];
        to1.get(B);
        double[] C = new double[2];
        to2.get(C);
        double angle1 = Math.atan2(B[1] - A[1], B[0] - A[0]);
        double angle2 = Math.atan2(C[1] - A[1], C[0] - A[0]);
        double angle = angle2 - angle1;
        if (angle2 < 0.0 && angle1 > 0.0 && angle2 < -1.5707963267948966) {
            angle = Math.PI + angle2 + Math.PI - angle1;
        }
        if (angle2 > 0.0 && angle1 < 0.0 && angle1 < -1.5707963267948966) {
            angle = -Math.PI + angle2 - Math.PI - angle1;
        }
        if (bool && angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }

    private static boolean isEndOfDoubleBond(IAtomContainer container, IAtom atom, IAtom parent, boolean[] doubleBondConfiguration) {
        if (container.indexOf(container.getBond(atom, parent)) == -1 || doubleBondConfiguration.length <= container.indexOf(container.getBond(atom, parent)) || !doubleBondConfiguration[container.indexOf(container.getBond(atom, parent))]) {
            return false;
        }
        int hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        int lengthAtom = container.getConnectedAtomsList(atom).size() + hcount;
        hcount = parent.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : parent.getImplicitHydrogenCount();
        int lengthParent = container.getConnectedAtomsList(parent).size() + hcount;
        if (container.getBond(atom, parent) != null && container.getBond(atom, parent).getOrder() == IBond.Order.DOUBLE && (lengthAtom == 3 || lengthAtom == 2 && atom.getSymbol().equals("N")) && (lengthParent == 3 || lengthParent == 2 && parent.getSymbol().equals("N"))) {
            List atoms = container.getConnectedAtomsList(atom);
            IAtom one = null;
            IAtom two = null;
            for (IAtom conAtom : atoms) {
                if (!conAtom.equals(parent) && one == null) {
                    one = conAtom;
                    continue;
                }
                if (conAtom.equals(parent) || one == null) continue;
                two = conAtom;
            }
            String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol(container);
            return one != null && two == null && atom.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(parent, atom, one, true)) > 0.3141592653589793 || !atom.getSymbol().equals("N") && one != null && two != null && !morgannumbers[container.indexOf(one)].equals(morgannumbers[container.indexOf(two)]);
        }
        return false;
    }

    private static boolean isStartOfDoubleBond(IAtomContainer container, IAtom a, IAtom parent, boolean[] doubleBondConfiguration) {
        int hcount = a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount();
        int lengthAtom = container.getConnectedAtomsList(a).size() + hcount;
        if (lengthAtom != 3 && lengthAtom != 2 && !a.getSymbol().equals("N")) {
            return false;
        }
        List atoms = container.getConnectedAtomsList(a);
        IAtom one = null;
        IAtom two = null;
        boolean doubleBond = false;
        IAtom nextAtom = null;
        for (IAtom atom : atoms) {
            if (!atom.equals(parent) && container.getBond(atom, a).getOrder() == IBond.Order.DOUBLE && BondTools.isEndOfDoubleBond(container, atom, a, doubleBondConfiguration)) {
                doubleBond = true;
                nextAtom = atom;
            }
            if (!atom.equals(nextAtom) && one == null) {
                one = atom;
                continue;
            }
            if (atom.equals(nextAtom) || one == null) continue;
            two = atom;
        }
        String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol(container);
        return one != null && (!a.getSymbol().equals("N") && two != null && !morgannumbers[container.indexOf(one)].equals(morgannumbers[container.indexOf(two)]) && doubleBond && doubleBondConfiguration[container.indexOf(container.getBond(a, nextAtom))] || doubleBond && a.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(nextAtom, a, parent, true)) > 0.3141592653589793);
    }

    public static int isTetrahedral(IAtomContainer container, IAtom atom, boolean strict) {
        List atoms = container.getConnectedAtomsList(atom);
        if (atoms.size() != 4) {
            return 0;
        }
        List bonds = container.getConnectedBondsList(atom);
        int up = 0;
        int down = 0;
        for (IBond bond : bonds) {
            if (bond.getStereo() == IBond.Stereo.NONE || bond.getStereo() == CDKConstants.UNSET) continue;
            if (bond.getStereo() == IBond.Stereo.UP) {
                ++up;
                continue;
            }
            if (bond.getStereo() != IBond.Stereo.DOWN) continue;
            ++down;
        }
        if (up == 1 && down == 1) {
            return 1;
        }
        if (up == 2 && down == 2) {
            if (BondTools.stereosAreOpposite(container, atom)) {
                return 2;
            }
            return 0;
        }
        if (up == 1 && down == 0 && !strict) {
            return 3;
        }
        if (down == 1 && up == 0 && !strict) {
            return 4;
        }
        if (down == 2 && up == 1 && !strict) {
            return 5;
        }
        if (down == 1 && up == 2 && !strict) {
            return 6;
        }
        return 0;
    }

    public static int isTrigonalBipyramidalOrOctahedral(IAtomContainer container, IAtom atom) {
        List atoms = container.getConnectedAtomsList(atom);
        if (atoms.size() < 5 || atoms.size() > 6) {
            return 0;
        }
        List bonds = container.getConnectedBondsList(atom);
        int up = 0;
        int down = 0;
        for (IBond bond : bonds) {
            if (bond.getStereo() == CDKConstants.UNSET || bond.getStereo() == IBond.Stereo.NONE) continue;
            if (bond.getStereo() == IBond.Stereo.UP) {
                ++up;
                continue;
            }
            if (bond.getStereo() != IBond.Stereo.DOWN) continue;
            ++down;
        }
        if (up == 1 && down == 1) {
            if (atoms.size() == 5) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static boolean isStereo(IAtomContainer container, IAtom stereoAtom) {
        List atoms = container.getConnectedAtomsList(stereoAtom);
        if (atoms.size() < 4 || atoms.size() > 6) {
            return false;
        }
        List bonds = container.getConnectedBondsList(stereoAtom);
        int stereo = 0;
        for (IBond bond : bonds) {
            if (bond.getStereo() == CDKConstants.UNSET || bond.getStereo() == IBond.Stereo.NONE) continue;
            ++stereo;
        }
        if (stereo == 0) {
            return false;
        }
        int differentAtoms = 0;
        for (int i = 0; i < atoms.size(); ++i) {
            boolean isDifferent = true;
            for (int k = 0; k < i; ++k) {
                if (!((IAtom)atoms.get(i)).getSymbol().equals(((IAtom)atoms.get(k)).getSymbol())) continue;
                isDifferent = false;
                break;
            }
            if (!isDifferent) continue;
            ++differentAtoms;
        }
        if (differentAtoms != atoms.size()) {
            long[] morgannumbers = MorganNumbersTools.getMorganNumbers(container);
            ArrayList<String> differentSymbols = new ArrayList<String>();
            for (Object atom : atoms) {
                if (differentSymbols.contains(atom.getSymbol())) continue;
                differentSymbols.add(atom.getSymbol());
            }
            int[] onlyRelevantIfTwo = new int[2];
            if (differentSymbols.size() == 2) {
                for (IAtom atom : atoms) {
                    if (differentSymbols.indexOf(atom.getSymbol()) == 0) {
                        onlyRelevantIfTwo[0] = onlyRelevantIfTwo[0] + 1;
                        continue;
                    }
                    onlyRelevantIfTwo[1] = onlyRelevantIfTwo[1] + 1;
                }
            }
            boolean[] symbolsWithDifferentMorganNumbers = new boolean[differentSymbols.size()];
            ArrayList[] symbolsMorganNumbers = new ArrayList[symbolsWithDifferentMorganNumbers.length];
            for (int i = 0; i < symbolsWithDifferentMorganNumbers.length; ++i) {
                symbolsWithDifferentMorganNumbers[i] = true;
                symbolsMorganNumbers[i] = new ArrayList();
            }
            for (IAtom atom : atoms) {
                int elementNumber = differentSymbols.indexOf(atom.getSymbol());
                if (symbolsMorganNumbers[elementNumber].contains(morgannumbers[container.indexOf(atom)])) {
                    symbolsWithDifferentMorganNumbers[elementNumber] = false;
                    continue;
                }
                symbolsMorganNumbers[elementNumber].add(morgannumbers[container.indexOf(atom)]);
            }
            int numberOfSymbolsWithDifferentMorganNumbers = 0;
            for (boolean symbolWithDifferentMorganNumber : symbolsWithDifferentMorganNumbers) {
                if (!symbolWithDifferentMorganNumber) continue;
                ++numberOfSymbolsWithDifferentMorganNumbers;
            }
            if (numberOfSymbolsWithDifferentMorganNumbers != differentSymbols.size()) {
                if ((atoms.size() == 5 || atoms.size() == 6) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1)) {
                    return true;
                }
                return BondTools.isSquarePlanar(container, stereoAtom) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1);
            }
        }
        return true;
    }

    public static boolean isSquarePlanar(IAtomContainer container, IAtom atom) {
        List atoms = container.getConnectedAtomsList(atom);
        if (atoms.size() != 4) {
            return false;
        }
        List bonds = container.getConnectedBondsList(atom);
        int up = 0;
        int down = 0;
        for (IBond bond : bonds) {
            if (bond.getStereo() == CDKConstants.UNSET || bond.getStereo() == IBond.Stereo.NONE) continue;
            if (bond.getStereo() == IBond.Stereo.UP) {
                ++up;
                continue;
            }
            if (bond.getStereo() != IBond.Stereo.DOWN) continue;
            ++down;
        }
        return up == 2 && down == 2 && !BondTools.stereosAreOpposite(container, atom);
    }

    public static boolean stereosAreOpposite(IAtomContainer container, IAtom atom) {
        List atoms = container.getConnectedAtomsList(atom);
        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
        for (int i = 1; i < atoms.size(); ++i) {
            hm.put(BondTools.giveAngle(atom, (IAtom)atoms.get(0), (IAtom)atoms.get(i)), i);
        }
        Object[] ohere = hm.values().toArray();
        IBond.Stereo stereoOne = container.getBond(atom, (IAtom)atoms.get(0)).getStereo();
        IBond.Stereo stereoOpposite = container.getBond(atom, (IAtom)atoms.get((Integer)ohere[1])).getStereo();
        return stereoOpposite == stereoOne;
    }

    public static double giveAngle(IAtom from, IAtom to1, IAtom to2) {
        return BondTools.giveAngleBothMethods(from, to1, to2, true);
    }

    public static double giveAngleFromMiddle(IAtom from, IAtom to1, IAtom to2) {
        return BondTools.giveAngleBothMethods(from, to1, to2, false);
    }

    public static void makeUpDownBonds(IAtomContainer container) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom a = container.getAtom(i);
            if (container.getConnectedAtomsList(a).size() != 4) continue;
            int up = 0;
            int down = 0;
            int hs = 0;
            IAtom h = null;
            for (int k = 0; k < 4; ++k) {
                IAtom conAtom = (IAtom)container.getConnectedAtomsList(a).get(k);
                IBond.Stereo stereo = container.getBond(a, conAtom).getStereo();
                if (stereo == IBond.Stereo.UP) {
                    ++up;
                    continue;
                }
                if (stereo == IBond.Stereo.DOWN) {
                    ++down;
                    continue;
                }
                if (stereo == IBond.Stereo.NONE && conAtom.getSymbol().equals("H")) {
                    h = conAtom;
                    ++hs;
                    continue;
                }
                h = null;
            }
            if (up == 0 && down == 1 && h != null && hs == 1) {
                container.getBond(a, h).setStereo(IBond.Stereo.UP);
            }
            if (up != true || down != 0 || h == null || hs != true) continue;
            container.getBond(a, h).setStereo(IBond.Stereo.DOWN);
        }
    }
}

