/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.inchi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class INChIContentProcessorTool {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(INChIContentProcessorTool.class);

    public IAtomContainer processFormula(IAtomContainer parsedContent, String atomsEncoding) {
        logger.debug((Object)"Parsing atom data: ", new Object[]{atomsEncoding});
        Pattern pattern = Pattern.compile("([A-Z][a-z]?)(\\d+)?(.*)");
        String remainder = atomsEncoding;
        while (remainder.length() > 0) {
            logger.debug((Object)"Remaining: ", new Object[]{remainder});
            Matcher matcher = pattern.matcher(remainder);
            if (matcher.matches()) {
                String symbol = matcher.group(1);
                logger.debug((Object)"Atom symbol: ", new Object[]{symbol});
                if (!symbol.equals("H")) {
                    String occurenceStr = matcher.group(2);
                    int occurence = 1;
                    if (occurenceStr != null) {
                        occurence = Integer.parseInt(occurenceStr);
                    }
                    logger.debug((Object)"  occurence: ", new Object[]{occurence});
                    for (int i = 1; i <= occurence; ++i) {
                        parsedContent.addAtom((IAtom)parsedContent.getBuilder().newInstance(IAtom.class, new Object[]{symbol}));
                    }
                }
                remainder = matcher.group(3);
                if (remainder == null) {
                    remainder = "";
                }
                logger.debug((Object)"  Remaining: ", new Object[]{remainder});
            } else {
                logger.error((Object)"No match found!");
                remainder = "";
            }
            logger.debug((Object)"NO atoms: ", new Object[]{parsedContent.getAtomCount()});
        }
        return parsedContent;
    }

    public void processConnections(String bondsEncoding, IAtomContainer container, int source) {
        logger.debug((Object)"Parsing bond data: ", new Object[]{bondsEncoding});
        IBond bondToAdd = null;
        String remainder = bondsEncoding;
        while (remainder.length() > 0) {
            logger.debug((Object)"Bond part: ", new Object[]{remainder});
            if (remainder.charAt(0) == '(') {
                String branch = this.chopBranch(remainder);
                this.processConnections(branch, container, source);
                if (branch.length() + 2 <= remainder.length()) {
                    remainder = remainder.substring(branch.length() + 2);
                    continue;
                }
                remainder = "";
                continue;
            }
            Pattern pattern = Pattern.compile("^(\\d+)-?(.*)");
            Matcher matcher = pattern.matcher(remainder);
            if (matcher.matches()) {
                String targetStr = matcher.group(1);
                int target = Integer.parseInt(targetStr);
                logger.debug((Object)"Source atom: ", new Object[]{source});
                logger.debug((Object)"Target atom: ", new Object[]{targetStr});
                IAtom targetAtom = container.getAtom(target - 1);
                if (source != -1) {
                    IAtom sourceAtom = container.getAtom(source - 1);
                    bondToAdd = (IBond)container.getBuilder().newInstance(IBond.class, new Object[]{sourceAtom, targetAtom, IBond.Order.SINGLE});
                    container.addBond(bondToAdd);
                }
                remainder = matcher.group(2);
                source = target;
                logger.debug((Object)"  remainder: ", new Object[]{remainder});
                continue;
            }
            logger.error((Object)"Could not get next bond info part");
            return;
        }
    }

    private String chopBranch(String remainder) {
        boolean doChop = false;
        int branchLevel = 0;
        StringBuffer choppedString = new StringBuffer();
        for (int i = 0; i < remainder.length(); ++i) {
            char currentChar = remainder.charAt(i);
            if (currentChar == '(') {
                if (doChop) {
                    choppedString.append(currentChar);
                }
                doChop = true;
                ++branchLevel;
                continue;
            }
            if (currentChar == ')') {
                if (--branchLevel == 0) {
                    doChop = false;
                    break;
                }
                if (!doChop) continue;
                choppedString.append(currentChar);
                continue;
            }
            if (!doChop) continue;
            choppedString.append(currentChar);
        }
        return choppedString.toString();
    }
}

