/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.modeling.builder3d.AtomTetrahedralLigandPlacer3D;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class AtomPlacer3D {
    private Map<Object, List> pSet = null;
    private double[] distances;
    private int[] firstAtoms = null;
    private double[] angles = null;
    private int[] secondAtoms = null;
    private double[] dihedrals = null;
    private int[] thirdAtoms = null;
    private static final double DIHEDRAL_EXTENDED_CHAIN = Math.PI;
    private static final double DIHEDRAL_BRANCHED_CHAIN = 0.0;
    private static final double DEFAULT_BOND_LENGTH = 1.5;
    private static final double DEFAULT_SP3_ANGLE = 109.471;
    private static final double DEFAULT_SP2_ANGLE = 120.0;
    private static final double DEFAULT_SP_ANGLE = 180.0;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomPlacer3D.class);

    AtomPlacer3D() {
    }

    public void initilize(Map parameterSet) {
        this.pSet = parameterSet;
    }

    public int[] findHeavyAtomsInChain(IAtomContainer molecule, IAtomContainer chain) {
        int[] heavy = new int[]{-1, -1};
        int hc = 0;
        for (int i = 0; i < chain.getAtomCount(); ++i) {
            if (!this.isHeavyAtom(chain.getAtom(i))) continue;
            if (heavy[0] < 0) {
                heavy[0] = molecule.indexOf(chain.getAtom(i));
            }
            ++hc;
        }
        heavy[1] = hc;
        return heavy;
    }

    public IAtomContainer markPlaced(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(1, true);
        }
        return ac;
    }

    public void placeAliphaticHeavyChain(IAtomContainer molecule, IAtomContainer chain) throws CDKException {
        int[] first = new int[2];
        int counter = 1;
        int nextAtomNr = 0;
        String id1 = "";
        String id2 = "";
        String id3 = "";
        first = this.findHeavyAtomsInChain(molecule, chain);
        this.distances = new double[first[1]];
        this.firstAtoms = new int[first[1]];
        this.angles = new double[first[1]];
        this.secondAtoms = new int[first[1]];
        this.dihedrals = new double[first[1]];
        this.thirdAtoms = new int[first[1]];
        this.firstAtoms[0] = first[0];
        molecule.getAtom(this.firstAtoms[0]).setFlag(16, true);
        int hybridisation = 0;
        for (int i = 0; i < chain.getAtomCount(); ++i) {
            block15: {
                if (!this.isHeavyAtom(chain.getAtom(i)) || chain.getAtom(i).getFlag(16)) continue;
                nextAtomNr = molecule.indexOf(chain.getAtom(i));
                id2 = molecule.getAtom(this.firstAtoms[counter - 1]).getAtomTypeName();
                id1 = molecule.getAtom(nextAtomNr).getAtomTypeName();
                if (molecule.getBond(molecule.getAtom(this.firstAtoms[counter - 1]), molecule.getAtom(nextAtomNr)) == null) {
                    throw new CDKException("atoms do not form a chain, please use ModelBuilder3D");
                }
                this.distances[counter] = this.getBondLengthValue(id1, id2);
                this.firstAtoms[counter] = nextAtomNr;
                this.secondAtoms[counter] = this.firstAtoms[counter - 1];
                if (counter > 1) {
                    id3 = molecule.getAtom(this.firstAtoms[counter - 2]).getAtomTypeName();
                    hybridisation = this.getHybridisationState(molecule.getAtom(this.firstAtoms[counter - 1]));
                    this.angles[counter] = this.getAngleValue(id1, id2, id3);
                    if (this.angles[counter] == -1.0) {
                        if (hybridisation == 3) {
                            this.angles[counter] = 109.471;
                        } else if (hybridisation == 2) {
                            this.angles[counter] = 120.0;
                        } else if (hybridisation == 1) {
                            this.angles[counter] = 180.0;
                        }
                    }
                    this.thirdAtoms[counter] = this.firstAtoms[counter - 2];
                } else {
                    this.angles[counter] = -1.0;
                    this.thirdAtoms[counter] = -1;
                }
                if (counter > 2) {
                    try {
                        if (this.getDoubleBondConfiguration2D(molecule.getBond(molecule.getAtom(this.firstAtoms[counter - 1]), molecule.getAtom(this.firstAtoms[counter - 2])), molecule.getAtom(this.firstAtoms[counter]).getPoint2d(), molecule.getAtom(this.firstAtoms[counter - 1]).getPoint2d(), molecule.getAtom(this.firstAtoms[counter - 2]).getPoint2d(), molecule.getAtom(this.firstAtoms[counter - 3]).getPoint2d()) == 5) {
                            this.dihedrals[counter] = 0.0;
                            break block15;
                        }
                        this.dihedrals[counter] = Math.PI;
                    }
                    catch (CDKException ex1) {
                        this.dihedrals[counter] = Math.PI;
                    }
                } else {
                    this.dihedrals[counter] = -1.0;
                }
            }
            ++counter;
        }
    }

    public void zmatrixChainToCartesian(IAtomContainer molecule, boolean flagBranched) {
        Point3d result = null;
        for (int index = 0; index < this.distances.length; ++index) {
            if (index == 0) {
                result = new Point3d(0.0, 0.0, 0.0);
            } else if (index == 1) {
                result = new Point3d(this.distances[1], 0.0, 0.0);
            } else if (index == 2) {
                result = new Point3d(-Math.cos(this.angles[2] / 180.0 * Math.PI) * this.distances[2] + this.distances[1], Math.sin(this.angles[2] / 180.0 * Math.PI) * this.distances[2], 0.0);
            } else {
                Vector3d cd = new Vector3d();
                cd.sub((Tuple3d)molecule.getAtom(this.thirdAtoms[index]).getPoint3d(), (Tuple3d)molecule.getAtom(this.secondAtoms[index]).getPoint3d());
                Vector3d bc = new Vector3d();
                bc.sub((Tuple3d)molecule.getAtom(this.secondAtoms[index]).getPoint3d(), (Tuple3d)molecule.getAtom(this.firstAtoms[index - 3]).getPoint3d());
                Vector3d n1 = new Vector3d();
                n1.cross(cd, bc);
                n1.normalize();
                Vector3d n2 = null;
                n2 = index == 3 && flagBranched ? AtomTetrahedralLigandPlacer3D.rotate(n1, bc, 0.0) : AtomTetrahedralLigandPlacer3D.rotate(n1, bc, this.dihedrals[index]);
                n2.normalize();
                Vector3d ba = new Vector3d();
                if (index == 3 && flagBranched) {
                    ba = AtomTetrahedralLigandPlacer3D.rotate(cd, n2, -this.angles[index] / 180.0 * Math.PI);
                    ba = AtomTetrahedralLigandPlacer3D.rotate(ba, cd, -this.angles[index] / 180.0 * Math.PI);
                } else {
                    ba = AtomTetrahedralLigandPlacer3D.rotate(cd, n2, -this.angles[index] / 180.0 * Math.PI);
                }
                ba.normalize();
                Vector3d ban = new Vector3d(ba);
                ban.scale(this.distances[index]);
                result = new Point3d();
                result.add((Tuple3d)molecule.getAtom(this.firstAtoms[index - 1]).getPoint3d(), (Tuple3d)ban);
            }
            IAtom atom = molecule.getAtom(this.firstAtoms[index]);
            if (atom.getPoint3d() != null && atom.getFlag(1) || atom.getFlag(2) || !this.isHeavyAtom(atom)) continue;
            atom.setPoint3d(result);
            atom.setFlag(1, true);
        }
    }

    private int getHybridisationState(IAtom atom1) {
        IBond.Order maxBondOrder = atom1.getMaxBondOrder();
        if (atom1.getFormalNeighbourCount() != 1) {
            if (atom1.getFormalNeighbourCount() == 2 || maxBondOrder == IBond.Order.TRIPLE) {
                return 1;
            }
            if (atom1.getFormalNeighbourCount() == 3 || maxBondOrder == IBond.Order.DOUBLE) {
                return 2;
            }
            return 3;
        }
        return -1;
    }

    private int getDoubleBondConfiguration2D(IBond bond, Point2d a, Point2d b, Point2d c, Point2d d) throws CDKException {
        if (bond.getOrder() != IBond.Order.DOUBLE) {
            return 0;
        }
        if (a == null || b == null || c == null || d == null) {
            return 0;
        }
        Point2d cb = new Point2d(c.x - b.x, c.y - b.y);
        Point2d xT = new Point2d(cb.x - 1.0, cb.y);
        a.y = a.y - b.y - xT.y;
        d.y = d.y - b.y - xT.y;
        if (a.y > 0.0 && d.y > 0.0 || a.y < 0.0 && d.y < 0.0) {
            return 5;
        }
        return 6;
    }

    public double getBondLengthValue(String id1, String id2) {
        String dkey = "";
        if (this.pSet.containsKey("bond" + id1 + ";" + id2)) {
            dkey = "bond" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("bond" + id2 + ";" + id1)) {
            dkey = "bond" + id2 + ";" + id1;
        } else {
            this.logger.warn((Object)("KEYError: Unknown distance key in pSet: " + id2 + ";" + id1 + " take default bond length: " + 1.5));
            return 1.5;
        }
        return (Double)this.pSet.get(dkey).get(0);
    }

    public double getAngleValue(String id1, String id2, String id3) {
        String akey = "";
        if (this.pSet.containsKey("angle" + id1 + ";" + id2 + ";" + id3)) {
            akey = "angle" + id1 + ";" + id2 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id2 + ";" + id1)) {
            akey = "angle" + id3 + ";" + id2 + ";" + id1;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id1 + ";" + id3)) {
            akey = "angle" + id2 + ";" + id1 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id1 + ";" + id3 + ";" + id2)) {
            akey = "angle" + id1 + ";" + id3 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id1 + ";" + id2)) {
            akey = "angle" + id3 + ";" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id3 + ";" + id1)) {
            akey = "angle" + id2 + ";" + id3 + ";" + id1;
        } else {
            return -1.0;
        }
        return (Double)this.pSet.get(akey).get(0);
    }

    public IAtom getNextUnplacedHeavyAtomWithAliphaticPlacedNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            if (bond.getBegin().getFlag(1) && !bond.getEnd().getFlag(1) && this.isAliphaticHeavyAtom(bond.getEnd())) {
                return bond.getEnd();
            }
            if (!bond.getEnd().getFlag(1) || bond.getBegin().getFlag(1) || !this.isAliphaticHeavyAtom(bond.getBegin())) continue;
            return bond.getBegin();
        }
        return null;
    }

    IAtom getUnplacedHeavyAtom(IAtomContainer molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (!this.isUnplacedHeavyAtom(atom)) continue;
            return atom;
        }
        return null;
    }

    public IAtom getNextPlacedHeavyAtomWithUnplacedAliphaticNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            IAtom atom0 = bond.getBegin();
            IAtom atom1 = bond.getEnd();
            if (atom0.getFlag(1) && !atom1.getFlag(1) && this.isAliphaticHeavyAtom(atom1) && this.isHeavyAtom(atom0)) {
                return atom0;
            }
            if (!atom1.getFlag(1) || atom0.getFlag(1) || !this.isAliphaticHeavyAtom(atom0) || !this.isHeavyAtom(atom1)) continue;
            return atom1;
        }
        return null;
    }

    public IAtom getNextPlacedHeavyAtomWithUnplacedRingNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            IAtom atom0 = bond.getBegin();
            IAtom atom1 = bond.getEnd();
            if (atom0.getFlag(1) && !atom1.getFlag(1) && this.isRingHeavyAtom(atom1) && this.isHeavyAtom(atom0)) {
                return atom0;
            }
            if (!atom1.getFlag(1) || atom0.getFlag(1) || !this.isRingHeavyAtom(atom0) || !this.isHeavyAtom(atom1)) continue;
            return atom1;
        }
        return null;
    }

    public IAtom getFarthestAtom(Point3d refAtomPoint, IAtomContainer ac) {
        double distance = 0.0;
        IAtom atom = null;
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getPoint3d() == null || !(Math.abs(refAtomPoint.distance(ac.getAtom(i).getPoint3d())) > distance)) continue;
            atom = ac.getAtom(i);
            distance = Math.abs(refAtomPoint.distance(ac.getAtom(i).getPoint3d()));
        }
        return atom;
    }

    public IAtom getUnplacedRingHeavyAtom(IAtomContainer molecule, IAtom atom) {
        List bonds = molecule.getConnectedBondsList(atom);
        IAtom connectedAtom = null;
        for (IBond bond : bonds) {
            connectedAtom = bond.getOther(atom);
            if (!this.isUnplacedHeavyAtom(connectedAtom) || !connectedAtom.getFlag(2)) continue;
            return connectedAtom;
        }
        return connectedAtom;
    }

    public Point3d geometricCenterAllPlacedAtoms(IAtomContainer molecule) {
        IAtomContainer allPlacedAtoms = this.getAllPlacedAtoms(molecule);
        return GeometryUtil.get3DCenter((IAtomContainer)allPlacedAtoms);
    }

    public IAtom getPlacedHeavyAtom(IAtomContainer molecule, IAtom atom) {
        List bonds = molecule.getConnectedBondsList(atom);
        for (IBond bond : bonds) {
            IAtom connectedAtom = bond.getOther(atom);
            if (!this.isPlacedHeavyAtom(connectedAtom)) continue;
            return connectedAtom;
        }
        return null;
    }

    public IAtom getPlacedHeavyAtom(IAtomContainer molecule, IAtom atomA, IAtom atomB) {
        List bonds = molecule.getConnectedBondsList(atomA);
        for (IBond bond : bonds) {
            IAtom connectedAtom = bond.getOther(atomA);
            if (!this.isPlacedHeavyAtom(connectedAtom) || connectedAtom.equals(atomB)) continue;
            return connectedAtom;
        }
        return null;
    }

    public IAtomContainer getPlacedHeavyAtoms(IAtomContainer molecule, IAtom atom) {
        List bonds = molecule.getConnectedBondsList(atom);
        IAtomContainer connectedAtoms = (IAtomContainer)molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom connectedAtom = null;
        for (IBond bond : bonds) {
            connectedAtom = bond.getOther(atom);
            if (!this.isPlacedHeavyAtom(connectedAtom)) continue;
            connectedAtoms.addAtom(connectedAtom);
        }
        return connectedAtoms;
    }

    public int numberOfUnplacedHeavyAtoms(IAtomContainer ac) {
        int nUnplacedHeavyAtoms = 0;
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (!this.isUnplacedHeavyAtom(ac.getAtom(i))) continue;
            ++nUnplacedHeavyAtoms;
        }
        return nUnplacedHeavyAtoms;
    }

    private IAtomContainer getAllPlacedAtoms(IAtomContainer molecule) {
        AtomContainer placedAtoms = new AtomContainer();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            if (!molecule.getAtom(i).getFlag(1)) continue;
            placedAtoms.addAtom(molecule.getAtom(i));
        }
        return placedAtoms;
    }

    public boolean allHeavyAtomsPlaced(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (!this.isUnplacedHeavyAtom(ac.getAtom(i))) continue;
            return false;
        }
        return true;
    }

    boolean isUnplacedHeavyAtom(IAtom atom) {
        return !atom.getFlag(1) && this.isHeavyAtom(atom);
    }

    boolean isPlacedHeavyAtom(IAtom atom) {
        return atom.getFlag(1) && this.isHeavyAtom(atom);
    }

    boolean isAliphaticHeavyAtom(IAtom atom) {
        return atom.getFlag(8) && this.isHeavyAtom(atom);
    }

    boolean isRingHeavyAtom(IAtom atom) {
        return atom.getFlag(2) && this.isHeavyAtom(atom);
    }

    boolean isHeavyAtom(IAtom atom) {
        return atom.getAtomicNumber() != 1;
    }
}

