/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.Constants;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        for (byte element : b) {
            needle.append((char)(element & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern;
        if (innerString) {
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                pattern = ".*" + pattern;
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = pattern + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

