/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.template.internal.CompilerMessageSuppressor;
import org.openrewrite.java.template.internal.JavacTreeMaker;
import org.openrewrite.java.template.internal.Permit;
import org.openrewrite.java.template.internal.TreeMirrorMaker;

public class JavacResolution {
    private final Context context;
    private final Attr attr;
    private final CompilerMessageSuppressor messageSuppressor;
    private final TreeMirrorMaker mirrorMaker;
    private final Log log;
    private static Field memberEnterDotEnv;

    public JavacResolution(Context context) {
        this.context = context;
        this.attr = Attr.instance(context);
        this.messageSuppressor = new CompilerMessageSuppressor(context);
        this.mirrorMaker = new TreeMirrorMaker(new JavacTreeMaker(TreeMaker.instance(context)));
        this.log = Log.instance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Map<JCTree, JCTree> resolveAll(final Context context, final JCTree.JCCompilationUnit cu, final List<? extends Tree> trees) {
        this.messageSuppressor.disableLoggers();
        try {
            Map<JCTree, JCTree> map = new TreeScanner(){
                Map<JCTree, JCTree> resolved = null;
                private final Stack<JCTree> cursor = new Stack();

                public Map<JCTree, JCTree> resolved(JCTree.JCCompilationUnit cu2) {
                    this.scan(cu2);
                    return this.resolved;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void scan(JCTree tree) {
                    this.cursor.push(tree);
                    for (Tree t : trees) {
                        if (t != tree) continue;
                        EnvFinder finder = new EnvFinder(context);
                        for (JCTree p : this.cursor) {
                            p.accept(finder);
                        }
                        JCTree copy = JavacResolution.this.mirrorMaker.copy(finder.copyAt());
                        JavaFileObject oldFileObject = JavacResolution.this.log.useSource(cu.getSourceFile());
                        try {
                            JavacResolution.this.memberEnterAndAttribute(copy, finder.get(), context);
                            this.resolved = JavacResolution.this.mirrorMaker.getOriginalToCopyMap();
                        }
                        finally {
                            JavacResolution.this.log.useSource(oldFileObject);
                        }
                        return;
                    }
                    super.scan(tree);
                    this.cursor.pop();
                }
            }.resolved(cu);
            return map;
        }
        finally {
            this.messageSuppressor.enableLoggers();
        }
    }

    private static Field getMemberEnterDotEnv() {
        if (memberEnterDotEnv != null) {
            return memberEnterDotEnv;
        }
        try {
            memberEnterDotEnv = Permit.getField(MemberEnter.class, "env");
            return memberEnterDotEnv;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Env<AttrContext> getEnvOfMemberEnter(MemberEnter memberEnter) {
        Field f = JavacResolution.getMemberEnterDotEnv();
        try {
            return (Env)f.get(memberEnter);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setEnvOfMemberEnter(MemberEnter memberEnter, Env<AttrContext> env) {
        Field f = JavacResolution.getMemberEnterDotEnv();
        try {
            f.set(memberEnter, env);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberEnterAndAttribute(JCTree copy, Env<AttrContext> env, Context context) {
        MemberEnter memberEnter = MemberEnter.instance(context);
        Env<AttrContext> oldEnv = JavacResolution.getEnvOfMemberEnter(memberEnter);
        JavacResolution.setEnvOfMemberEnter(memberEnter, env);
        try {
            copy.accept(memberEnter);
        }
        catch (Exception exception) {
        }
        finally {
            JavacResolution.setEnvOfMemberEnter(memberEnter, oldEnv);
        }
        this.attrib(copy, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attrib(JCTree tree, Env<AttrContext> env) {
        block10: {
            if (env == null || env.enclClass == null) {
                return;
            }
            if (env.enclClass.type == null) {
                try {
                    env.enclClass.type = Type.noType;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Map<?, ?> cache = null;
            try {
                cache = ArgumentAttrReflect.enableTempCache(this.context);
                if (tree instanceof JCTree.JCBlock) {
                    this.attr.attribStat(tree, env);
                    break block10;
                }
                if (tree instanceof JCTree.JCMethodDecl) {
                    this.attr.attribStat(((JCTree.JCMethodDecl)tree).body, env);
                    break block10;
                }
                if (tree instanceof JCTree.JCVariableDecl) {
                    this.attr.attribStat(tree, env);
                    break block10;
                }
                throw new IllegalStateException("Called with something that isn't a block, method decl, or variable decl");
            }
            finally {
                ArgumentAttrReflect.restoreCache(cache, this.context);
            }
        }
    }

    private static class ArgumentAttrReflect {
        private static Method INSTANCE;
        private static Field ARGUMENT_TYPE_CACHE;

        private ArgumentAttrReflect() {
        }

        public static @Nullable Map<?, ?> enableTempCache(Context context) {
            if (ARGUMENT_TYPE_CACHE == null) {
                return null;
            }
            try {
                Object argumentAttr = INSTANCE.invoke(null, context);
                Map cache = (Map)Permit.get(ARGUMENT_TYPE_CACHE, argumentAttr);
                Permit.set(ARGUMENT_TYPE_CACHE, argumentAttr, new LinkedHashMap(cache));
                return cache;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static void restoreCache(Map<?, ?> cache, Context context) {
            if (ARGUMENT_TYPE_CACHE == null) {
                return;
            }
            try {
                Object argumentAttr = INSTANCE.invoke(null, context);
                Permit.set(ARGUMENT_TYPE_CACHE, argumentAttr, cache);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            try {
                Class<?> argumentAttr = Class.forName("com.sun.tools.javac.comp.ArgumentAttr");
                INSTANCE = argumentAttr.getMethod("instance", Context.class);
                ARGUMENT_TYPE_CACHE = Permit.getField(argumentAttr, "argumentTypeCache");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class EnvFinder
    extends JCTree.Visitor {
        private Env<AttrContext> env;
        private final Enter enter;
        private final MemberEnter memberEnter;
        private JCTree copyAt;

        EnvFinder(Context context) {
            this.enter = Enter.instance(context);
            this.memberEnter = MemberEnter.instance(context);
        }

        Env<AttrContext> get() {
            return this.env;
        }

        JCTree copyAt() {
            return this.copyAt;
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.enter.getTopLevelEnv(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            if (tree.sym != null) {
                this.env = this.enter.getClassEnv(tree.sym);
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getMethodEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getInitEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.copyAt != null) {
                return;
            }
            this.copyAt = tree;
        }

        @Override
        public void visitTree(JCTree that) {
        }
    }
}

