/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;

@JsonIgnoreType
public class MavenMetadataFailures
extends DataTable<Row> {
    public MavenMetadataFailures(Recipe recipe) {
        super(recipe, "Maven metadata failures", "Attempts to resolve maven metadata that failed.");
    }

    public MavenMetadata insertRows(ExecutionContext ctx, MavenMetadataDownloader download) throws MavenDownloadingException {
        try {
            return download.download();
        }
        catch (MavenDownloadingException e) {
            GroupArtifactVersion failedOn = e.getFailedOn();
            for (Map.Entry<MavenRepository, String> repositoryResponse : e.getRepositoryResponses().entrySet()) {
                this.insertRow(ctx, new Row(failedOn.getGroupId(), failedOn.getArtifactId(), failedOn.getVersion(), repositoryResponse.getKey().getUri(), repositoryResponse.getKey().getSnapshots(), repositoryResponse.getKey().getReleases(), repositoryResponse.getValue()));
            }
            throw e;
        }
    }

    public static interface MavenMetadataDownloader {
        public MavenMetadata download() throws MavenDownloadingException;
    }

    public static final class Row {
        @Column(displayName="Group id", description="The groupId of the artifact for which the metadata download failed.")
        private final String group;
        @Column(displayName="Artifact id", description="The artifactId of the artifact for which the metadata download failed.")
        private final String artifactId;
        @Column(displayName="Version", description="The version of the artifact for which the metadata download failed.")
        private final String version;
        @Column(displayName="Maven repository", description="The URL of the Maven repository that the metadata download failed on.")
        private final String mavenRepositoryUri;
        @Column(displayName="Snapshots", description="Does the repository support snapshots.")
        private final String snapshots;
        @Column(displayName="Releases", description="Does the repository support releases.")
        private final String releases;
        @Column(displayName="Failure", description="The reason the metadata download failed.")
        private final String failure;

        @Generated
        public Row(String group, String artifactId, String version, String mavenRepositoryUri, String snapshots, String releases, String failure) {
            this.group = group;
            this.artifactId = artifactId;
            this.version = version;
            this.mavenRepositoryUri = mavenRepositoryUri;
            this.snapshots = snapshots;
            this.releases = releases;
            this.failure = failure;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getMavenRepositoryUri() {
            return this.mavenRepositoryUri;
        }

        @Generated
        public String getSnapshots() {
            return this.snapshots;
        }

        @Generated
        public String getReleases() {
            return this.releases;
        }

        @Generated
        public String getFailure() {
            return this.failure;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$mavenRepositoryUri = this.getMavenRepositoryUri();
            String other$mavenRepositoryUri = other.getMavenRepositoryUri();
            if (this$mavenRepositoryUri == null ? other$mavenRepositoryUri != null : !this$mavenRepositoryUri.equals(other$mavenRepositoryUri)) {
                return false;
            }
            String this$snapshots = this.getSnapshots();
            String other$snapshots = other.getSnapshots();
            if (this$snapshots == null ? other$snapshots != null : !this$snapshots.equals(other$snapshots)) {
                return false;
            }
            String this$releases = this.getReleases();
            String other$releases = other.getReleases();
            if (this$releases == null ? other$releases != null : !this$releases.equals(other$releases)) {
                return false;
            }
            String this$failure = this.getFailure();
            String other$failure = other.getFailure();
            return !(this$failure == null ? other$failure != null : !this$failure.equals(other$failure));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $mavenRepositoryUri = this.getMavenRepositoryUri();
            result = result * 59 + ($mavenRepositoryUri == null ? 43 : $mavenRepositoryUri.hashCode());
            String $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : $snapshots.hashCode());
            String $releases = this.getReleases();
            result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
            String $failure = this.getFailure();
            result = result * 59 + ($failure == null ? 43 : $failure.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenMetadataFailures.Row(group=" + this.getGroup() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", mavenRepositoryUri=" + this.getMavenRepositoryUri() + ", snapshots=" + this.getSnapshots() + ", releases=" + this.getReleases() + ", failure=" + this.getFailure() + ")";
        }
    }
}

