/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.graph.DependencyGraph;
import org.openrewrite.maven.graph.DependencyTreeWalker;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.table.ExplainDependenciesInUse;
import org.openrewrite.maven.trait.MavenDependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse(this);
    private final transient ExplainDependenciesInUse explainDependenciesInUse = new ExplainDependenciesInUse(this);
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. All scopes are searched by default.", valid={"compile", "test", "runtime", "provided", "system"}, example="compile", required=false)
    private final @Nullable String scope;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Only direct", description="If enabled, transitive dependencies will not be considered. All dependencies are searched by default.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;

    public Validated<Object> validate() {
        Validated v = super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid)).and(Validated.test((String)"coordinates", (String)"groupIdPattern AND artifactIdPattern must not both be generic wildcards", (Object)((Object)this), r -> !"*".equals(r.groupIdPattern) || !"*".equals(this.artifactIdPattern)));
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public String getDisplayName() {
        return "Maven dependency insight";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupIdPattern, this.artifactIdPattern);
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and scope. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Scope requestedScope = this.scope == null ? null : Scope.fromName(this.scope);
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                String projectName = document.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                String sourceSetName = document.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("main");
                HashMap<String, Map<ResolvedGroupArtifactVersion, DependencyGraph>> dependencyPathsByScope = new HashMap<String, Map<ResolvedGroupArtifactVersion, DependencyGraph>>();
                DependencyTreeWalker.Matches<Scope> matches = new DependencyTreeWalker.Matches<Scope>();
                this.collectMatchingDependencies(this.getResolutionResult(), dependencyPathsByScope, requestedScope, matches);
                if (matches.isEmpty()) {
                    return document;
                }
                for (Map.Entry scopeEntry : dependencyPathsByScope.entrySet()) {
                    for (Map.Entry entry : ((Map)scopeEntry.getValue()).entrySet()) {
                        ResolvedGroupArtifactVersion gav = (ResolvedGroupArtifactVersion)entry.getKey();
                        DependencyInsight.this.dependenciesInUse.insertRow(ctx, new DependenciesInUse.Row(projectName, sourceSetName, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getDatedSnapshotVersion(), (String)scopeEntry.getKey(), ((DependencyGraph)entry.getValue()).getSize()));
                        DependencyInsight.this.explainDependenciesInUse.insertRow(ctx, new ExplainDependenciesInUse.Row(projectName, sourceSetName, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getDatedSnapshotVersion(), (String)scopeEntry.getKey(), ((DependencyGraph)entry.getValue()).getSize(), ((DependencyGraph)entry.getValue()).print()));
                    }
                }
                return (Xml.Document)new MarkIndividualDependency(DependencyInsight.this.onlyDirect, matches.byScope(), matches.byDirectDependency()).visitNonNull((Tree)document, ctx);
            }

            private void collectMatchingDependencies(MavenResolutionResult resolutionResult, Map<String, Map<ResolvedGroupArtifactVersion, DependencyGraph>> dependencyPathsByConfiguration, @Nullable Scope requestedScope2, DependencyTreeWalker.Matches<Scope> matches) {
                VersionComparator versionComparator = DependencyInsight.this.version != null ? (VersionComparator)Semver.validate((String)DependencyInsight.this.version, null).getValue() : null;
                DependencyMatcher dependencyMatcher = new DependencyMatcher(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern, versionComparator);
                for (Map.Entry<Scope, List<ResolvedDependency>> entry : resolutionResult.getDependencies().entrySet()) {
                    Scope scope = entry.getKey();
                    if (requestedScope2 != null && requestedScope2 != scope) continue;
                    for (ResolvedDependency dependency : entry.getValue()) {
                        matches.collect(scope, dependency, dependencyMatcher, (matched, path) -> dependencyPathsByConfiguration.computeIfAbsent(scope.name().toLowerCase(), __ -> new HashMap()).computeIfAbsent(matched.getGav(), __ -> new DependencyGraph()).append(scope.name().toLowerCase(), path));
                    }
                }
            }
        };
    }

    @Generated
    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String scope, @Nullable String version, @Nullable Boolean onlyDirect) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
        this.version = version;
        this.onlyDirect = onlyDirect;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public ExplainDependenciesInUse getExplainDependenciesInUse() {
        return this.explainDependenciesInUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + (Object)((Object)this.getDependenciesInUse()) + ", explainDependenciesInUse=" + (Object)((Object)this.getExplainDependenciesInUse()) + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ", version=" + this.getVersion() + ", onlyDirect=" + this.getOnlyDirect() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    private static final class MarkIndividualDependency
    extends MavenIsoVisitor<ExecutionContext> {
        private final @Nullable Boolean onlyDirect;
        private final Map<Scope, Set<GroupArtifactVersion>> scopeToDirectDependency;
        private final Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency;

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            if (!this.isDependencyTag()) {
                return t;
            }
            Scope tagScope = Scope.fromName(tag.getChildValue("scope").orElse("compile"));
            for (Map.Entry<Scope, Set<GroupArtifactVersion>> entry : this.scopeToDirectDependency.entrySet()) {
                if (tagScope != entry.getKey() && !tagScope.isInClasspathOf(entry.getKey())) continue;
                return new MavenDependency.Matcher().get(this.getCursor()).map(dependency -> {
                    ResolvedGroupArtifactVersion gav = dependency.getResolvedDependency().getGav();
                    Optional<GroupArtifactVersion> scopeGav = ((Set)entry.getValue()).stream().filter(dep -> dep.asGroupArtifact().equals(gav.asGroupArtifact())).findAny();
                    if (scopeGav.isPresent()) {
                        Set<GroupArtifactVersion> mark = this.directDependencyToTargetDependency.get(gav.asGroupArtifactVersion());
                        if (mark == null) {
                            return null;
                        }
                        String resultText = mark.stream().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).sorted().collect(Collectors.joining(","));
                        if (!resultText.isEmpty()) {
                            if (Boolean.TRUE.equals(this.onlyDirect)) {
                                if (mark.stream().anyMatch(target -> gav.asGroupArtifactVersion().equals(target))) {
                                    return (Xml.Tag)SearchResult.found((Tree)t, (String)resultText);
                                }
                            } else {
                                return (Xml.Tag)SearchResult.found((Tree)t, (String)resultText);
                            }
                        }
                    }
                    return null;
                }).orElse(t);
            }
            return t;
        }

        @Generated
        public MarkIndividualDependency(@Nullable Boolean onlyDirect, Map<Scope, Set<GroupArtifactVersion>> scopeToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency) {
            this.onlyDirect = onlyDirect;
            this.scopeToDirectDependency = scopeToDirectDependency;
            this.directDependencyToTargetDependency = directDependencyToTargetDependency;
        }

        @Generated
        public @Nullable Boolean getOnlyDirect() {
            return this.onlyDirect;
        }

        @Generated
        public Map<Scope, Set<GroupArtifactVersion>> getScopeToDirectDependency() {
            return this.scopeToDirectDependency;
        }

        @Generated
        public Map<GroupArtifactVersion, Set<GroupArtifactVersion>> getDirectDependencyToTargetDependency() {
            return this.directDependencyToTargetDependency;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyInsight.MarkIndividualDependency(onlyDirect=" + this.getOnlyDirect() + ", scopeToDirectDependency=" + this.getScopeToDirectDependency() + ", directDependencyToTargetDependency=" + this.getDirectDependencyToTargetDependency() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkIndividualDependency)) {
                return false;
            }
            MarkIndividualDependency other = (MarkIndividualDependency)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Boolean this$onlyDirect = this.getOnlyDirect();
            Boolean other$onlyDirect = other.getOnlyDirect();
            if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
                return false;
            }
            Map<Scope, Set<GroupArtifactVersion>> this$scopeToDirectDependency = this.getScopeToDirectDependency();
            Map<Scope, Set<GroupArtifactVersion>> other$scopeToDirectDependency = other.getScopeToDirectDependency();
            if (this$scopeToDirectDependency == null ? other$scopeToDirectDependency != null : !((Object)this$scopeToDirectDependency).equals(other$scopeToDirectDependency)) {
                return false;
            }
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> this$directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> other$directDependencyToTargetDependency = other.getDirectDependencyToTargetDependency();
            return !(this$directDependencyToTargetDependency == null ? other$directDependencyToTargetDependency != null : !((Object)this$directDependencyToTargetDependency).equals(other$directDependencyToTargetDependency));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof MarkIndividualDependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $onlyDirect = this.getOnlyDirect();
            result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
            Map<Scope, Set<GroupArtifactVersion>> $scopeToDirectDependency = this.getScopeToDirectDependency();
            result = result * 59 + ($scopeToDirectDependency == null ? 43 : ((Object)$scopeToDirectDependency).hashCode());
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> $directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            result = result * 59 + ($directDependencyToTargetDependency == null ? 43 : ((Object)$directDependencyToTargetDependency).hashCode());
            return result;
        }
    }
}

