/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.tree.ResolvedDependency;

public interface MavenArtifactCache {
    public static final MavenArtifactCache NOOP = new MavenArtifactCache(){

        @Override
        public @Nullable Path getArtifact(ResolvedDependency dependency) {
            return null;
        }

        @Override
        public @Nullable Path putArtifact(ResolvedDependency dependency, InputStream is, Consumer<Throwable> onError) {
            try {
                is.close();
            }
            catch (IOException e) {
                onError.accept(e);
            }
            return null;
        }
    };

    public @Nullable Path getArtifact(ResolvedDependency var1);

    public @Nullable Path putArtifact(ResolvedDependency var1, InputStream var2, Consumer<Throwable> var3);

    default public @Nullable Path computeArtifact(ResolvedDependency dependency, Callable<@Nullable InputStream> artifactStream, Consumer<Throwable> onError) {
        Path artifact = this.getArtifact(dependency);
        if (artifact == null) {
            try {
                if (artifactStream != null) {
                    artifact = this.putArtifact(dependency, artifactStream.call(), onError);
                }
            }
            catch (Exception e) {
                onError.accept(e);
            }
        }
        return artifact;
    }

    default public MavenArtifactCache orElse(final MavenArtifactCache other) {
        final MavenArtifactCache me = this;
        return new MavenArtifactCache(){

            @Override
            public @Nullable Path getArtifact(ResolvedDependency dependency) {
                Path artifact = me.getArtifact(dependency);
                return artifact == null ? other.getArtifact(dependency) : artifact;
            }

            @Override
            public @Nullable Path putArtifact(ResolvedDependency dependency, InputStream is, Consumer<Throwable> onError) {
                Path artifact = me.putArtifact(dependency, is, onError);
                return artifact == null ? other.putArtifact(dependency, is, onError) : artifact;
            }
        };
    }
}

