/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public class YieldHandler
extends AbstractExpressionHandler {
    public YieldHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "yield", ast, parent);
    }

    @Override
    public void checkIndentation() {
        this.checkYield();
        DetailAST expression = this.getMainAst().getFirstChild();
        if (!TokenUtil.areOnSameLine(this.getMainAst(), expression)) {
            this.checkExpressionSubtree(expression, this.getIndent(), false, false);
        }
    }

    private void checkYield() {
        DetailAST yieldKey = this.getMainAst();
        int columnNo = this.expandedTabsColumnNo(yieldKey);
        if (this.isOnStartOfLine(yieldKey) && !this.getIndent().isAcceptable(columnNo)) {
            this.logError(yieldKey, "", columnNo);
        }
    }
}

