/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.design;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;

@FileStatefulCheck
public final class MutableExceptionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "mutable.exception";
    private static final String DEFAULT_FORMAT = "^.*Exception$|^.*Error$|^.*Throwable$";
    private final Deque<Boolean> checkingStack = new ArrayDeque<Boolean>();
    private Pattern extendedClassNameFormat = Pattern.compile("^.*Exception$|^.*Error$|^.*Throwable$");
    private boolean checking;
    private Pattern format = Pattern.compile("^.*Exception$|^.*Error$|^.*Throwable$");

    public void setExtendedClassNameFormat(Pattern extendedClassNameFormat) {
        this.extendedClassNameFormat = extendedClassNameFormat;
    }

    public void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: {
                this.visitClassDef(ast);
                break;
            }
            case 10: {
                this.visitVariableDef(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14) {
            this.leaveClassDef();
        }
    }

    private void visitClassDef(DetailAST ast) {
        this.checkingStack.push(this.checking);
        this.checking = this.isNamedAsException(ast) && this.isExtendedClassNamedAsException(ast);
    }

    private void leaveClassDef() {
        this.checking = this.checkingStack.pop();
    }

    private void visitVariableDef(DetailAST ast) {
        DetailAST modifiersAST;
        if (this.checking && ast.getParent().getType() == 6 && (modifiersAST = ast.findFirstToken(5)).findFirstToken(39) == null) {
            this.log(ast, MSG_KEY, ast.findFirstToken(58).getText());
        }
    }

    private boolean isNamedAsException(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        return this.format.matcher(className).find();
    }

    private boolean isExtendedClassNamedAsException(DetailAST ast) {
        boolean result = false;
        DetailAST extendsClause = ast.findFirstToken(18);
        if (extendsClause != null) {
            DetailAST currentNode = extendsClause;
            while (currentNode.getLastChild() != null) {
                currentNode = currentNode.getLastChild();
            }
            String extendedClassName = currentNode.getText();
            result = this.extendedClassNameFormat.matcher(extendedClassName).matches();
        }
        return result;
    }
}

