/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.ai;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.util.function.Supplier;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.ai.AIExecutionContextView;
import org.openrewrite.ai.CodeEditRequest;
import org.openrewrite.ai.CodeEditResponse;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markup;

public class JavaAIEditor {
    private static final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Supplier<Cursor> cursor;
    private final HttpSender http;
    private final AIExecutionContextView ctx;

    public JavaAIEditor(Supplier<Cursor> cursor, ExecutionContext context) {
        this.cursor = cursor;
        this.ctx = AIExecutionContextView.view((ExecutionContext)context);
        this.http = HttpSenderExecutionContextView.view((ExecutionContext)context).getHttpSender();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <J2 extends Statement> J2 edit(J2 j, String instruction) {
        String input = j.printTrimmed(this.cursor.get());
        try (HttpSender.Response raw = this.http.post("https://api.openai.com/v1/edits").withHeader("Authorization", "Bearer " + this.ctx.getOpenapiToken().trim()).withContent("application/json", mapper.writeValueAsBytes((Object)new CodeEditRequest(instruction, input))).send();){
            CodeEditResponse response = (CodeEditResponse)mapper.readValue(raw.getBodyAsBytes(), CodeEditResponse.class);
            if (response.getError() != null) {
                Statement statement = (Statement)Markup.warn(j, (Throwable)new IllegalStateException("Code edit failed: " + response.getError()));
                return (J2)statement;
            }
            Statement statement = (Statement)JavaTemplate.builder(((CodeEditResponse.Choice)response.getChoices().get(0)).getText()).contextSensitive().build().apply(this.cursor.get(), j.getCoordinates().replace(), new Object[0]);
            return (J2)statement;
        }
        catch (IOException e) {
            return (J2)((Statement)Markup.warn(j, (Throwable)e));
        }
    }
}

