/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceAnnotation
extends Recipe {
    @Option(displayName="Annotation to replace", description="An annotation matcher, expressed as a method pattern to replace.", example="@org.jetbrains.annotations.NotNull(\"Test\")")
    private final String annotationPatternToReplace;
    @Option(displayName="Annotation template to insert", description="An annotation template to add instead of original one, will be parsed with `JavaTemplate`.", example="@org.jetbrains.annotations.NotNull(\"Null not permitted\")")
    private final String annotationTemplateToInsert;
    @Option(displayName="Classpath resource", description="If the annotation's type is defined by a jar within the META-INF/rewrite/classpath directory provide its name here so that it can be loaded. When this parameter is not passed the runtime classpath of the recipe is provided to the parser producing the new annotation. This is necessary when the annotation is not on the runtime classpath of the recipe and isn't in the Java standard library.", example="annotations", required=false)
    private final @Nullable String classpathResourceName;

    public String getDisplayName() {
        return "Replace annotation";
    }

    public String getDescription() {
        return "Replace an Annotation with another one if the annotation pattern matches. Only fixed parameters can be set in the replacement.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                JavaTemplate.Builder templateBuilder = JavaTemplate.builder(ReplaceAnnotation.this.annotationTemplateToInsert);
                if (ReplaceAnnotation.this.classpathResourceName == null) {
                    templateBuilder.javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath())));
                } else {
                    templateBuilder.javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpathFromResources(ctx, ReplaceAnnotation.this.classpathResourceName)));
                }
                return new ReplaceAnnotationVisitor(new AnnotationMatcher(ReplaceAnnotation.this.annotationPatternToReplace), templateBuilder.build()).visit(tree, ctx);
            }
        };
    }

    @Generated
    public ReplaceAnnotation(String annotationPatternToReplace, String annotationTemplateToInsert, @Nullable String classpathResourceName) {
        this.annotationPatternToReplace = annotationPatternToReplace;
        this.annotationTemplateToInsert = annotationTemplateToInsert;
        this.classpathResourceName = classpathResourceName;
    }

    @Generated
    public String getAnnotationPatternToReplace() {
        return this.annotationPatternToReplace;
    }

    @Generated
    public String getAnnotationTemplateToInsert() {
        return this.annotationTemplateToInsert;
    }

    @Generated
    public @Nullable String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceAnnotation(annotationPatternToReplace=" + this.getAnnotationPatternToReplace() + ", annotationTemplateToInsert=" + this.getAnnotationTemplateToInsert() + ", classpathResourceName=" + this.getClasspathResourceName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceAnnotation)) {
            return false;
        }
        ReplaceAnnotation other = (ReplaceAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$annotationPatternToReplace = this.getAnnotationPatternToReplace();
        String other$annotationPatternToReplace = other.getAnnotationPatternToReplace();
        if (this$annotationPatternToReplace == null ? other$annotationPatternToReplace != null : !this$annotationPatternToReplace.equals(other$annotationPatternToReplace)) {
            return false;
        }
        String this$annotationTemplateToInsert = this.getAnnotationTemplateToInsert();
        String other$annotationTemplateToInsert = other.getAnnotationTemplateToInsert();
        if (this$annotationTemplateToInsert == null ? other$annotationTemplateToInsert != null : !this$annotationTemplateToInsert.equals(other$annotationTemplateToInsert)) {
            return false;
        }
        String this$classpathResourceName = this.getClasspathResourceName();
        String other$classpathResourceName = other.getClasspathResourceName();
        return !(this$classpathResourceName == null ? other$classpathResourceName != null : !this$classpathResourceName.equals(other$classpathResourceName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceAnnotation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationPatternToReplace = this.getAnnotationPatternToReplace();
        result = result * 59 + ($annotationPatternToReplace == null ? 43 : $annotationPatternToReplace.hashCode());
        String $annotationTemplateToInsert = this.getAnnotationTemplateToInsert();
        result = result * 59 + ($annotationTemplateToInsert == null ? 43 : $annotationTemplateToInsert.hashCode());
        String $classpathResourceName = this.getClasspathResourceName();
        result = result * 59 + ($classpathResourceName == null ? 43 : $classpathResourceName.hashCode());
        return result;
    }

    public static final class ReplaceAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher matcher;
        private final JavaTemplate replacement;

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J a = super.visitAnnotation(annotation, ctx);
            if (!this.matcher.matches((J.Annotation)a)) {
                return a;
            }
            this.maybeRemoveImport(TypeUtils.asFullyQualified(((J.Annotation)a).getType()));
            JavaCoordinates replaceCoordinate = ((J.Annotation)a).getCoordinates().replace();
            a = (J.Annotation)this.replacement.apply(this.getCursor(), replaceCoordinate, new Object[0]);
            this.doAfterVisit(this.service(ImportService.class).shortenFullyQualifiedTypeReferencesIn(a));
            return a;
        }

        @Generated
        public ReplaceAnnotationVisitor(AnnotationMatcher matcher, JavaTemplate replacement) {
            this.matcher = matcher;
            this.replacement = replacement;
        }

        @Generated
        public AnnotationMatcher getMatcher() {
            return this.matcher;
        }

        @Generated
        public JavaTemplate getReplacement() {
            return this.replacement;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ReplaceAnnotation.ReplaceAnnotationVisitor(matcher=" + this.getMatcher() + ", replacement=" + this.getReplacement() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceAnnotationVisitor)) {
                return false;
            }
            ReplaceAnnotationVisitor other = (ReplaceAnnotationVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            AnnotationMatcher this$matcher = this.getMatcher();
            AnnotationMatcher other$matcher = other.getMatcher();
            if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                return false;
            }
            JavaTemplate this$replacement = this.getReplacement();
            JavaTemplate other$replacement = other.getReplacement();
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ReplaceAnnotationVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnnotationMatcher $matcher = this.getMatcher();
            result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
            JavaTemplate $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }
    }
}

