/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;

public final class ChangeMethodAccessLevel
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New access level", description="New method access level to apply to the method.", example="public", valid={"private", "protected", "package", "public"})
    private final String newAccessLevel;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean matchOverrides;

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.methodPattern, this.newAccessLevel);
    }

    public String getDisplayName() {
        return "Change method access level";
    }

    public String getDescription() {
        return "Change the access level (public, protected, private, package private) of a method.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"newAccessLevel", (String)"Must be one of 'private', 'protected', 'package', 'public'", (Object)this.newAccessLevel, level -> "private".equals(level) || "protected".equals(level) || "package".equals(level) || "public".equals(level)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        J.Modifier.Type type;
        switch (this.newAccessLevel) {
            case "public": {
                type = J.Modifier.Type.Public;
                break;
            }
            case "protected": {
                type = J.Modifier.Type.Protected;
                break;
            }
            case "private": {
                type = J.Modifier.Type.Private;
                break;
            }
            default: {
                type = null;
            }
        }
        return Preconditions.check(new DeclaresMethod(this.methodPattern, this.matchOverrides), new ChangeMethodAccessLevelVisitor(new MethodMatcher(this.methodPattern, this.matchOverrides), type));
    }

    @Generated
    public ChangeMethodAccessLevel(String methodPattern, String newAccessLevel, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.newAccessLevel = newAccessLevel;
        this.matchOverrides = matchOverrides;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getNewAccessLevel() {
        return this.newAccessLevel;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeMethodAccessLevel(methodPattern=" + this.getMethodPattern() + ", newAccessLevel=" + this.getNewAccessLevel() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodAccessLevel)) {
            return false;
        }
        ChangeMethodAccessLevel other = (ChangeMethodAccessLevel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newAccessLevel = this.getNewAccessLevel();
        String other$newAccessLevel = other.getNewAccessLevel();
        return !(this$newAccessLevel == null ? other$newAccessLevel != null : !this$newAccessLevel.equals(other$newAccessLevel));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeMethodAccessLevel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newAccessLevel = this.getNewAccessLevel();
        result = result * 59 + ($newAccessLevel == null ? 43 : $newAccessLevel.hashCode());
        return result;
    }
}

